/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.ActiveProfilesUtils;
import org.springframework.test.context.support.ApplicationContextInitializerUtils;
import org.springframework.test.context.support.ContextLoaderUtils;
import org.springframework.test.context.support.DefaultTestContext;
import org.springframework.test.context.support.MergedTestPropertySources;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractTestContextBootstrapper
implements TestContextBootstrapper {
    private final Log logger = LogFactory.getLog(this.getClass());
    private BootstrapContext bootstrapContext;

    @Override
    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    @Override
    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    @Override
    public TestContext buildTestContext() {
        return new DefaultTestContext(this.getBootstrapContext().getTestClass(), this.buildMergedContextConfiguration(), this.getCacheAwareContextLoaderDelegate());
    }

    @Override
    public final List<TestExecutionListener> getTestExecutionListeners() {
        Class<?> clazz = this.getBootstrapContext().getTestClass();
        Class<TestExecutionListeners> annotationType = TestExecutionListeners.class;
        ArrayList<Class<? extends TestExecutionListener>> classesList = new ArrayList<Class<? extends TestExecutionListener>>();
        boolean usingDefaults = false;
        MetaAnnotationUtils.AnnotationDescriptor<TestExecutionListeners> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(clazz, annotationType);
        if (descriptor == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("@TestExecutionListeners is not present for class [%s]: using defaults.", clazz.getName()));
            }
            usingDefaults = true;
            classesList.addAll(this.getDefaultTestExecutionListenerClasses());
        } else {
            while (descriptor != null) {
                Class<?> declaringClass = descriptor.getDeclaringClass();
                AnnotationAttributes annAttrs = descriptor.getAnnotationAttributes();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)String.format("Retrieved @TestExecutionListeners attributes [%s] for declaring class [%s].", annAttrs, declaringClass.getName()));
                }
                Class[] listenerClasses = annAttrs.getClassArray("listeners");
                boolean inheritListeners = annAttrs.getBoolean("inheritListeners");
                MetaAnnotationUtils.AnnotationDescriptor<TestExecutionListeners> superDescriptor = MetaAnnotationUtils.findAnnotationDescriptor(descriptor.getRootDeclaringClass().getSuperclass(), annotationType);
                if (!(inheritListeners && superDescriptor != null || annAttrs.getEnum("mergeMode") != TestExecutionListeners.MergeMode.MERGE_WITH_DEFAULTS)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)String.format("Merging default listeners with listeners configured via @TestExecutionListeners for class [%s].", descriptor.getRootDeclaringClass().getName()));
                    }
                    usingDefaults = true;
                    classesList.addAll(this.getDefaultTestExecutionListenerClasses());
                }
                classesList.addAll(0, Arrays.asList(listenerClasses));
                descriptor = inheritListeners ? superDescriptor : null;
            }
        }
        if (usingDefaults) {
            HashSet<Class<? extends TestExecutionListener>> classesSet = new HashSet<Class<? extends TestExecutionListener>>();
            classesSet.addAll(classesList);
            classesList.clear();
            classesList.addAll(classesSet);
        }
        List<TestExecutionListener> listeners = this.instantiateListeners(classesList);
        if (usingDefaults) {
            AnnotationAwareOrderComparator.sort(listeners);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format("Using TestExecutionListeners: %s", listeners));
        }
        return listeners;
    }

    private List<TestExecutionListener> instantiateListeners(List<Class<? extends TestExecutionListener>> classesList) {
        ArrayList<TestExecutionListener> listeners = new ArrayList<TestExecutionListener>(classesList.size());
        for (Class<? extends TestExecutionListener> listenerClass : classesList) {
            NoClassDefFoundError ncdfe;
            block4: {
                ncdfe = null;
                try {
                    listeners.add((TestExecutionListener)BeanUtils.instantiateClass(listenerClass));
                }
                catch (NoClassDefFoundError err) {
                    ncdfe = err;
                }
                catch (BeanInstantiationException ex) {
                    if (!(ex.getCause() instanceof NoClassDefFoundError)) break block4;
                    ncdfe = (NoClassDefFoundError)ex.getCause();
                }
            }
            if (ncdfe == null || !this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)String.format("Could not instantiate TestExecutionListener [%s]. Specify custom listener classes or make the default listener classes (and their required dependencies) available. Offending class: [%s]", listenerClass.getName(), ncdfe.getMessage()));
        }
        return listeners;
    }

    protected Set<Class<? extends TestExecutionListener>> getDefaultTestExecutionListenerClasses() {
        LinkedHashSet<Class<? extends TestExecutionListener>> defaultListenerClasses = new LinkedHashSet<Class<? extends TestExecutionListener>>();
        ClassLoader cl = this.getClass().getClassLoader();
        for (String className : this.getDefaultTestExecutionListenerClassNames()) {
            try {
                defaultListenerClasses.add(ClassUtils.forName((String)className, (ClassLoader)cl));
            }
            catch (Throwable ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Could not load default TestExecutionListener class [" + className + "]. Specify custom listener classes or make the default listener classes available."), ex);
            }
        }
        return defaultListenerClasses;
    }

    protected List<String> getDefaultTestExecutionListenerClassNames() {
        List classNames = SpringFactoriesLoader.loadFactoryNames(TestExecutionListener.class, (ClassLoader)this.getClass().getClassLoader());
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format("Loaded default TestExecutionListener class names from location [%s]: %s", "META-INF/spring.factories", classNames));
        }
        return Collections.unmodifiableList(classNames);
    }

    @Override
    public final MergedContextConfiguration buildMergedContextConfiguration() {
        Class<?> testClass = this.getBootstrapContext().getTestClass();
        CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate = this.getCacheAwareContextLoaderDelegate();
        if (MetaAnnotationUtils.findAnnotationDescriptorForTypes(testClass, ContextConfiguration.class, ContextHierarchy.class) == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("Neither @ContextConfiguration nor @ContextHierarchy found for test class [%s]", testClass.getName()));
            }
            return new MergedContextConfiguration(testClass, null, null, null, null);
        }
        if (AnnotationUtils.findAnnotation(testClass, ContextHierarchy.class) != null) {
            Map<String, List<ContextConfigurationAttributes>> hierarchyMap = ContextLoaderUtils.buildContextHierarchyMap(testClass);
            MergedContextConfiguration parentConfig = null;
            MergedContextConfiguration mergedConfig = null;
            for (List<ContextConfigurationAttributes> list : hierarchyMap.values()) {
                ArrayList<ContextConfigurationAttributes> reversedList = new ArrayList<ContextConfigurationAttributes>(list);
                Collections.reverse(reversedList);
                Assert.notEmpty(reversedList, (String)"ContextConfigurationAttributes list must not be empty");
                Class<?> declaringClass = ((ContextConfigurationAttributes)reversedList.get(0)).getDeclaringClass();
                parentConfig = mergedConfig = this.buildMergedContextConfiguration(declaringClass, reversedList, parentConfig, cacheAwareContextLoaderDelegate);
            }
            return mergedConfig;
        }
        return this.buildMergedContextConfiguration(testClass, ContextLoaderUtils.resolveContextConfigurationAttributes(testClass), null, cacheAwareContextLoaderDelegate);
    }

    private MergedContextConfiguration buildMergedContextConfiguration(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList, MergedContextConfiguration parentConfig, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate) {
        ContextLoader contextLoader = this.resolveContextLoader(testClass, configAttributesList);
        ArrayList<String> locationsList = new ArrayList<String>();
        ArrayList classesList = new ArrayList();
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)String.format("Processing locations and classes for context configuration attributes %s", configAttributes));
            }
            if (contextLoader instanceof SmartContextLoader) {
                SmartContextLoader smartContextLoader = (SmartContextLoader)contextLoader;
                smartContextLoader.processContextConfiguration(configAttributes);
                locationsList.addAll(0, Arrays.asList(configAttributes.getLocations()));
                classesList.addAll(0, Arrays.asList(configAttributes.getClasses()));
            } else {
                String[] processedLocations = contextLoader.processLocations(configAttributes.getDeclaringClass(), configAttributes.getLocations());
                locationsList.addAll(0, Arrays.asList(processedLocations));
            }
            if (configAttributes.isInheritLocations()) continue;
            break;
        }
        String[] locations = StringUtils.toStringArray(locationsList);
        Class[] classes = ClassUtils.toClassArray(classesList);
        Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> initializerClasses = ApplicationContextInitializerUtils.resolveInitializerClasses(configAttributesList);
        String[] activeProfiles = ActiveProfilesUtils.resolveActiveProfiles(testClass);
        MergedTestPropertySources mergedTestPropertySources = TestPropertySourceUtils.buildMergedTestPropertySources(testClass);
        MergedContextConfiguration mergedConfig = new MergedContextConfiguration(testClass, locations, classes, initializerClasses, activeProfiles, mergedTestPropertySources.getLocations(), mergedTestPropertySources.getProperties(), contextLoader, cacheAwareContextLoaderDelegate, parentConfig);
        return this.processMergedContextConfiguration(mergedConfig);
    }

    protected ContextLoader resolveContextLoader(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notNull(testClass, (String)"Class must not be null");
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be empty");
        Class<? extends ContextLoader> contextLoaderClass = this.resolveExplicitContextLoaderClass(configAttributesList);
        if (contextLoaderClass == null && (contextLoaderClass = this.getDefaultContextLoaderClass(testClass)) == null) {
            throw new IllegalStateException("getDefaultContextLoaderClass() must not return null");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("Using ContextLoader class [%s] for test class [%s]", contextLoaderClass.getName(), testClass.getName()));
        }
        return (ContextLoader)BeanUtils.instantiateClass(contextLoaderClass, ContextLoader.class);
    }

    protected Class<? extends ContextLoader> resolveExplicitContextLoaderClass(List<ContextConfigurationAttributes> configAttributesList) {
        Assert.notEmpty(configAttributesList, (String)"ContextConfigurationAttributes list must not be empty");
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            Class<? extends ContextLoader> contextLoaderClass;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)String.format("Resolving ContextLoader for context configuration attributes %s", configAttributes));
            }
            if (ContextLoader.class == (contextLoaderClass = configAttributes.getContextLoaderClass())) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Found explicit ContextLoader class [%s] for context configuration attributes %s", contextLoaderClass.getName(), configAttributes));
            }
            return contextLoaderClass;
        }
        return null;
    }

    protected CacheAwareContextLoaderDelegate getCacheAwareContextLoaderDelegate() {
        return this.getBootstrapContext().getCacheAwareContextLoaderDelegate();
    }

    protected abstract Class<? extends ContextLoader> getDefaultContextLoaderClass(Class<?> var1);

    protected MergedContextConfiguration processMergedContextConfiguration(MergedContextConfiguration mergedConfig) {
        return mergedConfig;
    }
}

