/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.ast.stmt;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.FlashbackQueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivotBase;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableSource;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class OracleSelectJoin
extends SQLJoinTableSource
implements OracleSelectTableSource {
    protected OracleSelectPivotBase pivot;
    protected FlashbackQueryClause flashback;

    public OracleSelectJoin(String alias) {
        super(alias);
    }

    public OracleSelectJoin() {
    }

    @Override
    public FlashbackQueryClause getFlashback() {
        return this.flashback;
    }

    @Override
    public void setFlashback(FlashbackQueryClause flashback) {
        this.flashback = flashback;
    }

    @Override
    public OracleSelectPivotBase getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(OracleSelectPivotBase pivot) {
        this.pivot = pivot;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        this.accept0((OracleASTVisitor)visitor);
    }

    protected void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.left);
            this.acceptChild((SQLASTVisitor)visitor, this.right);
            this.acceptChild((SQLASTVisitor)visitor, this.condition);
            this.acceptChild((SQLASTVisitor)visitor, this.using);
            this.acceptChild((SQLASTVisitor)visitor, this.flashback);
        }
        visitor.endVisit(this);
    }

    @Override
    public void output(StringBuffer buf) {
        this.left.output(buf);
        buf.append(SQLJoinTableSource.JoinType.toString(this.joinType));
        this.right.output(buf);
        if (this.condition != null) {
            buf.append(" ON ");
            this.condition.output(buf);
        }
        if (this.using.size() > 0) {
            buf.append(" USING (");
            int size = this.using.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                ((SQLExpr)this.using.get(i)).output(buf);
            }
            buf.append(")");
        }
    }

    @Override
    public String toString() {
        return SQLUtils.toOracleString(this);
    }
}

