/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.mapping;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Set;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import org.springframework.data.jpa.mapping.JpaPersistentEntityImpl;
import org.springframework.data.jpa.mapping.JpaPersistentProperty;
import org.springframework.data.jpa.mapping.JpaPersistentPropertyImpl;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class JpaMetamodelMappingContext
extends AbstractMappingContext<JpaPersistentEntityImpl<?>, JpaPersistentProperty> {
    private final Set<Metamodel> models;

    public JpaMetamodelMappingContext(Set<Metamodel> models) {
        Assert.notNull(models, (String)"JPA metamodel must not be null!");
        Assert.notEmpty(models, (String)"At least one JPA metamodel must be present!");
        this.models = models;
    }

    public JpaMetamodelMappingContext(Metamodel model) {
        this(Collections.singleton(model));
    }

    protected <T> JpaPersistentEntityImpl<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        return new JpaPersistentEntityImpl<T>(typeInformation, null);
    }

    protected JpaPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, JpaPersistentEntityImpl<?> owner, SimpleTypeHolder simpleTypeHolder) {
        Metamodel metamodel = this.getMetamodelFor(owner.getType());
        return new JpaPersistentPropertyImpl(metamodel, field, descriptor, owner, simpleTypeHolder);
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        return this.getMetamodelFor(type.getType()) != null;
    }

    private Metamodel getMetamodelFor(Class<?> type) {
        for (Metamodel model : this.models) {
            try {
                model.managedType(type);
                return model;
            }
            catch (IllegalArgumentException o_O) {
                for (ManagedType managedType : model.getManagedTypes()) {
                    if (!type.equals(managedType.getJavaType())) continue;
                    return model;
                }
            }
        }
        return null;
    }
}

