/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.CenterPointInfo;
import com.supermap.analyst.networkanalyst.DemandPointInfo;
import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.InternalToolkitNetworkAnalyst;
import com.supermap.analyst.networkanalyst.LocationAnalystParameter;
import com.supermap.analyst.networkanalyst.LocationAnalystResult;
import com.supermap.analyst.networkanalyst.RouteType;
import com.supermap.analyst.networkanalyst.ServiceAreaResult;
import com.supermap.analyst.networkanalyst.SupplyCenters;
import com.supermap.analyst.networkanalyst.TransportationAnalystCheckResult;
import com.supermap.analyst.networkanalyst.TransportationAnalystNative;
import com.supermap.analyst.networkanalyst.TransportationAnalystParameter;
import com.supermap.analyst.networkanalyst.TransportationAnalystResult;
import com.supermap.analyst.networkanalyst.TransportationAnalystSetting;
import com.supermap.analyst.networkanalyst.VRPAnalystParameter;
import com.supermap.analyst.networkanalyst.VehicleInfo;
import com.supermap.analyst.networkanalyst.WeightFieldInfo;
import com.supermap.analyst.networkanalyst.WeightFieldInfos;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfos;
import com.supermap.data.License;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.ProductType;
import com.supermap.data.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportationAnalyst
extends InternalHandleDisposable {
    private TransportationAnalystSetting _$4 = null;
    private boolean _$3 = false;
    private License _$2;
    private long[] _$1 = null;

    public TransportationAnalyst() {
        this._$4();
        this._$1 = new long[3];
        long l = TransportationAnalystNative.jni_New(this._$1);
        this.setHandle(l, true);
        this._$4 = new TransportationAnalystSetting();
        this._$3 = false;
    }

    private void _$4() {
        ArrayList<ProductType> arrayList = InternalToolkitNetworkAnalyst.managerProducts(InternalToolkitNetworkAnalyst.getNetworkAnalystProducts());
        this._$2 = InternalToolkitNetworkAnalyst.verifyLicense(arrayList);
    }

    private void _$3() {
        if (this._$2 != null) {
            this._$2.disconnect();
            this._$2.dispose();
            this._$2 = null;
        }
    }

    private void _$2() {
        int n = this._$2.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    public void dispose() {
        this._$3();
        if (this.getHandle() != 0L) {
            TransportationAnalystNative.jni_Delete(this.getHandle(), this._$1);
            this.setHandle(0L);
            this._$1[0] = 0L;
            this._$1[1] = 0L;
            this._$1[2] = 0L;
            this._$1 = null;
            this.clearHandle();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean load() {
        this._$2();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("load()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this._$4.getNeedSet()) {
            this.setAnalsytSettingToUGC();
        }
        boolean bl3 = this._$4.getNeedLoadModel();
        boolean bl4 = this._$4.getNeedLoadTurnModel();
        if (bl3) {
            Toolkit.clearErrors();
            bl = TransportationAnalystNative.jni_LoadModel(this.getHandle());
            if (!bl) {
                this._$4.setNeedLoadModel(true);
                String string = Toolkit.getLastError();
                throw new IllegalArgumentException(string);
            }
            this._$4.setNeedLoadModel(false);
        } else {
            bl = true;
        }
        if (bl4) {
            DatasetVector datasetVector = this._$4.getTurnDataset();
            if (datasetVector != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) != 0L) {
                bl2 = TransportationAnalystNative.jni_LoadTurnModel(this.getHandle());
            } else {
                TransportationAnalystNative.jni_UnLoadTurnModel(this.getHandle());
                bl2 = true;
            }
            if (bl2) {
                this._$4.setNeedLoadTurnModel(false);
            } else {
                this._$4.setNeedLoadTurnModel(true);
            }
        } else {
            bl2 = true;
        }
        boolean bl5 = true;
        if (bl3 || bl4) {
            // empty if block
        }
        this._$3 = bl && bl2;
        if (!bl) return false;
        if (!bl2) return false;
        if (!bl5) return false;
        return true;
    }

    public TransportationAnalystSetting getAnalystSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnalystSetting()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this._$4;
    }

    public void setAnalystSetting(TransportationAnalystSetting transportationAnalystSetting) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnalystSetting(NetworkAnalystSetting value)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (transportationAnalystSetting == null) {
            String string = InternalResource.loadString("setAnalystSetting(NetworkAnalystSetting value)", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!this.getAnalystSetting().equals(transportationAnalystSetting)) {
            this._$4.copyFrom(transportationAnalystSetting);
        }
    }

    public double updateEdgeWeight(int n, int n2, int n3, String string, double d) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("updateEdgeWeight(int edgeID,int fromNodeID,int toNodeID,String weightField,Double weight)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$1()) {
            String string3 = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("edgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (n2 <= 0) {
            String string5 = InternalResource.loadString("fromNodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (n3 <= 0) {
            String string6 = InternalResource.loadString("toNodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (string == null || string.trim().length() == 0) {
            String string7 = InternalResource.loadString("weightField", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        double d2 = InternalToolkitNetworkAnalyst.DBL_MIN_VALUE;
        double d3 = TransportationAnalystNative.jni_UpdateEdgeWeight(this.getHandle(), n, n2, n3, string, d);
        if (d3 != -1000.0) {
            d2 = d3;
        }
        return d2;
    }

    public double updateTurnNodeWeight(int n, int n2, int n3, String string, double d) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("updateTurnNodeWeight(int nodeID,int fromEdgeID,int toEdgeID,String turnWeightField,double weight)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$1()) {
            String string3 = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("nodeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (n2 <= 0) {
            String string5 = InternalResource.loadString("fromEdgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (n3 <= 0) {
            String string6 = InternalResource.loadString("toEdgeID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (string == null || string.trim().length() == 0) {
            String string7 = InternalResource.loadString("turnWeightField", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        double d2 = InternalToolkitNetworkAnalyst.DBL_MIN_VALUE;
        double d3 = TransportationAnalystNative.jni_UpdateTurnWeightField(this.getHandle(), n, n2, n3, string, d);
        if (d3 != -1000.0) {
            d2 = d3;
        }
        return d2;
    }

    public TransportationAnalystResult findPath(TransportationAnalystParameter transportationAnalystParameter, boolean bl) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPath(TransportationAnalystParameter parameter, boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (transportationAnalystParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!(transportationAnalystParameter.getNodes() != null && transportationAnalystParameter.getNodes().length != 0 || transportationAnalystParameter.getPoints() != null && transportationAnalystParameter.getPoints().getCount() != 0)) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = transportationAnalystParameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            transportationAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        } else if (this._$4.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = transportationAnalystParameter.getTurnWeightField();
        if (null == transportationAnalystParameter.getTurnWeightField()) {
            transportationAnalystParameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        for (int i = 0; i < transportationAnalystParameter.getNodes().length; ++i) {
            if (transportationAnalystParameter.getNodes()[i] >= 0) continue;
            String string5 = InternalResource.loadString("Nodes", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new NullPointerException(string5);
        }
        Toolkit.clearErrors();
        long l2 = TransportationAnalystNative.jni_FindPath(this._$1[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), bl);
        transportationAnalystParameter.setWeightName(string);
        transportationAnalystParameter.setTurnWeightField(string3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)transportationAnalystParameter));
        if (l2 != 0L) {
            return new TransportationAnalystResult(l2);
        }
        String string6 = Toolkit.getLastError();
        throw new IllegalArgumentException(string6);
    }

    public TransportationAnalystResult findTSPPath(TransportationAnalystParameter transportationAnalystParameter, boolean bl) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findTSPPath(TransportationAnalystParameter,parameter, boolean isEndNodeAssigned)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (transportationAnalystParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!(transportationAnalystParameter.getNodes() != null && transportationAnalystParameter.getNodes().length != 0 || transportationAnalystParameter.getPoints() != null && transportationAnalystParameter.getPoints().getCount() != 0)) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = transportationAnalystParameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            transportationAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        } else if (this._$4.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = transportationAnalystParameter.getTurnWeightField();
        if (null == transportationAnalystParameter.getTurnWeightField()) {
            transportationAnalystParameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        long l2 = TransportationAnalystNative.jni_FindTSPPath(this._$1[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), bl);
        transportationAnalystParameter.setWeightName(string);
        transportationAnalystParameter.setTurnWeightField(string3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)transportationAnalystParameter));
        if (l2 != 0L) {
            return new TransportationAnalystResult(l2);
        }
        return null;
    }

    public TransportationAnalystResult findClosestFacility(TransportationAnalystParameter transportationAnalystParameter, int n, int n2, boolean bl, double d) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findClosestFacility(TransportationAnalystParameter parameter, int eventID, int facilityCount, boolean isFromEvent,double maxImpedance)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (transportationAnalystParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!(transportationAnalystParameter.getNodes() != null && transportationAnalystParameter.getNodes().length != 0 || transportationAnalystParameter.getPoints() != null && transportationAnalystParameter.getPoints().getCount() != 0)) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = transportationAnalystParameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            transportationAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        } else if (this._$4.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = transportationAnalystParameter.getTurnWeightField();
        if (null == transportationAnalystParameter.getTurnWeightField()) {
            transportationAnalystParameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (d < 0.0) {
            String string5 = InternalResource.loadString("maxWeight", "TransportationAnalyst_MaxWeightMustEqualsOrGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (n2 <= 0) {
            String string6 = InternalResource.loadString("facilityCount", "TransportationAnalyst_FacilityCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (n <= 0) {
            String string7 = InternalResource.loadString("eventID", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long l2 = TransportationAnalystNative.jni_FindClosestFacility(this._$1[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), n, n2, bl, d);
        transportationAnalystParameter.setWeightName(string);
        transportationAnalystParameter.setTurnWeightField(string3);
        TransportationAnalystResult transportationAnalystResult = null;
        if (l2 != 0L) {
            transportationAnalystResult = new TransportationAnalystResult(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)transportationAnalystParameter));
        return transportationAnalystResult;
    }

    public TransportationAnalystResult findClosestFacility(TransportationAnalystParameter transportationAnalystParameter, Point2D point2D, int n, boolean bl, double d) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findClosestFacility(TransportationAnalystParameter parameter, Point2D eventPoint, int facilityCount,boolean isFromEvent,double maxImpedance)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (transportationAnalystParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!(transportationAnalystParameter.getNodes() != null && transportationAnalystParameter.getNodes().length != 0 || transportationAnalystParameter.getPoints() != null && transportationAnalystParameter.getPoints().getCount() != 0)) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = transportationAnalystParameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            transportationAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        } else if (this._$4.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = transportationAnalystParameter.getTurnWeightField();
        if (null == transportationAnalystParameter.getTurnWeightField()) {
            transportationAnalystParameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (point2D == null) {
            String string5 = InternalResource.loadString("eventPoint", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (d < 0.0) {
            String string6 = InternalResource.loadString("maxWeight", "TransportationAnalyst_MaxWeightMustEqualsOrGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        if (n <= 0) {
            String string7 = InternalResource.loadString("facilityCount", "TransportationAnalyst_FacilityCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long l2 = TransportationAnalystNative.jni_FindClosestFacility2(this._$1[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), point2D.getX(), point2D.getY(), n, bl, d);
        transportationAnalystParameter.setWeightName(string);
        transportationAnalystParameter.setTurnWeightField(string3);
        TransportationAnalystResult transportationAnalystResult = null;
        if (l2 != 0L) {
            transportationAnalystResult = new TransportationAnalystResult(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)transportationAnalystParameter));
        return transportationAnalystResult;
    }

    public TransportationAnalystResult findMTSPPath(TransportationAnalystParameter transportationAnalystParameter, int[] nArray, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FindMTSPPath(TransportationAnalystParameter parameter, int[] centerNodes, boolean hasLeastTotalCost)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (transportationAnalystParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter);
        if (l == 0L) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (transportationAnalystParameter.getNodes() == null || transportationAnalystParameter.getNodes().length == 0) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = transportationAnalystParameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            transportationAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        } else if (this._$4.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = transportationAnalystParameter.getTurnWeightField();
        if (null == transportationAnalystParameter.getTurnWeightField()) {
            transportationAnalystParameter.setTurnWeightField("");
        }
        long l2 = TransportationAnalystNative.jni_findMTSPPath(this._$1[1], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), nArray, bl);
        transportationAnalystParameter.setWeightName(string);
        transportationAnalystParameter.setTurnWeightField(string3);
        TransportationAnalystResult transportationAnalystResult = null;
        if (l2 == 0L) {
            String string4 = Toolkit.getLastError();
            throw new NullPointerException(string4);
        }
        transportationAnalystResult = new TransportationAnalystResult(l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)transportationAnalystParameter));
        return transportationAnalystResult;
    }

    public TransportationAnalystResult findMTSPPath(TransportationAnalystParameter transportationAnalystParameter, Point2Ds point2Ds, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FindMTSPPath(TransportationAnalystParameter parameter, int[] centerNodes, boolean hasLeastTotalCost)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (transportationAnalystParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter);
        if (l == 0L) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = transportationAnalystParameter.getTurnWeightField();
        if (null == transportationAnalystParameter.getTurnWeightField()) {
            transportationAnalystParameter.setTurnWeightField("");
        }
        if (transportationAnalystParameter.getPoints() == null || transportationAnalystParameter.getPoints().getCount() == 0) {
            String string2 = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = transportationAnalystParameter.getWeightName();
        if (string3 == null || string3.trim().length() == 0) {
            transportationAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        } else if (this._$4.getWeightFieldInfos().indexOf(string3) < 0) {
            String string4 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        double[] dArray = null;
        double[] dArray2 = null;
        TransportationAnalystResult transportationAnalystResult = null;
        long l2 = 0L;
        if (point2Ds != null && point2Ds.getCount() != 0) {
            int n = point2Ds.getCount();
            dArray = new double[n];
            dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = point2Ds.getItem(i).getX();
                dArray2[i] = point2Ds.getItem(i).getY();
            }
            l2 = TransportationAnalystNative.jni_findMTSPPath1(this._$1[1], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), dArray, dArray2, bl);
        }
        transportationAnalystParameter.setWeightName(string3);
        transportationAnalystParameter.setTurnWeightField(string);
        if (l2 == 0L) {
            String string5 = Toolkit.getLastError();
            throw new NullPointerException(string5);
        }
        transportationAnalystResult = new TransportationAnalystResult(l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)transportationAnalystParameter));
        return transportationAnalystResult;
    }

    public ServiceAreaResult findServiceArea(TransportationAnalystParameter transportationAnalystParameter, double[] dArray, boolean bl, boolean bl2) {
        long l;
        String string;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("findServiceArea(TransportationAnalystParameter parameter,double[] weights,boolean isFromCenter,boolean isCenterMutuallyExclusive)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$1()) {
            String string3 = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (transportationAnalystParameter == null) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (!(transportationAnalystParameter.getNodes() != null && transportationAnalystParameter.getNodes().length != 0 || transportationAnalystParameter.getPoints() != null && transportationAnalystParameter.getPoints().getCount() != 0)) {
            String string5 = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (dArray == null || dArray.length == 0) {
            String string6 = InternalResource.loadString("weights", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] <= 0.0)) continue;
            String string7 = InternalResource.loadString("weights{" + i + "]", "TransportationAnalyst_WeightShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        if (transportationAnalystParameter.getNodes() != null && transportationAnalystParameter.getNodes().length > 0) {
            if (transportationAnalystParameter.getNodes().length != n) {
                String string8 = InternalResource.loadString("", "TransportationAnalyst_FindServiceAreaWeightCountShouldEqualsCenterPointCount", "networkanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
        } else if (transportationAnalystParameter.getPoints() != null && transportationAnalystParameter.getPoints().getCount() > 0 && transportationAnalystParameter.getPoints().getCount() != n) {
            String string9 = InternalResource.loadString("", "TransportationAnalyst_FindServiceAreaWeightCountShouldEqualsCenterPointCount", "networkanalyst_resources");
            throw new IllegalArgumentException(string9);
        }
        if ((string = transportationAnalystParameter.getWeightName()) == null || string.trim().length() == 0) {
            transportationAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        } else if (this._$4.getWeightFieldInfos().indexOf(string) < 0) {
            String string10 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string10);
        }
        String string11 = transportationAnalystParameter.getTurnWeightField();
        if (null == transportationAnalystParameter.getTurnWeightField()) {
            transportationAnalystParameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter)) == 0L) {
            String string12 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string12);
        }
        long l2 = TransportationAnalystNative.jni_FindServiceArea(this._$1[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), dArray, bl, bl2);
        transportationAnalystParameter.setWeightName(string);
        transportationAnalystParameter.setTurnWeightField(string11);
        ServiceAreaResult serviceAreaResult = null;
        if (l2 != 0L) {
            serviceAreaResult = new ServiceAreaResult(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)transportationAnalystParameter));
        return serviceAreaResult;
    }

    public LocationAnalystResult findLocation(LocationAnalystParameter locationAnalystParameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FindLocation(LocationAnalystParameter parameter)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("LoadModel", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (locationAnalystParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)locationAnalystParameter);
        if (l == 0L) {
            String string = InternalResource.loadString("parameter", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == locationAnalystParameter.getTurnWeightField()) {
            locationAnalystParameter.setTurnWeightField("");
        }
        if (locationAnalystParameter.getSupplyCenters().getCount() <= 0) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_LocationAnalystSupplyCentersCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (locationAnalystParameter.getExpectedSupplyCenterCount() < 0) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_LocationAnalystExceptCentersShouldNotBeNegative", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (locationAnalystParameter.getSupplyCenters().getCount() < locationAnalystParameter.getExpectedSupplyCenterCount()) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_LocationAnalystSupplyCentersCountShouldGreaterThanExpectedCount", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = locationAnalystParameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            locationAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        } else if (this._$4.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = string;
        SupplyCenters supplyCenters = locationAnalystParameter.getSupplyCenters();
        int n = supplyCenters.getCount();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = supplyCenters.get(i).getType().value();
            nArray2[i] = supplyCenters.get(i).getID();
            dArray[i] = supplyCenters.get(i).getResourceValue();
            dArray2[i] = supplyCenters.get(i).getMaxWeight();
        }
        long l2 = TransportationAnalystNative.jni_findLocation(this._$1[2], InternalHandle.getHandle((com.supermap.data.InternalHandle)locationAnalystParameter), nArray, nArray2, dArray, dArray2, string3);
        locationAnalystParameter.setWeightName(string);
        LocationAnalystResult locationAnalystResult = null;
        if (l2 != 0L) {
            locationAnalystResult = new LocationAnalystResult(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)locationAnalystParameter));
        return locationAnalystResult;
    }

    public double[][] computeWeightMatrix(TransportationAnalystParameter transportationAnalystParameter) {
        long l;
        if (this.getHandle() == 0L || this._$1[0] == 0L) {
            String string = InternalResource.loadString("computeWeightMatrix(TransportationAnalystParameter parameter)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (transportationAnalystParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!(transportationAnalystParameter.getNodes() != null && transportationAnalystParameter.getNodes().length != 0 || transportationAnalystParameter.getPoints() != null && transportationAnalystParameter.getPoints().getCount() != 0)) {
            String string = InternalResource.loadString("parameter", "TransportationAnalyst_NodeCountOrPointCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = transportationAnalystParameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            transportationAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        } else if (this._$4.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = transportationAnalystParameter.getTurnWeightField();
        if (null == transportationAnalystParameter.getTurnWeightField()) {
            transportationAnalystParameter.setTurnWeightField("");
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter)) == 0L) {
            String string4 = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string4);
        }
        int n = 0;
        n = transportationAnalystParameter.getPoints() != null && transportationAnalystParameter.getPoints().getCount() != 0 ? transportationAnalystParameter.getPoints().getCount() : transportationAnalystParameter.getNodes().length;
        double[] dArray = new double[n * n];
        boolean bl = TransportationAnalystNative.jni_GetWeightMatrixArray(this._$1[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), dArray);
        double[][] dArray2 = new double[0][0];
        if (bl) {
            dArray2 = new double[n][n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray2[i][j] = dArray[i * n + j];
                }
            }
        }
        transportationAnalystParameter.setWeightName(string);
        transportationAnalystParameter.setTurnWeightField(string3);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)transportationAnalystParameter));
        return dArray2;
    }

    protected void clearHandle() {
        if (this._$4 != null) {
            this._$4 = null;
        }
    }

    void setAnalsytSettingToUGC() {
        String[] stringArray;
        WeightFieldInfos weightFieldInfos;
        if (!this._$4.getNeedSet()) {
            return;
        }
        DatasetVector datasetVector = this._$4.getNetworkDataset();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset()", "TransportationAnalyst_NetworkDatasetHasNotBeenSet", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        DatasetType datasetType = datasetVector.getType();
        if (datasetType != DatasetType.NETWORK) {
            String string = InternalResource.loadString("m_analystSetting.getNetworkDataset().getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        String[] stringArray2 = new String[]{this._$4.getNodeIDField(), this._$4.getEdgeIDField(), this._$4.getFNodeIDField(), this._$4.getTNodeIDField(), this._$4.getTurnNodeIDField(), this._$4.getTurnFEdgeIDField(), this._$4.getTurnTEdgeIDField(), this._$4.getNodeNameField(), this._$4.getEdgeNameField(), this._$4.getRuleField()};
        DatasetVector datasetVector2 = this._$4.getTurnDataset();
        if (datasetVector2 != null && !datasetVector2.isOpen()) {
            datasetVector2.open();
        }
        String[] stringArray3 = this._$4.getTurnWeightFields();
        String[] stringArray4 = this._$4.getFTSingleWayRuleValues();
        String[] stringArray5 = this._$4.getTFSingleWayRuleValues();
        String[] stringArray6 = this._$4.getProhibitedWayRuleValues();
        String[] stringArray7 = this._$4.getTwoWayRuleValues();
        String[] stringArray8 = new String[]{stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3]};
        if (!TransportationAnalyst._$2(stringArray8, datasetVector)) {
            String string = InternalResource.loadString("fields", "TransportationAnalystSetting_FieldIsNotInNetworkDataset", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (datasetVector2 != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector2);
            weightFieldInfos = datasetVector2.getType();
            if (weightFieldInfos != DatasetType.TABULAR) {
                String string = InternalResource.loadString("m_analystSetting.getTurnDataset().getType()", "TransportationAnalyst_DatasetTypeMustBeTabular", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[4] == null || stringArray2[4].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnNodeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[5] == null || stringArray2[5].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnFEdgeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            if (stringArray2[6] == null || stringArray2[6].trim().length() == 0) {
                String string = InternalResource.loadString("m_analystSetting.getTurnTEdgeIDField()", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            stringArray = new String[]{stringArray2[4], stringArray2[5], stringArray2[6]};
            if (!TransportationAnalyst._$1(stringArray, datasetVector2)) {
                String string = InternalResource.loadString("fields", "TransportationAnalystSetting_FieldIsNotInTurnDataset", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!TransportationAnalyst._$1(stringArray3, datasetVector2)) {
                String string = InternalResource.loadString("turnWeightFields", "TransportationAnalystSetting_FieldIsNotInTurnDataset", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((weightFieldInfos = this._$4.getWeightFieldInfos()) == null || weightFieldInfos.getCount() <= 0) {
            stringArray = InternalResource.loadString("m_analystSetting.getWeightFieldInfos()", "TransportationAnalyst_WeightFieldInfoCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException((String)stringArray);
        }
        stringArray = null;
        String[] stringArray9 = null;
        String[] stringArray10 = null;
        int n = weightFieldInfos.getCount();
        stringArray = new String[n];
        stringArray9 = new String[n];
        stringArray10 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = weightFieldInfos.get(i).getName();
            stringArray9[i] = weightFieldInfos.get(i).getFTWeightField();
            stringArray10[i] = weightFieldInfos.get(i).getTFWeightField();
        }
        int[] nArray = this._$4.getBarrierNodes();
        int[] nArray2 = this._$4.getBarrierEdges();
        double d = this._$4.getTolerance();
        String string = this._$4.getEdgeFilter();
        boolean bl = this._$4.getUseBasicLoad();
        TransportationAnalystNative.jni_SetAnalystSettingToUGC(this.getHandle(), l, l2, stringArray2, stringArray, stringArray9, stringArray10, stringArray3, nArray, nArray2, stringArray4, stringArray5, stringArray6, stringArray7, d, string, bl);
        this._$4.setNeedSet(false);
    }

    private boolean _$1() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLoadModelNeeded()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        return this._$4.getNeedSet() || !this._$3;
    }

    private static boolean _$2(String[] stringArray, DatasetVector datasetVector) {
        int n;
        boolean bl = true;
        if (!datasetVector.open()) {
            datasetVector.open();
        }
        FieldInfos fieldInfos = datasetVector.getChildDataset().getFieldInfos();
        boolean bl2 = false;
        for (n = 0; n < fieldInfos.getCount(); ++n) {
            if (fieldInfos.get(n).getName().compareToIgnoreCase(stringArray[0]) != 0) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return bl2;
        }
        bl2 = false;
        fieldInfos = datasetVector.getFieldInfos();
        n = stringArray.length;
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < fieldInfos.getCount(); ++j) {
                if (fieldInfos.get(j).getName().compareToIgnoreCase(stringArray[i]) != 0) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return bl2;
        }
        return bl;
    }

    private static boolean _$1(String[] stringArray, DatasetVector datasetVector) {
        boolean bl = true;
        FieldInfos fieldInfos = datasetVector.getFieldInfos();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < fieldInfos.getCount(); ++j) {
                if (fieldInfos.get(j).getName().compareToIgnoreCase(stringArray[i]) != 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return bl;
        }
        return bl;
    }

    public TransportationAnalystCheckResult check() {
        int n;
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("check()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4.getNeedSet()) {
            this.setAnalsytSettingToUGC();
        }
        int[] nArray = TransportationAnalystNative.jni_CheckNew(this.getHandle(), this._$4.getEdgeIDField(), this._$4.getFNodeIDField(), this._$4.getTNodeIDField(), this._$4.getNodeIDField(), this._$4.getTurnFEdgeIDField(), this._$4.getTurnTEdgeIDField(), this._$4.getTurnNodeIDField());
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap3 = new HashMap<Integer, Integer>();
        if (nArray.length == 3) {
            return new TransportationAnalystCheckResult(hashMap2, hashMap, hashMap3);
        }
        int n3 = 0;
        int n4 = nArray[0];
        int n5 = 1;
        int n6 = nArray[0];
        for (n3 = n5; n3 < n6; n3 += 2) {
            n2 = nArray[n3];
            n = nArray[n3 + 1];
            hashMap2.put(n2, n);
        }
        n5 += n4 + 1;
        n4 = nArray[n6 + 1];
        n6 = n5 + n4 - 1;
        for (n3 = n5; n3 < n6; n3 += 2) {
            n2 = nArray[n3];
            n = nArray[n3 + 1];
            hashMap.put(n2, n);
        }
        n5 += n4 + 1;
        n4 = nArray[n6 + 1];
        n6 = n5 + n4 - 1;
        for (n3 = n5; n3 < n6; n3 += 2) {
            n2 = nArray[n3];
            n = nArray[n3 + 1];
            hashMap3.put(n2, n);
        }
        return new TransportationAnalystCheckResult(hashMap2, hashMap, hashMap3);
    }

    @Deprecated
    public boolean check(ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("check()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4.getNeedSet()) {
            this.setAnalsytSettingToUGC();
        }
        if (arrayList == null) {
            String string = InternalResource.loadString("networks", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (arrayList2 == null) {
            String string = InternalResource.loadString("turns", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = TransportationAnalystNative.jni_Check(this.getHandle(), this._$4.getEdgeIDField(), this._$4.getFNodeIDField(), this._$4.getTNodeIDField(), this._$4.getNodeIDField(), this._$4.getTurnFEdgeIDField(), this._$4.getTurnTEdgeIDField(), this._$4.getTurnNodeIDField());
        boolean bl = true;
        if (nArray.length > 2) {
            bl = false;
        } else if (nArray.length == 2) {
            return bl;
        }
        for (n = 1; n <= nArray[0]; ++n) {
            arrayList.add(nArray[n]);
        }
        for (n = nArray[0] + 2; n < nArray.length; ++n) {
            arrayList2.add(nArray[n]);
        }
        return bl;
    }

    boolean checkWeightField() {
        DatasetVector datasetVector = this._$4.getNetworkDataset();
        if (datasetVector == null) {
            return false;
        }
        for (int i = 0; i < this._$4.getWeightFieldInfos().getCount(); ++i) {
            int n;
            String string = this._$4.getWeightFieldInfos().get(i).getFTWeightField();
            String string2 = this._$4.getWeightFieldInfos().get(i).getTFWeightField();
            FieldInfos fieldInfos = datasetVector.getFieldInfos();
            int n2 = fieldInfos.getCount();
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                String string3 = fieldInfos.get(n).getName();
                if (!string3.equalsIgnoreCase(string)) continue;
                bl = true;
            }
            if (!bl) {
                String string4 = InternalResource.loadString(string, "Global_EnumValueIsError", "networkanalyst_resources");
                throw new IllegalArgumentException(string4);
            }
            n = 0;
            for (int j = 0; j < n2; ++j) {
                String string5 = fieldInfos.get(j).getName();
                if (!string5.equalsIgnoreCase(string2)) continue;
                n = 1;
            }
            if (n != 0) continue;
            String string6 = InternalResource.loadString(string2, "Global_EnumValueIsError", "networkanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        return true;
    }

    private boolean _$1(String string) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("loadModel", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (this.getFileType(string) == 1) {
            String string3 = InternalResource.loadString("loadModel", "FileTypeNotMatch", "networkanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (this.getFileType(string) == -1) {
            String string4 = InternalResource.loadString("loadModel", "FileError", "networkanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        bl = TransportationAnalystNative.jni_LoadModelFromFile(this.getHandle(), string, 0L);
        if (bl) {
            this.getAnalystSettingFromUGC();
            this._$4.setNeedSet(false);
            this._$3 = true;
        } else {
            this._$4.setNeedSet(true);
            this._$3 = false;
        }
        return bl;
    }

    public boolean loadModel(String string, DatasetVector datasetVector) {
        this._$2();
        if (this.getFileType(string) == 0) {
            String string2 = InternalResource.loadString("loadModel", "FileTypeNotMatch", "networkanalyst_resources");
            throw new IllegalStateException(string2);
        }
        if (this.getFileType(string) == -1) {
            String string3 = InternalResource.loadString("loadModel", "FileError", "networkanalyst_resources");
            throw new IllegalStateException(string3);
        }
        if (this.getHandle() == 0L) {
            String string4 = InternalResource.loadString("loadModel", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string4);
        }
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string5 = InternalResource.loadString("m_analystSetting.getNetworkDataset()", "TransportationAnalyst_NetworkDatasetHasNotBeenSet", "networkanalyst_resources");
            throw new IllegalStateException(string5);
        }
        DatasetType datasetType = datasetVector.getType();
        if (datasetType != DatasetType.NETWORK) {
            String string6 = InternalResource.loadString("m_analystSetting.getNetworkDataset().getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalStateException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        boolean bl = false;
        bl = TransportationAnalystNative.jni_LoadModelFromFile(this.getHandle(), string, l);
        if (bl) {
            this.getAnalystSettingFromUGC();
            this._$4.setNetworkDataset(datasetVector);
            this._$4.setNeedSet(false);
            this._$3 = true;
        } else {
            this._$4.setNeedSet(true);
            this._$3 = false;
        }
        return bl;
    }

    public boolean createModel(String string) {
        boolean bl;
        this._$4.setUseBasicLoad(true);
        boolean bl2 = this._$4.getNeedLoadModel();
        boolean bl3 = this._$4.getNeedLoadTurnModel();
        if (bl2 || bl3) {
            bl = this.load();
            if (!bl) {
                return bl;
            }
            if (this.getHandle() == 0L) {
                String string2 = InternalResource.loadString("createModelFile", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
                throw new IllegalStateException(string2);
            }
        }
        bl = false;
        bl = TransportationAnalystNative.jni_SaveModelToFile(this.getHandle(), string);
        this._$4.setUseBasicLoad(false);
        if (bl) {
            TransportationAnalystNative.jni_Delete(this.getHandle(), this._$1);
            this.setHandle(0L);
            long l = TransportationAnalystNative.jni_New(this._$1);
            this.setHandle(l, true);
        }
        return bl;
    }

    void getAnalystSettingFromUGC() {
        String[] stringArray = new String[13];
        int[] nArray = new int[8];
        double[] dArray = new double[1];
        TransportationAnalystNative.jni_GetAnalystFromUGC(this.getHandle(), stringArray, nArray, dArray);
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray[5];
        String string7 = stringArray[6];
        String string8 = stringArray[7];
        String string9 = stringArray[8];
        String string10 = stringArray[9];
        String string11 = stringArray[10];
        String string12 = stringArray[11];
        String string13 = stringArray[12];
        double d = dArray[0];
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4];
        int n6 = nArray[5];
        int n7 = nArray[6];
        int n8 = nArray[7];
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        String[] stringArray5 = null;
        String[] stringArray6 = null;
        String[] stringArray7 = null;
        String[] stringArray8 = null;
        String[] stringArray9 = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        if (n != 0) {
            stringArray2 = new String[n];
            stringArray3 = new String[n];
            stringArray4 = new String[n];
            TransportationAnalystNative.jni_GetWeightInfo(this.getHandle(), stringArray2, stringArray3, stringArray4);
        }
        if (n2 != 0) {
            nArray2 = new int[n2];
            TransportationAnalystNative.jni_GetBarrierNodeID(this.getHandle(), nArray2);
        }
        if (n3 != 0) {
            nArray3 = new int[n3];
            TransportationAnalystNative.jni_GetBarrierEdgeID(this.getHandle(), nArray3);
        }
        if (n4 != 0) {
            stringArray5 = new String[n4];
            TransportationAnalystNative.jni_GetTurnWeightField(this.getHandle(), stringArray5);
        }
        if (n5 != 0 || n6 != 0 || n7 != 0 || n8 != 0) {
            stringArray6 = new String[n5];
            stringArray7 = new String[n6];
            stringArray8 = new String[n7];
            stringArray9 = new String[n8];
            TransportationAnalystNative.jni_GetRuleInfo(this.getHandle(), stringArray6, stringArray7, stringArray8, stringArray9);
        }
        int n9 = 0;
        this._$4.setEdgeIDField(string2);
        this._$4.setNodeIDField(string3);
        this._$4.setFNodeIDField(string4);
        this._$4.setTNodeIDField(string5);
        WeightFieldInfos weightFieldInfos = new WeightFieldInfos();
        if (stringArray2.length == n && stringArray3.length == n && stringArray4.length == n) {
            for (n9 = 0; n9 < n; ++n9) {
                WeightFieldInfo weightFieldInfo = new WeightFieldInfo();
                weightFieldInfo.setName(stringArray2[n9]);
                weightFieldInfo.setFTWeightField(stringArray3[n9]);
                weightFieldInfo.setTFWeightField(stringArray4[n9]);
                weightFieldInfos.add(weightFieldInfo);
            }
        }
        this._$4.setWeightFieldInfos(weightFieldInfos);
        this._$4.setTolerance(d);
        this._$4.setBarrierNodes(nArray2);
        this._$4.setBarrierEdges(nArray3);
        this._$4.setTurnNodeIDField(string7);
        this._$4.setTurnFEdgeIDField(string8);
        this._$4.setTurnTEdgeIDField(string9);
        this._$4.setTurnWeightFields(stringArray5);
        this._$4.setNodeNameField(string10);
        this._$4.setEdgeNameField(string11);
        this._$4.setRuleField(string12);
        this._$4.setFTSingleWayRuleValues(stringArray6);
        this._$4.setTFSingleWayRuleValues(stringArray7);
        this._$4.setProhibitedWayRuleValues(stringArray8);
        this._$4.setTwoWayRuleValues(stringArray9);
        this._$4.setEdgeFilter(string13);
    }

    int getFileType(String string) {
        int n = TransportationAnalystNative.jni_GetFileType(this.getHandle(), string);
        return n;
    }

    private TransportationAnalystResult _$1(TransportationAnalystParameter transportationAnalystParameter, Point2D point2D, int[] nArray, double d, int n, boolean bl, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FindMTSPPath(TransportationAnalystParameter parameter, int[] centerNodes, boolean hasLeastTotalCost)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (transportationAnalystParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter);
        if (l == 0L) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = transportationAnalystParameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            transportationAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        } else if (this._$4.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = transportationAnalystParameter.getTurnWeightField();
        if (null == transportationAnalystParameter.getTurnWeightField()) {
            transportationAnalystParameter.setTurnWeightField("");
        }
        long l2 = TransportationAnalystNative.jni_findMTSPPathEx(this._$1[1], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), point2D.getX(), point2D.getY(), nArray, d, n, bl, bl2);
        transportationAnalystParameter.setWeightName(string);
        transportationAnalystParameter.setTurnWeightField(string3);
        TransportationAnalystResult transportationAnalystResult = null;
        if (l2 == 0L) {
            String string4 = Toolkit.getLastError();
            throw new NullPointerException(string4);
        }
        transportationAnalystResult = new TransportationAnalystResult(l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)transportationAnalystParameter));
        return transportationAnalystResult;
    }

    public TransportationAnalystResult findVRPPath(VRPAnalystParameter vRPAnalystParameter, VehicleInfo[] vehicleInfoArray, CenterPointInfo[] centerPointInfoArray, DemandPointInfo[] demandPointInfoArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPath(TransportationAnalystParameter parameter, boolean hasLeastEdgeCount)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (vRPAnalystParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        String string = vRPAnalystParameter.getWeightName();
        if (string == null || string.trim().length() == 0) {
            vRPAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        } else if (this._$4.getWeightFieldInfos().indexOf(string) < 0) {
            String string2 = InternalResource.loadString("parameter.getWeightName()", "TransportationAnalyst_SpecifiedWeightNameNotExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        String string3 = vRPAnalystParameter.getTurnWeightField();
        if (null == vRPAnalystParameter.getTurnWeightField()) {
            vRPAnalystParameter.setTurnWeightField("");
        }
        this._$1(vRPAnalystParameter, vehicleInfoArray, centerPointInfoArray, demandPointInfoArray);
        long[] lArray = new long[vehicleInfoArray.length];
        long[] lArray2 = new long[centerPointInfoArray.length];
        long[] lArray3 = new long[demandPointInfoArray.length];
        int n = 0;
        for (n = 0; n < vehicleInfoArray.length; ++n) {
            lArray[n] = vehicleInfoArray[n].getHandle();
        }
        for (n = 0; n < centerPointInfoArray.length; ++n) {
            lArray2[n] = centerPointInfoArray[n].getHandle();
        }
        for (n = 0; n < demandPointInfoArray.length; ++n) {
            lArray3[n] = demandPointInfoArray[n].getHandle();
        }
        long l = TransportationAnalystNative.jni_findVRPPath(this._$1[1], InternalHandle.getHandle((com.supermap.data.InternalHandle)vRPAnalystParameter), lArray, lArray2, lArray3, vRPAnalystParameter.getAnalystType().value(), vRPAnalystParameter.getRouteType().value(), vRPAnalystParameter.getStopType().value(), vRPAnalystParameter.getVehicleType().value());
        vRPAnalystParameter.setTurnWeightField(string3);
        TransportationAnalystResult transportationAnalystResult = null;
        if (l == 0L) {
            String string4 = Toolkit.getLastError();
            throw new NullPointerException(string4);
        }
        transportationAnalystResult = new TransportationAnalystResult(l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)vRPAnalystParameter));
        return transportationAnalystResult;
    }

    private boolean _$1(VRPAnalystParameter vRPAnalystParameter, VehicleInfo[] vehicleInfoArray, CenterPointInfo[] centerPointInfoArray, DemandPointInfo[] demandPointInfoArray) {
        int n = 0;
        if (vehicleInfoArray.length < 1 || centerPointInfoArray.length < 1 || demandPointInfoArray.length < 1) {
            String string = InternalResource.loadString("VehicleInfo[],CenterPointInfo[],DemandPointInfo[]", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = centerPointInfoArray[0].getCenterID() != -1;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < centerPointInfoArray.length; ++n) {
            if (centerPointInfoArray[n].getCenterID() == -1) {
                ++n3;
                continue;
            }
            ++n2;
        }
        if (bl) {
            if (n2 != centerPointInfoArray.length) {
                String string = InternalResource.loadString("centerInfos", "TheTypeShouldBeSame", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (n3 != centerPointInfoArray.length) {
            String string = InternalResource.loadString("centerInfos", "TheTypeShouldBeSame", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        n2 = 0;
        n3 = 0;
        boolean bl2 = vRPAnalystParameter.getRouteType() == RouteType.ROUNDROUTE;
        for (n = 0; n < vehicleInfoArray.length; ++n) {
            if (vehicleInfoArray[n].getLoadWeight() <= 0.0) {
                String string = InternalResource.loadString("vehicleInfos[" + n + "].getLoadWeight()", "VehicleLoadWeightGreaterThanZero", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (bl2) {
                vehicleInfoArray[n].setSE(!bl2);
                continue;
            }
            if (vehicleInfoArray[n].getSEID() == -1) {
                ++n3;
                continue;
            }
            ++n2;
        }
        if (!bl2) {
            if (bl) {
                if (n2 != vehicleInfoArray.length) {
                    String string = InternalResource.loadString("vehicleInfos", "TheTypeShouldBeSame", "networkanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
            } else if (n3 != vehicleInfoArray.length) {
                String string = InternalResource.loadString("vehicleInfos", "TheTypeShouldBeSame", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        n2 = 0;
        n3 = 0;
        for (n = 0; n < demandPointInfoArray.length; ++n) {
            if (demandPointInfoArray[n].getDemand() < 0.0) {
                String string = InternalResource.loadString("demandInfos[" + n + "].getDemand()", "DemandGreaterThanZero", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (demandPointInfoArray[n].getDemandID() == -1) {
                ++n3;
                continue;
            }
            ++n2;
        }
        if (bl) {
            if (n2 != demandPointInfoArray.length) {
                String string = InternalResource.loadString("demandInfos", "TheTypeShouldBeSame", "networkanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        } else if (n3 != demandPointInfoArray.length) {
            String string = InternalResource.loadString("demandInfos", "TheTypeShouldBeSame", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return true;
    }

    public int[] findCriticalNodes(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalNodes(int startPoint, int endPoint)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        TransportationAnalystParameter transportationAnalystParameter = new TransportationAnalystParameter();
        transportationAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        if (this._$4.getTurnWeightFields() != null && this._$4.getTurnWeightFields().length > 0) {
            transportationAnalystParameter.setTurnWeightField(this._$4.getTurnWeightFields()[0]);
        }
        transportationAnalystParameter.setNodes(new int[]{n, n2});
        transportationAnalystParameter.setNodesReturn(true);
        int[] nArray = TransportationAnalystNative.jni_FindCriticalElement(this._$1[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), true);
        return nArray;
    }

    public int[] findCriticalEdges(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findCriticalNodes(int startPoint, int endPoint)", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1()) {
            String string = InternalResource.loadString("", "TransportationAnalyst_LoadModelNeeded", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        TransportationAnalystParameter transportationAnalystParameter = new TransportationAnalystParameter();
        transportationAnalystParameter.setWeightName(this._$4.getWeightFieldInfos().get(0).getName());
        if (this._$4.getTurnWeightFields() != null && this._$4.getTurnWeightFields().length > 0) {
            transportationAnalystParameter.setTurnWeightField(this._$4.getTurnWeightFields()[0]);
        }
        transportationAnalystParameter.setNodes(new int[]{n, n2});
        transportationAnalystParameter.setEdgesReturn(true);
        int[] nArray = TransportationAnalystNative.jni_FindCriticalElement(this._$1[0], InternalHandle.getHandle((com.supermap.data.InternalHandle)transportationAnalystParameter), false);
        return nArray;
    }
}

