/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.ssl;

import java.io.FileInputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.security.KeyStore;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;
import org.jasig.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpsURLConnectionFactory
implements HttpURLConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpsURLConnectionFactory.class);
    private HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
    private Properties sslConfiguration = new Properties();

    public HttpsURLConnectionFactory() {
    }

    public HttpsURLConnectionFactory(HostnameVerifier verifier, Properties config) {
        this.setHostnameVerifier(verifier);
        this.setSSLConfiguration(config);
    }

    public final void setSSLConfiguration(Properties config) {
        this.sslConfiguration = config;
    }

    public final void setHostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
    }

    public HttpURLConnection buildHttpURLConnection(URLConnection url) {
        return this.configureHttpsConnectionIfNeeded(url);
    }

    private HttpURLConnection configureHttpsConnectionIfNeeded(URLConnection conn) {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)conn;
            SSLSocketFactory socketFactory = this.createSSLSocketFactory();
            if (socketFactory != null) {
                httpsConnection.setSSLSocketFactory(socketFactory);
            }
            if (this.hostnameVerifier != null) {
                httpsConnection.setHostnameVerifier(this.hostnameVerifier);
            }
        }
        return (HttpURLConnection)conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory createSSLSocketFactory() {
        FileInputStream keyStoreIS = null;
        try {
            SSLContext sslContext = SSLContext.getInstance(this.sslConfiguration.getProperty("protocol", "SSL"));
            if (this.sslConfiguration.getProperty("keyStoreType") != null) {
                KeyStore keyStore = KeyStore.getInstance(this.sslConfiguration.getProperty("keyStoreType"));
                if (this.sslConfiguration.getProperty("keyStorePath") != null) {
                    keyStoreIS = new FileInputStream(this.sslConfiguration.getProperty("keyStorePath"));
                    if (this.sslConfiguration.getProperty("keyStorePass") != null) {
                        keyStore.load(keyStoreIS, this.sslConfiguration.getProperty("keyStorePass").toCharArray());
                        LOGGER.debug("Keystore has {} keys", (Object)keyStore.size());
                        KeyManagerFactory keyManager = KeyManagerFactory.getInstance(this.sslConfiguration.getProperty("keyManagerType", "SunX509"));
                        keyManager.init(keyStore, this.sslConfiguration.getProperty("certificatePassword").toCharArray());
                        sslContext.init(keyManager.getKeyManagers(), null, null);
                        SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
                        CommonUtils.closeQuietly(keyStoreIS);
                        return sSLSocketFactory;
                    }
                }
            }
            CommonUtils.closeQuietly(keyStoreIS);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            CommonUtils.closeQuietly(keyStoreIS);
        }
        return null;
    }
}

