/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorGradientType;
import com.supermap.data.Colors;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.GeoStyle;
import com.supermap.data.JoinItems;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeRangeNative;
import com.supermap.mapping.ThemeUniqueItem;
import com.supermap.mapping.ThemeUniqueNative;
import java.util.ArrayList;

public class ThemeUnique
extends Theme {
    private GeoStyle _$2 = null;
    private ArrayList _$1 = null;

    public ThemeUnique() {
        long l = ThemeUniqueNative.jni_New();
        this.setHandle(l, true);
        this._$1();
        this._$1 = new ArrayList();
    }

    public ThemeUnique(ThemeUnique themeUnique) {
        if (themeUnique == null) {
            String string = InternalResource.loadString("themeUnique", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeUnique.getHandle() == 0L) {
            String string = InternalResource.loadString("themeUnique", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeUniqueNative.jni_Clone(themeUnique.getHandle());
        this.setHandle(l, true);
        this._$1 = new ArrayList();
        int n = themeUnique.getUniqueItemsList().size();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeUnique));
        for (int i = 0; i < n; ++i) {
            ThemeUniqueItem themeUniqueItem = new ThemeUniqueItem(this);
            this._$1.add(themeUniqueItem);
        }
    }

    ThemeUnique(long l, boolean bl) {
        this.setHandle(l, bl);
        this._$1 = new ArrayList();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeUniqueItem themeUniqueItem = new ThemeUniqueItem(this);
            this._$1.add(themeUniqueItem);
        }
    }

    public ThemeUniqueItem getItem(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return (ThemeUniqueItem)this._$1.get(n);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetCount(this.getHandle());
    }

    public String getUniqueExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUniqueExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetUniqueExpression(this.getHandle());
    }

    public void setUniqueExpression(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setUniqueExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        this.m_lock.lock();
        ThemeUniqueNative.jni_SetUniqueExpression(this.getHandle(), string);
        this.m_lock.unlock();
    }

    public GeoStyle getDefaultStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2 == null && (l = ThemeUniqueNative.jni_GetDefaultStyle(this.getHandle())) != 0L) {
            this._$2 = InternalGeoStyle.createInstance(l);
        }
        return this._$2;
    }

    public void setDefaultStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDefaultStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle) == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle2 = geoStyle.clone();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle2);
        this.m_lock.lock();
        ThemeUniqueNative.jni_SetDefaultStyle(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle2);
        this.m_lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(ThemeUniqueItem themeUniqueItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(ThemeUniqueItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeUniqueItem == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeUniqueItem themeUniqueItem2 = new ThemeUniqueItem(themeUniqueItem);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeUniqueItem2.getStyle());
        int n = -1;
        try {
            this.m_lock.lock();
            n = ThemeUniqueNative.jni_Add(this.getHandle(), themeUniqueItem2.getUnique(), themeUniqueItem2.isVisible(), themeUniqueItem2.getCaption(), l);
            if (n != -1) {
                ThemeUniqueItem themeUniqueItem3 = new ThemeUniqueItem(this);
                this._$1.add(themeUniqueItem3);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        themeUniqueItem2.hashCode();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(int n, ThemeUniqueItem themeUniqueItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, ThemeUniqueItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        if (n < 0 || n > n2) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeUniqueItem == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeUniqueItem themeUniqueItem2 = new ThemeUniqueItem(themeUniqueItem);
        boolean bl = false;
        this.m_lock.lock();
        try {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeUniqueItem2.getStyle());
            if (n == n2) {
                int n3 = ThemeUniqueNative.jni_Add(this.getHandle(), themeUniqueItem2.getUnique(), themeUniqueItem2.isVisible(), themeUniqueItem2.getCaption(), l);
                if (n3 == n2) {
                    bl = true;
                    ThemeUniqueItem themeUniqueItem3 = new ThemeUniqueItem(this);
                    this._$1.add(themeUniqueItem3);
                }
            } else {
                bl = ThemeUniqueNative.jni_Insert(this.getHandle(), n, themeUniqueItem2.getUnique(), themeUniqueItem2.isVisible(), themeUniqueItem2.getCaption(), l);
                if (bl) {
                    ThemeUniqueItem themeUniqueItem4 = new ThemeUniqueItem(this);
                    this._$1.add(n, themeUniqueItem4);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = ThemeUniqueNative.jni_Remove(this.getHandle(), n);
            if (bl) {
                ThemeUniqueItem themeUniqueItem = (ThemeUniqueItem)this._$1.get(n);
                themeUniqueItem.clearHandle();
                this._$1.remove(n);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeUniqueNative.jni_Clear(this.getHandle());
        if (this._$1 != null) {
            int n = this._$1.size();
            for (int i = 0; i < n; ++i) {
                ThemeUniqueItem themeUniqueItem = (ThemeUniqueItem)this._$1.get(i);
                themeUniqueItem.clearHandle();
            }
            this._$1.clear();
        }
        this.m_lock.unlock();
    }

    public static ThemeUnique makeDefault(DatasetVector datasetVector, String string) {
        return ThemeUnique.makeDefault(datasetVector, string, null, null);
    }

    public static ThemeUnique makeDefault(DatasetVector datasetVector, String string, ColorGradientType colorGradientType) {
        return ThemeUnique.makeDefault(datasetVector, string, colorGradientType, null);
    }

    public static ThemeUnique makeDefault(DatasetVector datasetVector, String string, ColorGradientType colorGradientType, JoinItems joinItems) {
        long l;
        if (datasetVector == null) {
            String string2 = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l2 == 0L) {
            String string3 = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("uniqueExpression", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)joinItems)) == 0L) {
            String string5 = InternalResource.loadString("joinItems", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        int n = InternalEnum.getUGCValue((Enum)colorGradientType);
        long l3 = ThemeUniqueNative.jni_MakeDefault(l2, string, l, n);
        ThemeUnique themeUnique = null;
        if (l3 != 0L) {
            themeUnique = new ThemeUnique(l3, true);
        }
        return themeUnique;
    }

    public static ThemeUnique makeDefault(DatasetVector datasetVector, String string, Colors colors) {
        boolean bl;
        Object object;
        if (datasetVector == null) {
            String string2 = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string3 = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!datasetVector.getType().equals((Object)DatasetType.REGION)) {
            String string4 = InternalResource.loadString("dataset", "ThemeUnique_TheDatasetTypeIsUnsupported", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        FieldInfo fieldInfo = datasetVector.getFieldInfos().get(string);
        if (fieldInfo != null) {
            if (fieldInfo.isSystemField()) {
                String string5 = InternalResource.loadString("colorField", "ThemeUnique_SystemFieldIsReadOnly", "mapping_resources");
                throw new IllegalArgumentException(string5);
            }
            object = fieldInfo.getType();
            boolean bl2 = bl = object.equals((Object)FieldType.BYTE) || object.equals((Object)FieldType.INT16) || object.equals((Object)FieldType.INT32);
            if (!bl) {
                String string6 = InternalResource.loadString("colorField", "ThemeUnique_OnlySupportIntegerField", "mapping_resources");
                throw new IllegalArgumentException(string6);
            }
        } else {
            if (!datasetVector.isAvailableFieldName(string)) {
                String string7 = InternalResource.loadString("colorField", "ThemeUnique_TheArgumentOfColorFieldIsNotAvailableFieldName", "mapping_resources");
                throw new IllegalArgumentException(string7);
            }
            object = new FieldInfo();
            object.setType(FieldType.INT32);
            object.setName(string);
            object.setCaption(string);
            datasetVector.getFieldInfos().add((FieldInfo)object);
        }
        if (colors != null && com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)colors) == 0L) {
            colors = null;
        }
        object = null;
        bl = ThemeUniqueNative.jni_MakeFourColor(l, string);
        if (bl) {
            object = ThemeUnique.makeDefault(datasetVector, string);
        }
        if (object != null) {
            int n = ((ThemeUnique)((Object)object)).getCount();
            if (colors == null) {
                colors = Colors.makeRandom((int)n);
            }
            if (colors.getCount() < n) {
                colors = new Colors(colors);
                Colors colors2 = Colors.makeRandom((int)(n - colors.getCount()));
                colors.addRange(colors2.toArray());
            }
            for (int i = 0; i < n; ++i) {
                ((ThemeUnique)((Object)object)).getItem(i).getStyle().setFillForeColor(colors.get(i));
            }
        }
        return object;
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("indexOf(String unique)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n = -1;
        if (string != null && string.trim().length() != 0) {
            n = ThemeUniqueNative.jni_IndexOf(this.getHandle(), string);
        }
        return n;
    }

    public void reverseStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeUniqueNative.jni_ReverseStyle(this.getHandle());
        this.m_lock.unlock();
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append(",UniqueExpression = ");
        stringBuffer.append(this.getUniqueExpression());
        stringBuffer.append(",DefaultStyle = ");
        stringBuffer.append(this.getDefaultStyle().toString());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeRangeNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromXML(String string) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(string);
            if (bl) {
                if (this._$2 != null) {
                    InternalGeoStyle.clearHandle(this._$2);
                    this._$2 = null;
                }
                if (this._$1 != null) {
                    this._$2();
                }
                int n = this.getCount();
                for (int i = 0; i < n; ++i) {
                    ThemeUniqueItem themeUniqueItem = new ThemeUniqueItem(this);
                    this._$1.add(themeUniqueItem);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public void setDefaultStyleVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDefaultStyleVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeUniqueNative.jni_SetIsDefaultStyleVisible(this.getHandle(), bl);
        this.m_lock.unlock();
    }

    public boolean isDefaultStyleVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDefaultStyleVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetIsDefaultStyleVisible(this.getHandle());
    }

    protected void clearHandle() {
        if (this._$1 != null) {
            this._$2();
            this._$1 = null;
        }
        if (this._$2 != null) {
            InternalGeoStyle.clearHandle(this._$2);
            this._$2 = null;
        }
        this.setHandle(0L);
    }

    ArrayList getUniqueItemsList() {
        return this._$1;
    }

    private void _$2() {
        int n = this._$1.size();
        for (int i = 0; i < n; ++i) {
            ThemeUniqueItem themeUniqueItem = (ThemeUniqueItem)this._$1.get(i);
            themeUniqueItem.clearHandle();
        }
        this._$1.clear();
    }

    private void _$1() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reset()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeUniqueNative.jni_Reset(this.getHandle());
    }

    public String getOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetX()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetOffsetX(this.getHandle());
    }

    public void setOffsetX(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOffsetX(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        ThemeUniqueNative.jni_SetOffsetX(this.getHandle(), string);
    }

    public String getOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetY()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetOffsetY(this.getHandle());
    }

    public void setOffsetY(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOffsetY(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        ThemeUniqueNative.jni_SetOffsetY(this.getHandle(), string);
    }

    public boolean isOffsetFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOffsetFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetOffsetFixed(this.getHandle());
    }

    public void setOffsetFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeUniqueNative.jni_SetOffsetFixed(this.getHandle(), bl);
    }
}

