/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.util;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.struts2.util.ListEntry;
import org.apache.struts2.views.jsp.ui.OgnlTool;
import org.apache.struts2.views.util.UrlHelper;

public class StrutsUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(StrutsUtil.class);
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected Map<String, Class> classes = new Hashtable<String, Class>();
    protected OgnlTool ognl;
    protected ValueStack stack;
    private UrlHelper urlHelper;
    private ObjectFactory objectFactory;

    public StrutsUtil(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        this.stack = stack;
        this.request = request;
        this.response = response;
        this.ognl = (OgnlTool)((Container)stack.getContext().get("com.opensymphony.xwork2.ActionContext.container")).getInstance(OgnlTool.class);
        this.urlHelper = (UrlHelper)((Container)stack.getContext().get("com.opensymphony.xwork2.ActionContext.container")).getInstance(UrlHelper.class);
        this.objectFactory = (ObjectFactory)((Container)stack.getContext().get("com.opensymphony.xwork2.ActionContext.container")).getInstance(ObjectFactory.class);
    }

    public Object bean(Object aName) throws Exception {
        String name = aName.toString();
        Class c = this.classes.get(name);
        if (c == null) {
            c = ClassLoaderUtil.loadClass((String)name, StrutsUtil.class);
            this.classes.put(name, c);
        }
        return this.objectFactory.buildBean(c, this.stack.getContext());
    }

    public boolean isTrue(String expression) {
        Boolean retVal = (Boolean)this.stack.findValue(expression, Boolean.class);
        return retVal != null && retVal != false;
    }

    public Object findString(String name) {
        return this.stack.findValue(name, String.class);
    }

    public String include(Object aName) throws Exception {
        return this.include(aName, this.request, this.response);
    }

    public String include(Object aName, HttpServletRequest aRequest, HttpServletResponse aResponse) throws Exception {
        try {
            RequestDispatcher dispatcher = aRequest.getRequestDispatcher(aName.toString());
            if (dispatcher == null) {
                throw new IllegalArgumentException("Cannot find included file " + aName);
            }
            ResponseWrapper responseWrapper = new ResponseWrapper(aResponse);
            dispatcher.include((ServletRequest)aRequest, (ServletResponse)responseWrapper);
            return responseWrapper.getData();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot include #0", (Throwable)e, new String[]{aName.toString()});
            }
            throw e;
        }
    }

    public String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot encode URL [#0]", (Throwable)e, new String[]{s});
            }
            return s;
        }
    }

    public String buildUrl(String url) {
        return this.urlHelper.buildUrl(url, this.request, this.response, null);
    }

    public Object findValue(String expression, String className) throws ClassNotFoundException {
        return this.stack.findValue(expression, Class.forName(className));
    }

    public String getText(String text) {
        return (String)this.stack.findValue("getText('" + text + "')");
    }

    public String getContext() {
        return this.request == null ? "" : this.request.getContextPath();
    }

    public String translateVariables(String expression) {
        return TextParseUtil.translateVariables((String)expression, (ValueStack)this.stack);
    }

    public List makeSelectList(String selectedList, String list, String listKey, String listValue) {
        Collection items;
        ArrayList<ListEntry> selectList = new ArrayList<ListEntry>();
        Collection<Object> selectedItems = null;
        Object i = this.stack.findValue(selectedList);
        if (i != null) {
            if (i.getClass().isArray()) {
                selectedItems = Arrays.asList((Object[])i);
            } else if (i instanceof Collection) {
                selectedItems = (Collection)i;
            } else {
                selectedItems = new ArrayList<Object>();
                selectedItems.add(i);
            }
        }
        if ((items = (Collection)this.stack.findValue(list)) != null) {
            for (Object element : items) {
                Object key = listKey == null || listKey.length() == 0 ? element : this.ognl.findValue(listKey, element);
                Object value = null;
                value = listValue == null || listValue.length() == 0 ? (Object)element : this.ognl.findValue(listValue, element);
                boolean isSelected = false;
                if (value != null && selectedItems != null && selectedItems.contains(value)) {
                    isSelected = true;
                }
                selectList.add(new ListEntry(key, value, isSelected));
            }
        }
        return selectList;
    }

    public int toInt(long aLong) {
        return (int)aLong;
    }

    public long toLong(int anInt) {
        return anInt;
    }

    public long toLong(String aLong) {
        if (aLong == null) {
            return 0L;
        }
        return Long.parseLong(aLong);
    }

    public String toString(long aLong) {
        return Long.toString(aLong);
    }

    public String toString(int anInt) {
        return Integer.toString(anInt);
    }

    public String toStringSafe(Object obj) {
        try {
            if (obj != null) {
                return String.valueOf(obj);
            }
            return "";
        }
        catch (Exception e) {
            return "Exception thrown: " + e;
        }
    }

    static class ServletOutputStreamWrapper
    extends ServletOutputStream {
        StringWriter writer;

        ServletOutputStreamWrapper(StringWriter aWriter) {
            this.writer = aWriter;
        }

        public void write(int aByte) {
            this.writer.write(aByte);
        }
    }

    static class ResponseWrapper
    extends HttpServletResponseWrapper {
        StringWriter strout = new StringWriter();
        PrintWriter writer;
        ServletOutputStream sout = new ServletOutputStreamWrapper(this.strout);

        ResponseWrapper(HttpServletResponse aResponse) {
            super(aResponse);
            this.writer = new PrintWriter(this.strout);
        }

        public String getData() {
            this.writer.flush();
            return this.strout.toString();
        }

        public ServletOutputStream getOutputStream() {
            return this.sout;
        }

        public PrintWriter getWriter() throws IOException {
            return this.writer;
        }
    }
}

