/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DateTextFieldInterceptor
implements Interceptor {
    private static final Logger LOG = LoggerFactory.getLogger(DateTextFieldInterceptor.class);

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation ai) throws Exception {
        Map parameters = ai.getInvocationContext().getParameters();
        Set entries = parameters.entrySet();
        HashMap<String, HashMap<String, String>> dates = new HashMap<String, HashMap<String, String>>();
        DateWord[] dateWords = DateWord.getAll();
        Iterator iterator = entries.iterator();
        block2: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            for (DateWord dateWord : dateWords) {
                String[] values;
                String dateKey = "__" + dateWord.getDescription() + "_";
                if (!key.startsWith(dateKey)) continue;
                String name = key.substring(dateKey.length());
                if (!(entry.getValue() instanceof String[]) || (values = (String[])entry.getValue()).length <= 0 || "".equals(values[0])) continue block2;
                iterator.remove();
                HashMap<String, String> map = (HashMap<String, String>)dates.get(name);
                if (map == null) {
                    map = new HashMap<String, String>();
                    dates.put(name, map);
                }
                map.put(dateWord.getDateType(), values[0]);
                continue block2;
            }
        }
        HashMap newParams = new HashMap();
        Set dateEntries = dates.entrySet();
        for (Map.Entry dateEntry : dateEntries) {
            Set dateFormatEntries = ((Map)dateEntry.getValue()).entrySet();
            String dateFormat = "";
            String dateValue = "";
            for (Map.Entry dateFormatEntry : dateFormatEntries) {
                dateFormat = dateFormat + (String)dateFormatEntry.getKey() + "__";
                dateValue = dateValue + (String)dateFormatEntry.getValue() + "__";
            }
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
                formatter.setLenient(false);
                Date value = formatter.parse(dateValue);
                newParams.put(dateEntry.getKey(), value);
            }
            catch (ParseException e) {
                LOG.warn("Cannot parse the parameter '" + (String)dateEntry.getKey() + "' with format '" + dateFormat + "' and with value '" + dateValue + "'", new String[0]);
            }
        }
        parameters.putAll(newParams);
        return ai.invoke();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DateWord {
        S("millisecond", 3, "SSS"),
        s("second", 2, "ss"),
        m("minute", 2, "mm"),
        H("hour", 2, "HH"),
        d("day", 2, "dd"),
        M("month", 2, "MM"),
        y("year", 4, "yyyy");

        private String description;
        private Integer length;
        private String dateType;

        private DateWord(String n2, Integer l, String t) {
            this.description = n2;
            this.length = l;
            this.dateType = t;
        }

        public String getDescription() {
            return this.description;
        }

        public Integer getLength() {
            return this.length;
        }

        public String getDateType() {
            return this.dateType;
        }

        public static DateWord get(Character c) {
            return DateWord.valueOf(DateWord.class, c.toString());
        }

        public static DateWord[] getAll() {
            return DateWord.values();
        }
    }
}

