/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.webflow.config.FlowElementAttribute;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FlowExecutorBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String FLOW_EXECUTOR_FACTORY_BEAN_CLASS_NAME = "org.springframework.webflow.config.FlowExecutorFactoryBean";

    FlowExecutorBeanDefinitionParser() {
    }

    protected String getBeanClassName(Element element) {
        return FLOW_EXECUTOR_FACTORY_BEAN_CLASS_NAME;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder definitionBuilder) {
        definitionBuilder.addPropertyReference("flowDefinitionLocator", this.getFlowRegistry(element, parserContext));
        this.addFlowExecutionRepositoryProperties(element, definitionBuilder, parserContext);
        definitionBuilder.addPropertyValue("flowExecutionAttributes", this.parseFlowExecutionAttributes(element));
        this.addFlowExecutionListenerLoader(element, parserContext, definitionBuilder);
    }

    private String getFlowRegistry(Element element, ParserContext parserContext) {
        String registry = element.getAttribute("flow-registry");
        if (!StringUtils.hasText((String)registry)) {
            return "flowRegistry";
        }
        return registry;
    }

    private void addFlowExecutionRepositoryProperties(Element element, BeanDefinitionBuilder definitionBuilder, ParserContext parserContext) {
        Element repositoryElement = DomUtils.getChildElementByTagName((Element)element, (String)"flow-execution-repository");
        if (repositoryElement != null) {
            this.addMaxExecutions(repositoryElement, definitionBuilder, parserContext);
            this.addConversationManager(repositoryElement, definitionBuilder, parserContext);
            this.addMaxSnapshots(repositoryElement, definitionBuilder, parserContext);
        }
    }

    private void addMaxExecutions(Element element, BeanDefinitionBuilder definitionBuilder, ParserContext parserContext) {
        String maxConversations = element.getAttribute("max-executions");
        if (StringUtils.hasText((String)maxConversations)) {
            definitionBuilder.addPropertyValue("maxFlowExecutions", (Object)maxConversations);
        }
    }

    private void addConversationManager(Element element, BeanDefinitionBuilder definitionBuilder, ParserContext parserContext) {
        String conversationManager = element.getAttribute("conversation-manager");
        if (StringUtils.hasText((String)conversationManager)) {
            definitionBuilder.addPropertyReference("conversationManager", conversationManager);
        }
    }

    private void addMaxSnapshots(Element element, BeanDefinitionBuilder definitionBuilder, ParserContext parserContext) {
        String maxSnapshots = element.getAttribute("max-execution-snapshots");
        if (StringUtils.hasText((String)maxSnapshots)) {
            definitionBuilder.addPropertyValue("maxFlowExecutionSnapshots", (Object)maxSnapshots);
        }
    }

    private Set<Object> parseFlowExecutionAttributes(Element element) {
        Element executionAttributesElement = DomUtils.getChildElementByTagName((Element)element, (String)"flow-execution-attributes");
        if (executionAttributesElement != null) {
            Element redirectInSameStateElement;
            HashSet<Object> attributes = new HashSet<Object>();
            Element redirectElement = DomUtils.getChildElementByTagName((Element)executionAttributesElement, (String)"always-redirect-on-pause");
            if (redirectElement != null) {
                String value = redirectElement.getAttribute("value");
                attributes.add(new FlowElementAttribute("alwaysRedirectOnPause", value, "boolean"));
            }
            if ((redirectInSameStateElement = DomUtils.getChildElementByTagName((Element)executionAttributesElement, (String)"redirect-in-same-state")) != null) {
                String value = redirectInSameStateElement.getAttribute("value");
                attributes.add(new FlowElementAttribute("redirectInSameState", value, "boolean"));
            }
            List attributeElements = DomUtils.getChildElementsByTagName((Element)executionAttributesElement, (String)"attribute");
            for (Element attributeElement : attributeElements) {
                String name = attributeElement.getAttribute("name");
                String value = attributeElement.getAttribute("value");
                String type = attributeElement.getAttribute("type");
                attributes.add(new FlowElementAttribute(name, value, type));
            }
            return attributes;
        }
        return null;
    }

    private void addFlowExecutionListenerLoader(Element element, ParserContext parserContext, BeanDefinitionBuilder definitionBuilder) {
        Element listenersElement = DomUtils.getChildElementByTagName((Element)element, (String)"flow-execution-listeners");
        if (listenersElement != null) {
            definitionBuilder.addPropertyValue("flowExecutionListenerLoader", (Object)parserContext.getDelegate().parseCustomElement(listenersElement, (BeanDefinition)definitionBuilder.getBeanDefinition()));
        }
    }
}

