/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential.criteria;

import java.security.Key;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.criteria.EvaluableCredentialCriteria;
import org.opensaml.xml.security.criteria.KeyAlgorithmCriteria;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableKeyAlgorithmCredentialCriteria
implements EvaluableCredentialCriteria {
    private final Logger log = LoggerFactory.getLogger(EvaluableKeyAlgorithmCredentialCriteria.class);
    private String keyAlgorithm;

    public EvaluableKeyAlgorithmCredentialCriteria(KeyAlgorithmCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criteria instance may not be null");
        }
        this.keyAlgorithm = criteria.getKeyAlgorithm();
    }

    public EvaluableKeyAlgorithmCredentialCriteria(String newKeyAlgorithm) {
        if (DatatypeHelper.isEmpty(newKeyAlgorithm)) {
            throw new IllegalArgumentException("Key algorithm may not be null");
        }
        this.keyAlgorithm = newKeyAlgorithm;
    }

    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        Key key = this.getKey(target);
        if (key == null) {
            this.log.info("Could not evaluate criteria, credential contained no key");
            return null;
        }
        String algorithm = DatatypeHelper.safeTrimOrNullString(key.getAlgorithm());
        if (algorithm == null) {
            this.log.info("Could not evaluate criteria, key does not specify an algorithm via getAlgorithm()");
            return null;
        }
        Boolean result = this.keyAlgorithm.equals(algorithm);
        return result;
    }

    private Key getKey(Credential credential) {
        if (credential.getPublicKey() != null) {
            return credential.getPublicKey();
        }
        if (credential.getSecretKey() != null) {
            return credential.getSecretKey();
        }
        if (credential.getPrivateKey() != null) {
            return credential.getPrivateKey();
        }
        return null;
    }
}

