/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalVariantNative;
import com.supermap.realspace.InternalVariantType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

class InternalVariant
extends InternalHandleDisposable {
    private InternalVariant() {
        this.setHandle(InternalVariantNative.jni_New(), true);
    }

    public InternalVariant(Object object) {
        this();
        if (object.getClass().equals(Byte.class)) {
            Byte by = (Byte)object;
            this.setValue(by);
        } else if (object.getClass().equals(Integer.class)) {
            Integer n = (Integer)object;
            this.setValue(n);
        } else if (object.getClass().equals(Long.class)) {
            Long l = (Long)object;
            this.setValue(l);
        } else if (object.getClass().equals(Short.class)) {
            Short s = (Short)object;
            this.setValue(s);
        } else if (object.getClass().equals(Boolean.class)) {
            Boolean bl = (Boolean)object;
            this.setValue(bl);
        } else if (object.getClass().equals(Float.class)) {
            Float f = (Float)object;
            this.setValue(f.floatValue());
        } else if (object.getClass().equals(Double.class)) {
            Double d = (Double)object;
            this.setValue(d);
        } else if (object.getClass().equals(String.class)) {
            String string = (String)object;
            this.setValue(string);
        } else if (object.getClass().equals(Date.class)) {
            Date date = (Date)object;
            this.setValue(date);
        } else if (object.getClass().getName().compareToIgnoreCase("[B") == 0) {
            byte[] byArray = (byte[])object;
            this.setValue(byArray);
        } else {
            String string = InternalResource.loadString("", "InternalVariant_UnsupportType", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public InternalVariant(byte by) {
        this();
        this.setValue(by);
    }

    public InternalVariant(int n) {
        this();
        this.setValue(n);
    }

    public InternalVariant(long l) {
        this();
        this.setValue(l);
    }

    public InternalVariant(short s) {
        this();
        this.setValue(s);
    }

    public InternalVariant(boolean bl) {
        this();
        this.setValue(bl);
    }

    public InternalVariant(float f) {
        this();
        this.setValue(f);
    }

    public InternalVariant(double d) {
        this();
        this.setValue(d);
    }

    public InternalVariant(String string) {
        this();
        this.setValue(string);
    }

    public InternalVariant(Date date) {
        this();
        this.setValue(date);
    }

    public InternalVariant(byte[] byArray) {
        this();
        this.setValue(byArray);
    }

    public InternalVariantType getType() {
        int n = InternalVariantNative.jni_GetType(this.getHandle());
        InternalVariantType internalVariantType = (InternalVariantType)InternalEnum.parseUGCValue(InternalVariantType.class, n);
        return internalVariantType;
    }

    public void setValue(byte by) {
        InternalVariantNative.jni_SetValueByte(this.getHandle(), by);
    }

    public void setValue(int n) {
        InternalVariantNative.jni_SetValueInt(this.getHandle(), n);
    }

    public void setValue(long l) {
        InternalVariantNative.jni_SetValueLong(this.getHandle(), l);
    }

    public void setValue(short s) {
        InternalVariantNative.jni_SetValueShort(this.getHandle(), s);
    }

    public void setValue(boolean bl) {
        InternalVariantNative.jni_SetValueBoolean(this.getHandle(), bl);
    }

    public void setValue(float f) {
        InternalVariantNative.jni_SetValueFloat(this.getHandle(), f);
    }

    public void setValue(double d) {
        InternalVariantNative.jni_SetValueDouble(this.getHandle(), d);
    }

    public void setValue(String string) {
        InternalVariantNative.jni_SetValueString(this.getHandle(), string);
    }

    public void setValue(byte[] byArray) {
        InternalVariantNative.jni_SetValueBinary(this.getHandle(), byArray);
    }

    public void setValue(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(10);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        InternalVariantNative.jni_SetValueTime(this.getHandle(), n, n2, n3, n4, n5, n6);
    }

    public int toByte() {
        return InternalVariantNative.jni_GetValueByte(this.getHandle());
    }

    public int toInt() {
        return InternalVariantNative.jni_GetValueInt(this.getHandle());
    }

    public long toLong() {
        return InternalVariantNative.jni_GetValueLong(this.getHandle());
    }

    public short toShort() {
        return InternalVariantNative.jni_GetValueShort(this.getHandle());
    }

    public boolean toBoolean() {
        return InternalVariantNative.jni_GetValueBoolean(this.getHandle());
    }

    public double toDouble() {
        return InternalVariantNative.jni_GetValueDouble(this.getHandle());
    }

    public float toFloat() {
        return InternalVariantNative.jni_GetValueFloat(this.getHandle());
    }

    public byte[] toBinary() {
        return InternalVariantNative.jni_GetValueBinary(this.getHandle());
    }

    public String toString() {
        String string = null;
        if (this.getType().equals((Object)InternalVariantType.TIME)) {
            Date date = this.toDate();
            string = DateFormat.getDateInstance().format(date);
        } else {
            string = InternalVariantNative.jni_GetValueString(this.getHandle());
        }
        return string;
    }

    public Date toDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.US);
        Date date = null;
        try {
            date = simpleDateFormat.parse(InternalVariantNative.jni_GetValueString(this.getHandle()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public Object toObject() {
        InternalVariantType internalVariantType = this.getType();
        if (internalVariantType.equals((Object)InternalVariantType.BYTE)) {
            return Byte.valueOf(String.valueOf(this.toByte()));
        }
        if (internalVariantType.equals((Object)InternalVariantType.INTEGER)) {
            return this.toInt();
        }
        if (internalVariantType.equals((Object)InternalVariantType.LONG)) {
            return this.toLong();
        }
        if (internalVariantType.equals((Object)InternalVariantType.SHORT)) {
            return this.toShort();
        }
        if (internalVariantType.equals((Object)InternalVariantType.FLOAT)) {
            return Float.valueOf(this.toFloat());
        }
        if (internalVariantType.equals((Object)InternalVariantType.DOUBLE)) {
            return this.toDouble();
        }
        if (internalVariantType.equals((Object)InternalVariantType.TIME)) {
            return this.toDate();
        }
        if (internalVariantType.equals((Object)InternalVariantType.STRING)) {
            return this.toString();
        }
        if (internalVariantType.equals((Object)InternalVariantType.BINARY)) {
            return this.toBinary();
        }
        if (internalVariantType.equals((Object)InternalVariantType.NULL)) {
            return null;
        }
        String string = InternalResource.loadString("", "InternalVariant_UnsupportType", "realspace_resources");
        throw new IllegalArgumentException(string);
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            InternalVariantNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    private InternalVariant(long l, boolean bl) {
        this.setHandle(l, true);
    }

    static final InternalVariant createInstance(long l) {
        return new InternalVariant(l, true);
    }

    static boolean isSupportedInstance(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass().equals(Byte.class)) {
            return true;
        }
        if (object.getClass().equals(Integer.class)) {
            return true;
        }
        if (object.getClass().equals(Long.class)) {
            return true;
        }
        if (object.getClass().equals(Short.class)) {
            return true;
        }
        if (object.getClass().equals(Boolean.class)) {
            return true;
        }
        if (object.getClass().equals(Float.class)) {
            return true;
        }
        if (object.getClass().equals(Double.class)) {
            return true;
        }
        if (object.getClass().equals(String.class)) {
            return true;
        }
        return object.getClass().equals(Date.class);
    }
}

