/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.AltitudeMode;
import com.supermap.data.Toolkit;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalToolkitSpace;

public class Camera {
    private double _$9;
    private double _$8;
    private double _$7;
    private double _$6;
    private double _$5;
    private AltitudeMode _$4 = AltitudeMode.RELATIVE_TO_GROUND;
    private static final double _$3 = Math.PI / 180;
    private static final double _$2 = 57.29577951308232;
    private static final double _$1 = 6378137.0;

    public Camera() {
    }

    public Camera(Camera camera) {
        this(camera.getLongitude(), camera.getLatitude(), camera.getAltitude(), camera.getAltitudeMode(), camera.getHeading(), camera.getTilt());
    }

    public Camera(double d, double d2, double d3) {
        this(d, d2, d3, AltitudeMode.ABSOLUTE, 0.0, 0.0);
    }

    public Camera(double d, double d2, double d3, AltitudeMode altitudeMode, double d4, double d5) {
        this._$9 = d3;
        this._$7 = d2;
        this._$8 = d4;
        this._$5 = d5;
        this._$6 = d;
        this._$4 = altitudeMode;
    }

    public static Camera getEMPTY() {
        return new Camera(InternalToolkitSpace.DBL_MIN_VALUE, InternalToolkitSpace.DBL_MIN_VALUE, InternalToolkitSpace.DBL_MIN_VALUE, AltitudeMode.ABSOLUTE, InternalToolkitSpace.DBL_MIN_VALUE, InternalToolkitSpace.DBL_MIN_VALUE);
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (InternalToolkitSpace.isZero((double)(this._$9 - InternalToolkitSpace.DBL_MIN_VALUE), (double)-1.0E-10, (double)1.0E-10) && InternalToolkitSpace.isZero((double)(this._$9 - InternalToolkitSpace.DBL_MIN_VALUE), (double)-1.0E-10, (double)1.0E-10) && InternalToolkitSpace.isZero((double)(this._$9 - InternalToolkitSpace.DBL_MIN_VALUE), (double)-1.0E-10, (double)1.0E-10) && InternalToolkitSpace.isZero((double)(this._$9 - InternalToolkitSpace.DBL_MIN_VALUE), (double)-1.0E-10, (double)1.0E-10) && InternalToolkitSpace.isZero((double)(this._$9 - InternalToolkitSpace.DBL_MIN_VALUE), (double)-1.0E-10, (double)1.0E-10)) {
            bl = true;
        }
        return bl;
    }

    public double getAltitude() {
        return this._$9;
    }

    public void setAltitude(double d) {
        this._$9 = d;
    }

    public double getHeading() {
        return this._$8;
    }

    public void setHeading(double d) {
        if (d < 0.0 || d > 360.0) {
            String string = InternalResource.loadString("value", "Camera_HeadingOutOfRange", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this._$8 = d;
    }

    public double getLatitude() {
        return this._$7;
    }

    public void setLatitude(double d) {
        if (d < -90.0 || d > 90.0) {
            String string = InternalResource.loadString("value", "Camera_LatitudeOutOfRange", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this._$7 = d;
    }

    public double getLongitude() {
        return this._$6;
    }

    public void setLongitude(double d) {
        if (d < -180.0 || d > 180.0) {
            String string = InternalResource.loadString("value", "Camera_LongitudeOutOfRange", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this._$6 = d;
    }

    public double getTilt() {
        return this._$5;
    }

    public void setTilt(double d) {
        if (d < -180.0 || d > 180.0) {
            String string = InternalResource.loadString("value", "Camera_TiltOutOfRange", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this._$5 = d;
    }

    public AltitudeMode getAltitudeMode() {
        return this._$4;
    }

    public void setAltitudeMode(AltitudeMode altitudeMode) {
        if (altitudeMode == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        this._$4 = altitudeMode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Altitude=");
        stringBuffer.append(this.getAltitude());
        stringBuffer.append(",Heading=");
        stringBuffer.append(this.getHeading());
        stringBuffer.append(",Latitude=");
        stringBuffer.append(this.getLatitude());
        stringBuffer.append(",Longitude=");
        stringBuffer.append(this.getLongitude());
        stringBuffer.append(",Tilt=");
        stringBuffer.append(this.getTilt());
        stringBuffer.append(",AltitudeMode=");
        stringBuffer.append(this.getAltitudeMode());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Camera clone() {
        return new Camera(this);
    }

    public boolean equals(Camera camera) {
        if (camera == null) {
            return false;
        }
        return Toolkit.isZero((double)(this._$5 - camera.getTilt())) && Toolkit.isZero((double)(this._$9 - camera.getAltitude())) && Toolkit.isZero((double)(this._$7 - camera.getLatitude())) && Toolkit.isZero((double)(this._$6 - camera.getLongitude())) && Toolkit.isZero((double)(this._$8 - camera.getHeading()));
    }

    static double computeDistance(double d, double d2) {
        double d3 = Math.PI - d2 * (Math.PI / 180);
        double d4 = 4.0680631590769E13;
        double d5 = Math.cos(d3);
        double d6 = d5 * d5;
        double d7 = d4 * (d6 - 1.0) + (6378137.0 + d) * (6378137.0 + d);
        double d8 = Math.sqrt(d7);
        double d9 = 6378137.0 * (1.0 + d5) + d8 - 6378137.0;
        return d9;
    }

    static double computeAltitude(double d, double d2) {
        double d3 = Math.PI - d2 * (Math.PI / 180);
        double d4 = 4.0680631590769E13;
        double d5 = Math.cos(d3);
        double d6 = d5 * d5;
        double d7 = d + 6378137.0 - 6378137.0 * (1.0 + d5);
        double d8 = Math.sqrt(d7 * d7 - d4 * (d6 - 1.0)) - 6378137.0;
        return d8;
    }
}

