/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.sojo.core.NonCriticalExceptionHandler;
import net.sf.sojo.core.reflect.AccessiblePrivilegedAction;
import net.sf.sojo.core.reflect.ClassPropertiesCache;
import net.sf.sojo.core.reflect.ReflectionHelper;
import net.sf.sojo.util.Util;

public final class ReflectionMethodHelper {
    public static final int GET_METHOD = 1;
    public static final int SET_METHOD = 2;
    protected static final ClassPropertiesCache classPropertiesCacheGetter = new ClassPropertiesCache();
    protected static final ClassPropertiesCache classPropertiesCacheSetter = new ClassPropertiesCache();

    protected ReflectionMethodHelper() {
    }

    public static void clearPropertiesCache() {
        classPropertiesCacheGetter.clear();
        classPropertiesCacheSetter.clear();
    }

    public static Map<Object, Object> getAllGetterMethod(Class<?> pvClass) {
        return ReflectionMethodHelper.getAllGetterAndSetterMethod(pvClass, 1);
    }

    public static Map<Object, Object> getAllSetterMethod(Class<?> pvClass) {
        return ReflectionMethodHelper.getAllGetterAndSetterMethod(pvClass, 2);
    }

    public static Map<Object, Object> getAllNotEqualsGetterAndSetterAndRemoveThisProperties(Map<Object, Object> pvGetterMap, Map<Object, Object> pvSetterMap) {
        TreeMap<Object, Object> lvMap = new TreeMap<Object, Object>();
        Iterator<Object> it = new ArrayList<Object>(pvGetterMap.keySet()).iterator();
        lvMap.put(Util.getKeyWordClass(), pvGetterMap.get(Util.getKeyWordClass()));
        while (it.hasNext()) {
            Object lvGetterProp = it.next();
            if (!pvSetterMap.containsKey(lvGetterProp)) continue;
            lvMap.put(lvGetterProp, pvGetterMap.get(lvGetterProp));
        }
        return Collections.unmodifiableMap(lvMap);
    }

    public static Map<Object, Object> getAllGetterMethodWithCache(Class<?> pvClass, String[] pvFilter) {
        Map<Object, Object> lvGetterMap = classPropertiesCacheGetter.getClassPropertiesMapByClass(pvClass);
        if (lvGetterMap == null) {
            lvGetterMap = ReflectionMethodHelper.getAllGetterMethod(pvClass);
            Map<Object, Object> lvSetterMap = ReflectionMethodHelper.getAllSetterMethodWithCache(pvClass, pvFilter);
            lvGetterMap = ReflectionMethodHelper.getAllNotEqualsGetterAndSetterAndRemoveThisProperties(lvGetterMap, lvSetterMap);
            classPropertiesCacheGetter.addClassPropertiesMap(pvClass, lvGetterMap);
        }
        return lvGetterMap;
    }

    public static Map<Object, Object> getAllSetterMethodWithCache(Class<?> pvClass, String[] pvFilter) {
        Map<Object, Object> lvMap = classPropertiesCacheSetter.getClassPropertiesMapByClass(pvClass);
        if (lvMap == null) {
            lvMap = ReflectionMethodHelper.getAllSetterMethod(pvClass);
            classPropertiesCacheSetter.addClassPropertiesMap(pvClass, lvMap);
        }
        lvMap = Util.filterMapByKeys(lvMap, pvFilter);
        return lvMap;
    }

    public static Method[] getAllMethodsByClass(Class<?> pvClass) {
        return ReflectionMethodHelper.getAllMethodsByClassIntern(pvClass, new HashSet<Method>()).toArray(new Method[0]);
    }

    private static Collection<Method> getAllMethodsByClassIntern(Class<?> pvClass, Set<Method> pvMethodsMap) {
        ReflectionMethodHelper.putAllMethodsIntern(pvClass.getMethods(), pvMethodsMap);
        ReflectionMethodHelper.putAllMethodsIntern(pvClass.getDeclaredMethods(), pvMethodsMap);
        if (!pvClass.getSuperclass().equals(Object.class)) {
            ReflectionMethodHelper.getAllMethodsByClassIntern(pvClass.getSuperclass(), pvMethodsMap);
        }
        return pvMethodsMap;
    }

    private static void putAllMethodsIntern(Method[] pvAllMethods, Set<Method> pvMethodsMap) {
        for (int i = 0; i < pvAllMethods.length; ++i) {
            String lvMethodName = pvAllMethods[i].getName();
            if (!lvMethodName.startsWith("set") && !lvMethodName.startsWith("get") && !lvMethodName.startsWith("is")) continue;
            pvMethodsMap.add(pvAllMethods[i]);
        }
    }

    public static Map<Object, Object> getAllGetterAndSetterMethod(Class<?> pvClass, int pvMethodType) {
        Method[] lvAllMethods = ReflectionMethodHelper.getAllMethodsByClass(pvClass);
        TreeMap<String, Object> lvGetterOrSetter = new TreeMap<String, Object>();
        for (int i = 0; i < lvAllMethods.length; ++i) {
            Method lvMethod = null;
            String lvPropName = lvAllMethods[i].getName();
            switch (pvMethodType) {
                case 1: {
                    if (!lvPropName.startsWith("get") && !lvPropName.startsWith("is")) break;
                    lvMethod = lvAllMethods[i];
                    if (!NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled() || ReflectionMethodHelper.isMethodSetterAndGetterCompliant(lvMethod.getReturnType())) break;
                    NonCriticalExceptionHandler.handleException(ReflectionMethodHelper.class, "The method: " + lvMethod + " is not valid getter-method (bean complaint)");
                    break;
                }
                case 2: {
                    if (!lvPropName.startsWith("set")) break;
                    lvMethod = lvAllMethods[i];
                    if (!NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled() || lvMethod.getParameterTypes().length == 1 || !ReflectionMethodHelper.isMethodSetterAndGetterCompliant(lvMethod.getParameterTypes()[0])) break;
                    NonCriticalExceptionHandler.handleException(ReflectionMethodHelper.class, "The method: " + lvMethod + " is not valid setter-method (bean complaint)");
                    break;
                }
            }
            if (lvMethod == null) continue;
            AccessController.doPrivileged(new AccessiblePrivilegedAction(lvMethod));
            lvPropName = lvPropName.startsWith("is") ? lvPropName.substring(2) : lvPropName.substring(3);
            if (lvPropName.length() > 0) {
                if ((lvPropName = lvPropName.substring(0, 1).toLowerCase() + lvPropName.substring(1)).equals("class")) {
                    lvGetterOrSetter.put(Util.getKeyWordClass(), pvClass.getName());
                    continue;
                }
                lvGetterOrSetter.put(lvPropName, lvMethod);
                continue;
            }
            if (!NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) continue;
            NonCriticalExceptionHandler.handleException(ReflectionMethodHelper.class, "Invalid Property-Name: '" + lvAllMethods[i].getName() + "' (Valid Property-Name is: set[name] or get[name], eg. setYear and getYear).");
        }
        return Collections.unmodifiableMap(lvGetterOrSetter);
    }

    public static boolean isMethodSetterAndGetterCompliant(Class<?> pvClass) {
        boolean lvReturn = false;
        if (ReflectionHelper.isSimpleType(pvClass)) {
            lvReturn = true;
        } else if (pvClass.isInterface()) {
            lvReturn = true;
        } else if (pvClass.getName().startsWith("java.util.")) {
            lvReturn = false;
        } else if (pvClass.getConstructors().length > 0) {
            Constructor<?>[] lvConstructor = pvClass.getConstructors();
            for (int i = 0; i < lvConstructor.length; ++i) {
                if (lvConstructor[i].getParameterTypes().length != 0) continue;
                lvReturn = true;
                break;
            }
        }
        return lvReturn;
    }
}

