/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Resources;
import com.supermap.data.Size2D;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolMarkerLibrary;
import com.supermap.data.Toolkit;
import com.supermap.realspace.Layer3DDataset;
import com.supermap.realspace.Layer3DSettingVector;
import com.supermap.realspace.Theme3D;
import com.supermap.realspace.Theme3DType;
import com.supermap.ui.InternalImageIconFactory;
import com.supermap.ui.NodeDataType;
import com.supermap.ui.TreeNodeData;
import com.supermap.ui.TreeNodeDecorator;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class Layer3DDatasetNodeDecorator
implements TreeNodeDecorator {
    Layer3DDatasetNodeDecorator() {
    }

    public void decorate(JLabel jLabel, TreeNodeData treeNodeData) {
        if (treeNodeData.getType().equals((Object)NodeDataType.LAYER3DDATASET)) {
            Layer3DDataset layer3DDataset = (Layer3DDataset)treeNodeData.getData();
            jLabel.setText(layer3DDataset.getCaption());
            Dataset dataset = layer3DDataset.getDataset();
            if (dataset == null) {
                ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
                BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.drawImage(InternalImageIconFactory.DT_UNKNOWN.getImage(), 0, 0, jLabel);
                imageIcon.setImage(bufferedImage);
            } else {
                Resources resources = dataset.getDatasource().getWorkspace().getResources();
                if (layer3DDataset.getTheme() != null) {
                    Theme3D theme3D = layer3DDataset.getTheme();
                    ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
                    BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
                    Graphics graphics = bufferedImage.getGraphics();
                    Theme3DType theme3DType = theme3D.getType();
                    if (theme3DType.equals((Object)Theme3DType.LABEL3D)) {
                        graphics.drawImage(InternalImageIconFactory.THEME3DLABEL.getImage(), 0, 0, jLabel);
                    } else if (theme3DType.equals((Object)Theme3DType.RANGE3D)) {
                        graphics.drawImage(InternalImageIconFactory.THEME3DRANGE.getImage(), 0, 0, jLabel);
                    } else if (theme3DType.equals((Object)Theme3DType.UNIQUE3D)) {
                        graphics.drawImage(InternalImageIconFactory.THEME3DUNIQUE.getImage(), 0, 0, jLabel);
                    }
                    imageIcon.setImage(bufferedImage);
                } else if (dataset instanceof DatasetVector) {
                    Geometry geometry;
                    GeoStyle geoStyle;
                    GeoStyle3D geoStyle3D;
                    Layer3DSettingVector layer3DSettingVector;
                    DatasetVector datasetVector = (DatasetVector)dataset;
                    ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
                    BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
                    Graphics graphics = bufferedImage.getGraphics();
                    DatasetType datasetType = datasetVector.getType();
                    if (datasetType.equals((Object)DatasetType.POINT) || datasetType.equals((Object)DatasetType.POINT3D)) {
                        layer3DSettingVector = (Layer3DSettingVector)layer3DDataset.getAdditionalSetting();
                        if (layer3DSettingVector == null) {
                            layer3DSettingVector = new Layer3DSettingVector();
                        }
                        geoStyle3D = layer3DSettingVector.getStyle();
                        geoStyle = this._$1(geoStyle3D);
                        geometry = this._$1(datasetType);
                        geometry.setStyle(geoStyle);
                        SymbolMarkerLibrary symbolMarkerLibrary = resources.getMarkerLibrary();
                        int n = geoStyle.getMarkerSymbolID();
                        if (n < 1) {
                            graphics.setColor(geoStyle.getLineColor());
                            graphics.fillOval(6, 6, 4, 4);
                        } else {
                            Symbol symbol = symbolMarkerLibrary.findSymbol(n);
                            symbol.draw(graphics, geometry);
                        }
                        imageIcon.setImage(bufferedImage);
                    }
                    if (datasetType.equals((Object)DatasetType.LINE) || datasetType.equals((Object)DatasetType.LINE3D)) {
                        layer3DSettingVector = (Layer3DSettingVector)layer3DDataset.getAdditionalSetting();
                        if (layer3DSettingVector == null) {
                            layer3DSettingVector = new Layer3DSettingVector();
                        }
                        geoStyle3D = layer3DSettingVector.getStyle();
                        geoStyle = this._$1(geoStyle3D);
                        geoStyle.setLineWidth(0.2);
                        geometry = this._$1(datasetType);
                        geometry.setStyle(geoStyle);
                        Toolkit.draw((Geometry)geometry, (Resources)resources, (Graphics)graphics);
                        imageIcon.setImage(bufferedImage);
                    }
                    if (datasetType.equals((Object)DatasetType.REGION) || datasetType.equals((Object)DatasetType.REGION3D)) {
                        layer3DSettingVector = (Layer3DSettingVector)layer3DDataset.getAdditionalSetting();
                        if (layer3DSettingVector == null) {
                            layer3DSettingVector = new Layer3DSettingVector();
                        }
                        geoStyle3D = layer3DSettingVector.getStyle();
                        geoStyle = this._$1(geoStyle3D);
                        geometry = this._$1(datasetType);
                        geometry.setStyle(geoStyle);
                        Toolkit.draw((Geometry)geometry, (Resources)resources, (Graphics)graphics);
                        imageIcon.setImage(bufferedImage);
                    } else if (datasetType.equals((Object)DatasetType.CAD)) {
                        graphics.drawImage(InternalImageIconFactory.DT_CAD.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.LINEM)) {
                        graphics.drawImage(InternalImageIconFactory.DT_LINEM.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.LINKTABLE)) {
                        graphics.drawImage(InternalImageIconFactory.DT_LINKTABLE.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.NETWORK)) {
                        graphics.drawImage(InternalImageIconFactory.DT_NETWORK.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.TABULAR)) {
                        graphics.drawImage(InternalImageIconFactory.DT_TABULAR.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.TEXT)) {
                        graphics.drawImage(InternalImageIconFactory.DT_TEXT.getImage(), 0, 0, jLabel);
                    }
                    imageIcon.setImage(bufferedImage);
                } else if (dataset instanceof DatasetImage) {
                    DatasetImage datasetImage = (DatasetImage)dataset;
                    DatasetType datasetType = datasetImage.getType();
                    ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
                    BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
                    Graphics graphics = bufferedImage.getGraphics();
                    if (datasetType.equals((Object)DatasetType.IMAGE)) {
                        graphics.drawImage(InternalImageIconFactory.DT_IMAGE.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.WCS)) {
                        graphics.drawImage(InternalImageIconFactory.DT_WCS.getImage(), 0, 0, jLabel);
                    } else if (datasetType.equals((Object)DatasetType.WMS)) {
                        graphics.drawImage(InternalImageIconFactory.DT_WMS.getImage(), 0, 0, jLabel);
                    }
                    imageIcon.setImage(bufferedImage);
                } else if (dataset instanceof DatasetGrid) {
                    ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
                    BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
                    Graphics graphics = bufferedImage.getGraphics();
                    graphics.drawImage(InternalImageIconFactory.DT_GRID.getImage(), 0, 0, jLabel);
                    imageIcon.setImage(bufferedImage);
                }
            }
        }
    }

    private Geometry _$1(DatasetType datasetType) {
        if (datasetType.equals((Object)DatasetType.POINT) || datasetType.equals((Object)DatasetType.POINT3D)) {
            GeoPoint geoPoint = new GeoPoint();
            return geoPoint;
        }
        if (datasetType.equals((Object)DatasetType.LINE) || datasetType.equals((Object)DatasetType.LINE3D)) {
            Point2D[] point2DArray = new Point2D[]{new Point2D(0.0, 16.0), new Point2D(4.0, 0.0), new Point2D(12.0, 16.0), new Point2D(16.0, 0.0)};
            Point2Ds point2Ds = new Point2Ds(point2DArray);
            GeoLine geoLine = new GeoLine(point2Ds);
            return geoLine;
        }
        if (datasetType.equals((Object)DatasetType.REGION) || datasetType.equals((Object)DatasetType.REGION3D)) {
            Point2D[] point2DArray = new Point2D[]{new Point2D(1.0, 15.0), new Point2D(1.0, 5.0), new Point2D(10.0, 1.0), new Point2D(15.0, 5.0), new Point2D(15.0, 15.0), new Point2D(1.0, 15.0)};
            Point2Ds point2Ds = new Point2Ds(point2DArray);
            GeoRegion geoRegion = new GeoRegion(point2Ds);
            return geoRegion;
        }
        return null;
    }

    private GeoStyle _$1(GeoStyle3D geoStyle3D) {
        GeoStyle geoStyle = new GeoStyle();
        geoStyle.setFillBackColor(geoStyle3D.getFillForeColor());
        geoStyle.setFillForeColor(geoStyle3D.getFillForeColor());
        geoStyle.setLineColor(geoStyle3D.getLineColor());
        if (geoStyle3D.getLineWidth() > 0.2) {
            geoStyle.setLineWidth(0.2);
        } else {
            geoStyle.setLineWidth(geoStyle3D.getLineWidth());
        }
        geoStyle.setMarkerSize(new Size2D(geoStyle3D.getMarkerSize(), geoStyle3D.getMarkerSize()));
        return geoStyle;
    }
}

