/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.AltitudeMode;
import com.supermap.data.Enum;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoModel;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.License;
import com.supermap.data.LicenseFeatureInfo;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Point3D;
import com.supermap.data.ProductType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.realspace.Atmosphere;
import com.supermap.realspace.Camera;
import com.supermap.realspace.FlownEvent;
import com.supermap.realspace.FlownListener;
import com.supermap.realspace.FlyManager;
import com.supermap.realspace.FlyingMode;
import com.supermap.realspace.Fog;
import com.supermap.realspace.GlobalImage;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalSceneControl;
import com.supermap.realspace.InternalToolkitSpace;
import com.supermap.realspace.LatLonGrid;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3Ds;
import com.supermap.realspace.Ocean;
import com.supermap.realspace.ParallaxMode;
import com.supermap.realspace.PixelToGlobeMode;
import com.supermap.realspace.SceneClosedEvent;
import com.supermap.realspace.SceneClosedListener;
import com.supermap.realspace.SceneNative;
import com.supermap.realspace.SceneOpenedEvent;
import com.supermap.realspace.SceneOpenedListener;
import com.supermap.realspace.ScreenLayer3D;
import com.supermap.realspace.Selection3D;
import com.supermap.realspace.StereoMode;
import com.supermap.realspace.Sun;
import com.supermap.realspace.TerrainLayers;
import com.supermap.realspace.TrackingLayer3D;
import com.supermap.realspace.Underground;
import com.supermap.ui.InternalBufferImage;
import com.supermap.ui.SceneControl;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Timer;

public class Scene
extends InternalHandleDisposable {
    private Workspace _$18;
    private Layer3Ds _$17;
    private ScreenLayer3D _$16;
    private TrackingLayer3D _$15;
    private Fog _$14;
    private LatLonGrid _$13;
    private Atmosphere _$12;
    private Ocean _$11;
    private Sun _$10;
    private Underground _$9;
    private GlobalImage _$8;
    private TerrainLayers _$7;
    private SceneControl _$6;
    private License _$5;
    private FlyManager _$4;
    private static final double _$3 = Math.PI / 180;
    private static final double _$2 = 57.29577951308232;
    transient Vector m_flownListeners;
    transient Vector m_sceneOpenedListeners;
    transient Vector m_sceneClosedListeners;
    private Timer _$1;

    public Scene() {
        this(null);
    }

    public Scene(Workspace workspace) {
        this._$6();
        long l = SceneNative.jni_New("");
        this.setHandle(l, true);
        if (workspace != null) {
            long l2 = InternalHandle.getHandle((InternalHandle)workspace);
            if (l2 == 0L) {
                String string = InternalResource.loadString("workspace", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            this.setWorkspace(workspace);
        }
    }

    Scene(long l, SceneControl sceneControl, Timer timer) {
        this._$6();
        this._$5();
        this.setHandle(l, false);
        this._$6 = sceneControl;
        this._$1 = timer;
        SceneNative.jni_NewSelfEventHandle(InternalSceneControl.getHandle(this._$6), this);
        SceneNative.jni_SetDrawMode(this.getHandle());
    }

    private void _$6() {
        ArrayList<ProductType> arrayList = InternalToolkitSpace.managerProducts(InternalToolkitSpace.getSpaceProducts());
        this._$5 = InternalToolkitSpace.verifyLicense(arrayList);
        LicenseFeatureInfo licenseFeatureInfo = this._$5.getFeatureInfo();
        InternalToolkitSpace.setSpaceRuntimeLicenseMode(licenseFeatureInfo.isTrial());
        InternalToolkitSpace.updateStatus();
    }

    private void _$5() {
        ProductType productType;
        ArrayList<ProductType> arrayList = InternalToolkitSpace.managerProducts(InternalToolkitSpace.getSpace3DEffectProducts());
        int n = -1;
        License license = new License();
        Iterator<ProductType> iterator = arrayList.iterator();
        while (iterator.hasNext() && (n = license.connect(productType = iterator.next())) != 0) {
        }
        if (n == 0) {
            n = license.verify();
        }
        if (n != 0) {
            SceneNative.jni_SetIsSpace3DEffectVailed(this.getHandle(), false);
        }
    }

    private void _$4() {
        if (this._$5 != null) {
            this._$5.disconnect();
            this._$5.dispose();
            this._$5 = null;
        }
    }

    public boolean isOverlapDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOverlapDisplayed()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsOverlapDisplayed(this.getHandle());
    }

    public void setOverlapDisplayed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetOverlapDisplayed(this.getHandle(), bl);
    }

    public double getFPS() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFPS()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetFPS(this.getHandle());
    }

    public Timer getTimer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimer()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this._$1;
    }

    public Camera getCamera() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCamera()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[6];
        long l = SceneNative.jni_GetCamera(this.getHandle(), dArray);
        Camera camera = null;
        if (l != 0L) {
            camera = new Camera(dArray[0] * 57.29577951308232, dArray[1] * 57.29577951308232, Camera.computeAltitude(dArray[2], dArray[5] * 57.29577951308232), (AltitudeMode)InternalEnum.parse(AltitudeMode.class, (int)((int)dArray[3])), dArray[4] * 57.29577951308232, dArray[5] * 57.29577951308232);
        }
        return camera;
    }

    public void setCamera(Camera camera) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCamera(camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        SceneNative.jni_SetCameraValue(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180));
    }

    public TerrainLayers getTerrainLayers() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetTerrainLayers()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$7 == null && (l = SceneNative.jni_getTerrainLayers(this.getHandle())) != 0L) {
            this._$7 = TerrainLayers.createInstance(this, l);
        }
        return this._$7;
    }

    public double getTerrainExaggeration() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTerrainExaggeration()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetTerrainExaggeration(this.getHandle());
    }

    public void setTerrainExaggeration(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTerrainExaggeration(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetTerrainExaggeration(this.getHandle(), d);
    }

    public LatLonGrid getLatLonGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLatLonGrid()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$13 == null) {
            this._$13 = new LatLonGrid(this);
        }
        return this._$13;
    }

    public Atmosphere getAtmosphere() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAtmosphere()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$12 == null) {
            this._$12 = new Atmosphere(this);
        }
        return this._$12;
    }

    public Ocean getOcean() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOcean()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$11 == null) {
            this._$11 = new Ocean(this);
        }
        return this._$11;
    }

    public Sun getSun() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSun", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$10 == null) {
            this._$10 = new Sun(this);
        }
        return this._$10;
    }

    public Underground getUnderground() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Underground getUnderground()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$9 == null) {
            this._$9 = new Underground(this);
        }
        return this._$9;
    }

    public GlobalImage getGlobalImage() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GlobalImage getGlobalImage()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 == null) {
            this._$8 = new GlobalImage(this);
        }
        return this._$8;
    }

    public boolean isScaleLegendVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isScaleLegendVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsScaleLegendVisible(this.getHandle());
    }

    public void setScaleLegendVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScaleLegendVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetScaleLegendVisible(this.getHandle(), bl);
    }

    public boolean isCrossVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCrossVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsCrossVisible(this.getHandle());
    }

    public void setCrossVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCrossVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetCrossVisible(this.getHandle(), bl);
    }

    public Selection3D[] findSelection(boolean bl) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSelection(boolean hasObjectSelected)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3Ds layer3Ds = this.getLayers();
        int n2 = layer3Ds.getCount();
        ArrayList<Selection3D> arrayList = new ArrayList<Selection3D>();
        if (bl) {
            for (n = 0; n < n2; ++n) {
                Layer3D layer3D = layer3Ds.get(n);
                Selection3D selection3D = layer3D.getSelection();
                if (selection3D.getCount() <= 0) continue;
                arrayList.add(selection3D);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                Layer3D layer3D = layer3Ds.get(n);
                Selection3D selection3D = layer3D.getSelection();
                arrayList.add(selection3D);
            }
        }
        Selection3D[] selection3DArray = new Selection3D[arrayList.size()];
        return arrayList.toArray(selection3DArray);
    }

    public TrackingLayer3D getTrackingLayer() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTrackingLayer()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$15 == null && (l = SceneNative.jni_GetTrackingLayer(this.getHandle())) != 0L) {
            this._$15 = TrackingLayer3D.createInstance(l, this);
        }
        return this._$15;
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorkspace()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this._$18;
    }

    public void setWorkspace(Workspace workspace) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWorkspace(Workspace workspace)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.getWorkspace() != null && this.getWorkspace().equals(workspace)) {
            return;
        }
        String string = "";
        if (this._$18 != null) {
            l = InternalHandle.getHandle((InternalHandle)this._$18);
            if (l == 0L) {
                String string2 = InternalResource.loadString("setWorkspace()", "Map_DontDisposeOldWorkspace", "realspace_resources");
                throw new IllegalStateException(string2);
            }
            string = this.toXML();
        }
        this.close();
        if (workspace == null) {
            this._$18 = null;
        } else {
            l = InternalHandle.getHandle((InternalHandle)workspace);
            if (l == 0L) {
                String string3 = InternalResource.loadString("workspace", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string3);
            }
            SceneNative.jni_SetWorkspace(this.getHandle(), l);
            this._$18 = workspace;
        }
        if (!string.trim().equals("")) {
            this.fromXML(string);
        }
    }

    public Layer3Ds getLayers() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLayers()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$17 == null && (l = SceneNative.jni_GetLayers(this.getHandle())) != 0L) {
            this._$17 = Layer3Ds.createInstance(l, this);
        }
        return this._$17;
    }

    public ScreenLayer3D getScreenLayer() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScreenLayer()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$16 == null && (l = SceneNative.jni_GetScreenLayer(this.getHandle())) != 0L) {
            this._$16 = new ScreenLayer3D(l, InternalSceneControl.getHandle(this._$6));
        }
        return this._$16;
    }

    public Fog getFog() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFog()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$14 == null && (l = SceneNative.jni_GetFog(this.getHandle())) != 0L) {
            this._$14 = Fog.createInstance(l);
        }
        return this._$14;
    }

    public void setFog(Fog fog) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFog(Fog fog)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (fog == null) {
            String string = InternalResource.loadString("fog", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)fog);
        if (l == 0L) {
            String string = InternalResource.loadString("fog", "Global_InvalidConstructorArgument", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        SceneNative.jni_SetFog(this.getHandle(), l);
    }

    public double getAltitude(double d, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAltitude(double longitude, double latitude)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetAltitude(this.getHandle(), d, d2);
    }

    public void setFogVisibleAltitude(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFogVisibleAltitude(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_setFogVisibleAltitude(this.getHandle(), d);
    }

    public double getFogVisibleAltitude() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetFogVisibleAltitude()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_getFogVisibleAltitude(this.getHandle());
    }

    @Deprecated
    public void fly(Geometry geometry, FlyingMode flyingMode) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyTo(Object targetObject, FlyingMode flyingMode)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("targetObject", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (InternalHandleDisposable.getHandle((InternalHandle)geometry) == 0L) {
            String string = InternalResource.loadString("targetObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("targetObject", "Scene_FlyGeometryShouldNotBeNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (flyingMode == null) {
            String string = InternalResource.loadString("flyingMode", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        FlyingMode flyingMode2 = flyingMode;
        if (flyingMode == FlyingMode.FLYINGPLAY && !(geometry instanceof GeoLine3D) && !(geometry instanceof GeoLine)) {
            flyingMode2 = FlyingMode.FLYINGTO;
        }
        int n = InternalEnum.getUGCValue(flyingMode2);
        SceneNative.jni_FlyToGeometry(this.getHandle(), InternalHandleDisposable.getHandle((InternalHandle)geometry), n);
    }

    public void fly(Camera camera) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyTo(Camera camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        SceneNative.jni_FlyToCamera(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180));
    }

    public void fly(Camera camera, int n) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyTo(Object targetObject, FlyingMode flyingMode)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("milliseconds", "Scene_FlyMillisecondsShouldMoreThanZERO", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (n == 0) {
            n = 1;
        }
        SceneNative.jni_FlyToBymillisecondsCamera(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180), n);
    }

    @Deprecated
    public void fly(Geometry geometry, int n) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fly(Geometry targetObject, int milliseconds)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("targetObject", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("targetObject", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("targetObject", "Scene_FlyGeometryShouldNotBeNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("milliseconds", "Scene_FlyMillisecondsShouldMoreThanZERO", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (n == 0) {
            n = 1;
        }
        SceneNative.jni_FlyToBymillisecondsWithObject(this.getHandle(), l, n);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
    }

    @Deprecated
    public void fly(Camera camera, boolean bl) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyTo(Camera camera, boolean isDirect)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        SceneNative.jni_FlyToCameraDirect(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180), bl);
    }

    @Deprecated
    public void fly(Camera camera, int n, boolean bl) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyTo(Object targetObject, FlyingMode flyingMode, boolean isDirect)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("milliseconds", "Scene_FlyMillisecondsShouldMoreThanZERO", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (n == 0) {
            n = 1;
        }
        SceneNative.jni_FlyToBymillisecondsCameraDirect(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180), n, bl);
    }

    @Deprecated
    public void flyPlay(Geometry geometry, double d, double d2) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("flyPlay(Geometry line, double speedRatio, double distance)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("line", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("line", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (!geometry.getType().equals((Object)GeometryType.GEOLINE) && !geometry.getType().equals((Object)GeometryType.GEOLINE3D)) {
            String string = InternalResource.loadString("line", "Scene_FlyPlayGeometryTypeUnsupport", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("speedRatio", "Scene_FlyPlaySpeedRatioShouldMoreThanZERO", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        SceneNative.jni_FlyPlay(this.getHandle(), l, d, d2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
    }

    public void flyCircle(Geometry geometry, double d) {
        this._$2();
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("speedRatio", "Scene_FlyPlaySpeedRatioShouldMoreThanZERO", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        SceneNative.jni_FlyCircle(this.getHandle(), l, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
    }

    public void stopFly() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("stopFly()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_StopFly(this.getHandle());
    }

    public Point3D pixelToGlobe(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pixelToGlobe(Point point)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Point3D point3D = new Point3D();
        double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
        if (this._$6 != null && InternalSceneControl.getHandle(this._$6) != 0L) {
            double[] dArray2 = new double[]{point.getX(), point.getY()};
            SceneNative.jni_PixelToScene(this.getHandle(), InternalSceneControl.getHandle(this._$6), dArray2, dArray);
        }
        point3D.setX(dArray[0] * 57.29577951308232);
        point3D.setY(dArray[1] * 57.29577951308232);
        point3D.setZ(dArray[2]);
        return point3D;
    }

    public Point3D pixelToGlobe(Point point, PixelToGlobeMode pixelToGlobeMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pixelToGlobe(Point point, PixelToGlobeMode mode)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Point3D point3D = new Point3D();
        double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
        if (this._$6 != null && InternalSceneControl.getHandle(this._$6) != 0L) {
            double[] dArray2 = new double[]{point.getX(), point.getY()};
            SceneNative.jni_PixelToWorld(this.getHandle(), InternalSceneControl.getHandle(this._$6), dArray2, pixelToGlobeMode.value(), dArray);
        }
        point3D.setX(dArray[0] * 57.29577951308232);
        point3D.setY(dArray[1] * 57.29577951308232);
        point3D.setZ(dArray[2]);
        return point3D;
    }

    public Point globeToPixel(Point3D point3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("globeToPixel(Point3D point)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{point3D.getX(), point3D.getY(), point3D.getZ()};
        double[] dArray2 = new double[2];
        if (this._$6 != null && InternalSceneControl.getHandle(this._$6) != 0L) {
            SceneNative.jni_SceneToPixel(this.getHandle(), InternalSceneControl.getHandle(this._$6), dArray, dArray2);
        }
        Point point = new Point();
        point.x = (int)dArray2[0];
        point.y = (int)dArray2[1];
        return point;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SceneNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
        this._$4();
    }

    public void pan(double d, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Pan(double offsetLongitude, double offsetLatitude)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_Pan(this.getHandle(), d, d2);
    }

    public void zoom(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("zoom(double ratio)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_Zoom(this.getHandle(), d);
    }

    public void pitch(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pitch(double angle)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_Pitch(this.getHandle(), d);
    }

    public void viewEntire() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("viewEntire()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_ViewEntire(this.getHandle());
    }

    public void refresh() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("refresh()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_Refresh(this.getHandle());
    }

    public String toXML() {
        String string;
        File file;
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (!this._$3()) {
            String string3 = InternalResource.loadString("toXML()", "Map_WorkspaceIsEmpty", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        String string4 = "";
        if (this.getWorkspace() != null && (file = new File(string = this.getWorkspace().getConnectionInfo().getServer())).exists()) {
            string4 = file.getParent();
        }
        return SceneNative.jni_ToXML(this.getHandle(), string4);
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$18 == null || InternalHandle.getHandle((InternalHandle)this._$18) == 0L) {
            String string3 = InternalResource.loadString("fromXML(String xml)", "Map_WorkspaceIsEmpty", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            String string4;
            File file;
            String string5 = "";
            if (this.getWorkspace() != null && (file = new File(string4 = this.getWorkspace().getConnectionInfo().getServer())).exists()) {
                string5 = file.getParent();
            }
            long l = 0L;
            if (this.getWorkspace() != null) {
                l = InternalHandle.getHandle((InternalHandle)this.getWorkspace());
            }
            if (bl = SceneNative.jni_FromXML(this.getHandle(), string, string5, l)) {
                this._$1();
                this.getLayers();
                this.getTerrainLayers();
                SceneOpenedEvent sceneOpenedEvent = new SceneOpenedEvent((Object)this, this);
                this.fireSceneOpened(sceneOpenedEvent);
            }
        }
        return bl;
    }

    public double getCameraFOV() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCameraFOV()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_getCameraFOV(this.getHandle()) * 57.29577951308232;
    }

    public void setCameraFOV(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetCameraFOV(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0 || d >= 180.0) {
            String string = InternalResource.loadString("value", "Scene_CameraFOVOutOfRange", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        SceneNative.jni_setCameraFOV(this.getHandle(), d * (Math.PI / 180));
    }

    public double getMaxCameraDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetMaxCameraDistance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_getMaxCameraDistance(this.getHandle());
    }

    public void setMaxCameraDistance(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxCameraDistance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("setMaxCameraDistance(double value)", "Scene_MaxCameraDistanceShouldNotBeNegative", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_setMaxCameraDistance(this.getHandle(), d);
    }

    public double getMinCameraDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinCameraDistance()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_getMinCameraDistance(this.getHandle());
    }

    public void setMinCameraDistance(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinCameraDistance(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("setMaxCameraDistance(double value)", "Scene_MinCameraDistanceShouldNotBeNegative", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_setMinCameraDistance(this.getHandle(), d);
    }

    public boolean open(String string) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("open()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$18 == null) {
            String string3 = InternalResource.loadString("workspace", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        long l = InternalHandle.getHandle((InternalHandle)this._$18);
        if (l == 0L) {
            String string4 = InternalResource.loadString("workspace", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("name", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string5);
        }
        int n = this._$18.getScenes().indexOf(string);
        if (n == -1) {
            String string6 = InternalResource.loadString("name", "Scene_SpecifiedNameNotExists", "realspace_resources");
            throw new IllegalStateException(string6);
        }
        String string7 = this._$18.getScenes().getSceneXML(n);
        return this.fromXML(string7);
    }

    public boolean open(String string, String string2) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("open()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("strServerUrl", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string5 = InternalResource.loadString("strSceneName", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string5);
        }
        boolean bl = SceneNative.jni_Open(this.getHandle(), string, string2);
        if (this._$17 != null) {
            this._$17.clearHandle();
            this._$17 = null;
        }
        if (this._$7 != null) {
            this._$7.clearHandle();
            this._$7 = null;
        }
        return bl;
    }

    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("close()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$17 != null) {
            this._$17.clear();
        }
        if (this._$7 != null) {
            this._$7.clear();
        }
        SceneNative.jni_Reset(this.getHandle());
        SceneNative.jni_SetDrawMode(this.getHandle());
        SceneClosedEvent sceneClosedEvent = new SceneClosedEvent((Object)this, this);
        this.fireSceneClosed(sceneClosedEvent);
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string3);
        }
        SceneNative.jni_setName(this.getHandle(), string);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_getName(this.getHandle());
    }

    public void roll(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("roll(double angle)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_roll(this.getHandle(), d);
    }

    public boolean roll(Point2D point2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("roll(Point2D center, double angle)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_Roll2(this.getHandle(), point2D.getX(), point2D.getY(), d);
    }

    public void rollEye(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rollEye(double angle)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_rollEye(this.getHandle(), d);
    }

    public double computeSphericalDistance(Point2D point2D, Point2D point2D2) {
        double d;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeSphericalDistance(Point2D point1, Point2D point2)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double d2 = point2D2.getX() % 360.0;
        double d3 = point2D.getY() % 180.0;
        double d4 = point2D2.getY() % 180.0;
        for (d = point2D.getX() % 360.0; d < 0.0; d += 360.0) {
        }
        while (d > 360.0) {
            d -= 360.0;
        }
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        while (d2 > 360.0) {
            d2 -= 360.0;
        }
        return SceneNative.jni_ComputeSphericalDistance(d, d3, d2, d4);
    }

    public double computeSphericalArea(Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeSphericalDistance(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = point2Ds.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        return SceneNative.jni_ComputeSphericalArea(dArray, dArray2);
    }

    public void ensureVisible(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Rectangle2D visibleBounds)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_EnsureVisible(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public void ensureVisible(Rectangle2D rectangle2D, int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Rectangle2D visibleBounds, int milliseconds)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("milliseconds", "Scene_FlyMillisecondsShouldMoreThanZERO", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (n == 0) {
            n = 1;
        }
        SceneNative.jni_EnsureVisible2(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop(), n);
    }

    public void ensureVisible(Layer3D layer3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Layer3D layer3d)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (layer3D == null) {
            String string = InternalResource.loadString("layer3d", "Global_ArgumentNull", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        SceneNative.jni_EnsureVisible3(this.getHandle(), InternalHandle.getHandle((InternalHandle)layer3D));
    }

    public BufferedImage outputSceneToBitmap() {
        this._$2();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToBitmap", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$6 == null || InternalSceneControl.getHandle(this._$6) == 0L) {
            String string = InternalResource.loadString("outputMapToBitmap", "Scene_RenderEnvironmentInvalid", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        int[] nArray = new int[2];
        SceneNative.jni_GetImageBounds(this.getHandle(), nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        InternalBufferImage internalBufferImage = new InternalBufferImage(n, n2);
        SceneNative.jni_OutputSceneToBitmap(this.getHandle(), InternalHandleDisposable.getHandle((InternalHandle)internalBufferImage));
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(), 0, 0, null);
        internalBufferImage.dispose();
        return bufferedImage;
    }

    static void flownCallBack(Scene scene) {
        if (scene != null) {
            FlownEvent flownEvent = new FlownEvent((Object)scene, scene.getCamera());
            scene.fireFlown(flownEvent);
        }
    }

    public synchronized void addFlownListener(FlownListener flownListener) {
        if (this.m_flownListeners == null) {
            this.m_flownListeners = new Vector();
        }
        if (!this.m_flownListeners.contains(flownListener)) {
            this.m_flownListeners.add(flownListener);
        }
    }

    public synchronized void removeFlownListener(FlownListener flownListener) {
        if (this.m_flownListeners != null && this.m_flownListeners.contains(flownListener)) {
            this.m_flownListeners.remove(flownListener);
        }
    }

    protected void fireFlown(FlownEvent flownEvent) {
        if (this.m_flownListeners != null) {
            Vector vector = this.m_flownListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((FlownListener)vector.elementAt(i)).flown(flownEvent);
            }
        }
    }

    public synchronized void addSceneOpenedListener(SceneOpenedListener sceneOpenedListener) {
        if (this.m_sceneOpenedListeners == null) {
            this.m_sceneOpenedListeners = new Vector();
        }
        if (!this.m_sceneOpenedListeners.contains(sceneOpenedListener)) {
            this.m_sceneOpenedListeners.add(sceneOpenedListener);
        }
    }

    public synchronized void removeSceneOpenedListener(SceneOpenedListener sceneOpenedListener) {
        if (this.m_sceneOpenedListeners != null && this.m_sceneOpenedListeners.contains(sceneOpenedListener)) {
            this.m_sceneOpenedListeners.remove(sceneOpenedListener);
        }
    }

    protected void fireSceneOpened(SceneOpenedEvent sceneOpenedEvent) {
        if (this.m_sceneOpenedListeners != null) {
            Vector vector = this.m_sceneOpenedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SceneOpenedListener)vector.elementAt(i)).sceneOpened(sceneOpenedEvent);
            }
        }
    }

    public synchronized void addSceneClosedListener(SceneClosedListener sceneClosedListener) {
        if (this.m_sceneClosedListeners == null) {
            this.m_sceneClosedListeners = new Vector();
        }
        if (!this.m_sceneClosedListeners.contains(sceneClosedListener)) {
            this.m_sceneClosedListeners.add(sceneClosedListener);
        }
    }

    public synchronized void removeSceneClosedListener(SceneClosedListener sceneClosedListener) {
        if (this.m_sceneClosedListeners != null && this.m_sceneClosedListeners.contains(sceneClosedListener)) {
            this.m_sceneClosedListeners.remove(sceneClosedListener);
        }
    }

    protected void fireSceneClosed(SceneClosedEvent sceneClosedEvent) {
        if (this.m_sceneClosedListeners != null) {
            Vector vector = this.m_sceneClosedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SceneClosedListener)vector.elementAt(i)).sceneClosed(sceneClosedEvent);
            }
        }
    }

    private boolean _$3() {
        boolean bl = true;
        if (this._$18 == null) {
            bl = false;
        } else {
            long l = InternalHandle.getHandle((InternalHandle)this._$18);
            if (l == 0L) {
                bl = false;
            }
        }
        return bl;
    }

    License getLicense() {
        return this._$5;
    }

    private void _$2() {
        int n = this._$5.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    protected static void clearHandle(Scene scene) {
        scene.clearHandle();
    }

    protected static Scene createInstance(long l, SceneControl sceneControl, Timer timer) {
        return new Scene(l, sceneControl, timer);
    }

    private void _$1() {
        if (this._$14 != null) {
            this._$14.clearHandle();
            this._$14 = null;
        }
        if (this._$16 != null) {
            this._$16.clearHandle();
            this._$16 = null;
        }
        if (this._$15 != null) {
            this._$15.clearHandle();
            this._$15 = null;
        }
        if (this._$17 != null) {
            this._$17.clearHandle();
            this._$17 = null;
        }
        if (this._$7 != null) {
            this._$7.clearHandle();
            this._$7 = null;
        }
    }

    protected void clearHandle() {
        this._$1();
        this._$6 = null;
        this._$18 = null;
        this._$1 = null;
        this.setHandle(0L);
    }

    public static Rectangle2D toBounds(int n, int n2, int n3) {
        Rectangle2D rectangle2D = new Rectangle2D();
        double[] dArray = new double[4];
        SceneNative.jni_toBounds(n, n2, n3, dArray);
        rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public static Rectangle2D ceilBounds(Rectangle2D rectangle2D, int n) {
        Rectangle2D rectangle2D2 = new Rectangle2D();
        double[] dArray = new double[4];
        SceneNative.jni_ceilBounds(rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop(), n, dArray);
        rectangle2D2 = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D2;
    }

    protected static void InternalClearHandle(Scene scene) {
        Scene.clearHandle(scene);
    }

    public boolean isStereoEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isStereoEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsStereoEnable(this.getHandle());
    }

    public void setStereoEnabled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStereoEnable(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetStereoEnable(this.getHandle(), bl);
    }

    public StereoMode getStereoMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStereoMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = SceneNative.jni_GetStereoMode(this.getHandle());
        return (StereoMode)Enum.parse(StereoMode.class, (int)n);
    }

    public void setStereoMode(StereoMode stereoMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStereoMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetStereoMode(this.getHandle(), stereoMode.value());
    }

    public double getStereoEyeSeparation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraSeparation()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetCameraSeparation(this.getHandle());
    }

    public void setStereoEyeSeparation(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraSeparation(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetCameraSeparation(this.getHandle(), d);
    }

    public double getStereoEyeAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraAngle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetCameraAngle(this.getHandle());
    }

    public void setStereoEyeAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraSeparation(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetCameraAngle(this.getHandle(), d);
    }

    public void setParallaxMode(ParallaxMode parallaxMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParallaxMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetParallaxMode(this.getHandle(), parallaxMode.value());
    }

    public ParallaxMode getParallaxMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParallaxMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = SceneNative.jni_GetParallaxMode(this.getHandle());
        return (ParallaxMode)Enum.parse(ParallaxMode.class, (int)n);
    }

    @Deprecated
    public boolean isFullScreen() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFullScreen()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_IsFullScreen(this.getHandle());
    }

    @Deprecated
    public void setFullScreen(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFullScreen(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetFullScreen(this.getHandle(), bl);
    }

    public boolean isStereoModeSupported(StereoMode stereoMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isActiveStereoSupported()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = true;
        if (stereoMode == StereoMode.ANAGLYPHIC || stereoMode == StereoMode.HORIZONTAL_SPLIT || stereoMode == StereoMode.VERTICAL_SPLIT) {
            bl = true;
        }
        if (stereoMode == StereoMode.QUAD_BUFFER) {
            bl = SceneNative.jni_IsActiveStereoSupported(this.getHandle());
        }
        return bl;
    }

    public void setIServerCacheDirectory(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setIServerCacheDirectory()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        SceneNative.jni_SetIServerCacheDirectory(this.getHandle(), string);
    }

    public String getIServerCacheDirectory() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIServerCacheDirectory()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetIServerCacheDirectory(this.getHandle());
    }

    public void setAutoLockTarget(GeoModel geoModel) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAutoLockTarget(GeoModel value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geoModel != null) {
            SceneNative.jni_SetAutoLockTarget(this.getHandle(), InternalHandle.getHandle((InternalHandle)geoModel));
        } else {
            SceneNative.jni_SetAutoLockTarget(this.getHandle(), 0L);
        }
    }

    public void setAutoLockOffset(Point3D point3D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAutoLockOffset(Point3D value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetAutoLockOffset(this.getHandle(), point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public Point3D getAutoLockOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAutoLockOffset()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        SceneNative.jni_GetAutoLockOffset(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        return point3D;
    }

    public Camera getFirstPersonCamera() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFirstPersonCamera()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[6];
        long l = SceneNative.jni_GetFirstPersonCamera(this.getHandle(), dArray);
        Camera camera = null;
        if (l != 0L) {
            camera = new Camera(dArray[0] * 57.29577951308232, dArray[1] * 57.29577951308232, Camera.computeAltitude(dArray[2], dArray[5] * 57.29577951308232), (AltitudeMode)InternalEnum.parse(AltitudeMode.class, (int)((int)dArray[3])), dArray[4] * 57.29577951308232, dArray[5] * 57.29577951308232);
        }
        return camera;
    }

    public void setFirstPersonCamera(Camera camera) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFirstPersonCamera(Camera camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = InternalResource.loadString("camera", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        SceneNative.jni_SetFirstPersonCameraValue(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), InternalEnum.getUGCValue((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180));
    }

    public boolean isFirstPersonView() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFirstPersonView()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetIsFirstPersonView(this.getHandle());
    }

    public void setFirstPersonView(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFirstPersonView(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetIsFirstPersonView(this.getHandle(), bl);
    }

    public FlyManager getFlyManager() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFirstPersonCamera(Camera camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null) {
            this._$4 = new FlyManager();
            this._$4.setScene(this);
        }
        return this._$4;
    }

    public double getShadowVisibleDistance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getShadowVisibleDistance", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_GetShadowVisibleDistance(this.getHandle());
    }

    public void setShadowVisibleDistance(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setShadowVisibleDistance", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_SetShadowVisibleDistance(this.getHandle(), d);
    }
}

