/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Material;
import com.supermap.data.Mesh;
import com.supermap.data.MeshesNative;
import java.util.ArrayList;

public class Meshes
extends InternalHandle {
    private ArrayList<Mesh> _$2 = null;

    protected Meshes(long l) {
        this.setHandle(l);
        this._$2 = new ArrayList();
        this._$1();
    }

    private void _$1() {
        long[] lArray = new long[2];
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            MeshesNative.jni_Get(this.getHandle(), i, lArray);
            long l = lArray[0];
            long l2 = lArray[1];
            if (l == 0L) continue;
            Mesh mesh = new Mesh(l);
            if (l2 != 0L) {
                Material material = new Material(l2);
                mesh.setMaterial(material);
            }
            this._$2.add(mesh);
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MeshesNative.jni_GetCount(this.getHandle());
    }

    public int add(Mesh mesh) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (mesh == null) {
            String string = InternalResource.loadString("add", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (mesh.getHandle() == 0L) {
            String string = InternalResource.loadString("add", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Mesh mesh2 = new Mesh(mesh, false);
        long l = mesh2.getHandle();
        long l2 = 0L;
        Material material = mesh.getMaterial();
        Material material2 = null;
        if (material != null) {
            material2 = new Material(material, false);
            mesh2.setMaterial(material2);
            l2 = material2.getHandle();
        }
        if ((n = MeshesNative.jni_Add(this.getHandle(), l, l2)) != -1) {
            this._$2.add(mesh2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(mesh2);
        InternalHandleDisposable.makeSureNativeObjectLive(material2);
        return n;
    }

    public int addRange(Mesh[] meshArray) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addRange", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = 0;
        int n3 = meshArray.length;
        for (n = 0; n < n3; ++n) {
            Mesh mesh = meshArray[n];
            if (mesh == null) {
                String string = InternalResource.loadString("meshes[" + n + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (mesh.getHandle() != 0L) continue;
            String string = InternalResource.loadString("meshes[" + n + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < n3; ++n) {
            this.add(meshArray[n]);
            ++n2;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(meshArray);
        return n2;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MeshesNative.jni_Clear(this.getHandle());
        if (this._$2 != null) {
            this._$2.clear();
        }
    }

    public Mesh get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("get", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this._$2.get(n);
    }

    public boolean insert(int n, Mesh mesh) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.getCount()) {
            String string = InternalResource.loadString("insert", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (mesh.getHandle() == 0L) {
            String string = InternalResource.loadString("insert", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n == this.getCount()) {
            return this.add(mesh) != -1;
        }
        Mesh mesh2 = new Mesh(mesh, false);
        long l = mesh2.getHandle();
        long l2 = 0L;
        Material material = mesh.getMaterial();
        Material material2 = null;
        if (material != null) {
            material2 = new Material(material, false);
            mesh2.setMaterial(material2);
            l2 = material2.getHandle();
        }
        if ((n2 = MeshesNative.jni_Insert(this.getHandle(), n, l, l2)) == -1) {
            InternalHandleDisposable.makeSureNativeObjectLive(mesh2);
            InternalHandleDisposable.makeSureNativeObjectLive(material2);
            return false;
        }
        this._$2.add(n, mesh2);
        InternalHandleDisposable.makeSureNativeObjectLive(mesh2);
        InternalHandleDisposable.makeSureNativeObjectLive(material2);
        return true;
    }

    public int insertRange(int n, Mesh[] meshArray) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertRange", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > this.getCount()) {
            String string = InternalResource.loadString("insertRange", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = meshArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            Mesh mesh = meshArray[n2];
            if (mesh == null) {
                String string = InternalResource.loadString("meshes[" + n2 + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (mesh.getHandle() != 0L) continue;
            String string = InternalResource.loadString("meshes[" + n2 + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            bl = this.insert(n + n2, meshArray[i]);
            if (!bl) continue;
            ++n2;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(meshArray);
        return n2;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("remove", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (MeshesNative.jni_Remove(this.getHandle(), n)) {
            Mesh mesh = this.get(n);
            mesh.clearHandle();
            this._$2.remove(n);
            return true;
        }
        return false;
    }

    public int removeRange(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeRange", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("removeRange", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (n2 < 0 || n2 > this.getCount() - n) {
            String string = InternalResource.loadString("removeRange", "Meshes_RemoveRange_Count_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = 0;
        boolean bl = false;
        for (int i = n + n2 - 1; i >= n; --i) {
            try {
                bl = this.remove(i);
                if (!bl) continue;
                ++n3;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n3;
    }

    public void set(int n, Mesh mesh) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("set", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (mesh == null) {
            String string = InternalResource.loadString("set", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (mesh.getHandle() == 0L) {
            String string = InternalResource.loadString("set", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = mesh.getHandle();
        long l2 = 0L;
        Material material = mesh.getMaterial();
        if (material != null) {
            l2 = mesh.getHandle();
        }
        MeshesNative.jni_Set(this.getHandle(), n, l, l2);
        InternalHandleDisposable.makeSureNativeObjectLive(mesh);
        this._$2.set(n, mesh);
    }

    public Mesh[] toArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toArray", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this._$2.size();
        Mesh[] meshArray = new Mesh[n];
        for (int i = 0; i < n; ++i) {
            meshArray[i] = new Mesh(this.get(i));
        }
        return meshArray;
    }
}

