/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoHemiSphereNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoHemiSphere
extends Geometry3D {
    public GeoHemiSphere() {
        this.setHandle(GeoHemiSphereNative.jni_New(), true);
        this.setRadius(1.0);
        this.setPosition(new Point3D(0.0, 0.0, 0.0));
    }

    public GeoHemiSphere(GeoHemiSphere geoHemiSphere) {
        if (geoHemiSphere == null) {
            String string = InternalResource.loadString("geoHemiSphere", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoHemiSphere);
        if (l == 0L) {
            String string = InternalResource.loadString("geoHemiSphere", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoHemiSphereNative.jni_Clone(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoHemiSphere);
    }

    public GeoHemiSphere(Point3D point3D, double d) {
        this();
        this.setPosition(point3D);
        this.setRadius(d);
    }

    GeoHemiSphere(long l) {
        this.setHandle(l, false);
    }

    public double getRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRadius()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoHemiSphereNative.jni_GetRadius(this.getHandle());
    }

    public void setRadius(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRadius(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("setRadius()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoHemiSphereNative.jni_SetRadius(this.getHandle(), d);
    }

    public GeoHemiSphere clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoHemiSphere(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoHemiSphereNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

