/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetTopologyNative;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalResource;
import com.supermap.data.TopologyDatasetRelationItems;
import com.supermap.data.TopologyRule;
import com.supermap.data.TopologyValidatingItem;

public class DatasetTopology
extends Dataset {
    private TopologyDatasetRelationItems _$6;
    private DatasetVector _$5;
    private DatasetVector _$4;
    private DatasetVector _$3;

    DatasetTopology(long l, Datasource datasource) {
        this.setHandle(l);
        this.m_datasource = datasource;
    }

    public double getTolerance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetTopologyNative.jni_GetTolerance(this.getHandle());
    }

    public void setTolerance(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("tolerance", "Tolerance_NodeSnapShouldNotBeNegative", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetTopologyNative.jni_SetTolerance(this.getHandle(), d);
    }

    public DatasetVector getErrorPointDataset() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null && (l = DatasetTopologyNative.jni_GetErrorPointDataset(this.getHandle())) != 0L) {
            this._$5 = DatasetVector.createInstance(l, this.m_datasource);
        }
        return this._$5;
    }

    public DatasetVector getErrorLineDataset() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null && (l = DatasetTopologyNative.jni_GetErrorLineDataset(this.getHandle())) != 0L) {
            this._$4 = DatasetVector.createInstance(l, this.m_datasource);
        }
        return this._$4;
    }

    public DatasetVector getErrorRegionDataset() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == null && (l = DatasetTopologyNative.jni_GetErrorRegionDataset(this.getHandle())) != 0L) {
            this._$3 = DatasetVector.createInstance(l, this.m_datasource);
        }
        return this._$3;
    }

    public GeoRegion getDirtyRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = DatasetTopologyNative.jni_GetDirtyRegion(this.getHandle());
        GeoRegion geoRegion = null;
        if (l != 0L) {
            geoRegion = (GeoRegion)Geometry.createInstance(l);
        }
        return geoRegion;
    }

    public int addValidatingItem(TopologyValidatingItem topologyValidatingItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (topologyValidatingItem == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.m_datasource.equals(topologyValidatingItem.getSourceDataset().getDatasource()) || !this.getRelationItems().contain(topologyValidatingItem.getSourceDataset().getName())) {
            String string = InternalResource.loadString("item", "TopologyValidatingItem_SourceDatasetMustBeInTopologyDatasetRelationItems", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!(topologyValidatingItem.getValidatingDataset() == null || this.m_datasource.equals(topologyValidatingItem.getValidatingDataset().getDatasource()) && this.getRelationItems().contain(topologyValidatingItem.getValidatingDataset().getName()))) {
            String string = InternalResource.loadString("item", "TopologyValidatingItem_ValidatingDatasetMustBeInTopologyDatasetRelationItems", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (topologyValidatingItem.getValidatingDataset() != null) {
            l = topologyValidatingItem.getValidatingDataset().getHandle();
        }
        int n = DatasetTopologyNative.jni_AddValidatingItem(this.getHandle(), topologyValidatingItem.getSourceDataset().getHandle(), l, topologyValidatingItem.getRule().getUGCValue());
        return n;
    }

    public boolean removeValidatingItem(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getValidatingItemCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return DatasetTopologyNative.jni_RemoveValidatingItemAt(this.getHandle(), n);
    }

    public void clearValidatingItem() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetTopologyNative.jni_ClearValidatingItem(this.getHandle());
    }

    public TopologyValidatingItem getValidatingItem(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getValidatingItemCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = new String[2];
        int n2 = DatasetTopologyNative.jni_GetValidatingItem(this.getHandle(), n, stringArray);
        TopologyRule topologyRule = (TopologyRule)Enum.parse(TopologyRule.class, n2);
        TopologyValidatingItem topologyValidatingItem = new TopologyValidatingItem((DatasetVector)this.m_datasource.getDatasets().get(stringArray[0]), (DatasetVector)this.m_datasource.getDatasets().get(stringArray[1]), topologyRule);
        return topologyValidatingItem;
    }

    public void setValidatingItem(int n, TopologyValidatingItem topologyValidatingItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getValidatingItemCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (topologyValidatingItem == null) {
            String string = InternalResource.loadString("validatingItem", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.m_datasource.equals(topologyValidatingItem.getSourceDataset().getDatasource()) || !this.m_datasource.getDatasets().contains(topologyValidatingItem.getSourceDataset().getName())) {
            String string = InternalResource.loadString("validatingItem", "TopologyValidatingItem_SourceDatasetMustBeInTopologyDatasetRelationItems", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_datasource.equals(topologyValidatingItem.getValidatingDataset().getDatasource()) || !this.m_datasource.getDatasets().contains(topologyValidatingItem.getValidatingDataset().getName())) {
            String string = InternalResource.loadString("validatingItem", "TopologyValidatingItem_ValidatingDatasetMustBeInTopologyDatasetRelationItems", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = 0L;
        if (topologyValidatingItem.getValidatingDataset() != null) {
            l = topologyValidatingItem.getValidatingDataset().getHandle();
        }
        DatasetTopologyNative.jni_SetValidatingItem(this.getHandle(), n, topologyValidatingItem.getSourceDataset().getHandle(), l, topologyValidatingItem.getRule().getUGCValue());
    }

    public int getValidatingItemCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetTopologyNative.jni_GetValidatingItemCount(this.getHandle());
    }

    public TopologyDatasetRelationItems getRelationItems() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$6 == null) {
            this._$6 = new TopologyDatasetRelationItems(this);
        }
        return this._$6;
    }
}

