/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.ColorDictNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.awt.Color;

public class ColorDictionary
extends InternalHandleDisposable {
    public ColorDictionary() {
        this.setHandle(ColorDictNative.jni_New(), true);
    }

    public ColorDictionary(ColorDictionary colorDictionary) {
        if (colorDictionary == null) {
            throw new NullPointerException("ColorDict");
        }
        if (colorDictionary.getHandle() == 0L) {
            String string = InternalResource.loadString("ColorDict", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(ColorDictNative.jni_New(), true);
        int n = colorDictionary.getCount();
        double[] dArray = colorDictionary.getKeys();
        Color[] colorArray = colorDictionary.getColors();
        for (int i = 0; i < n; ++i) {
            this.setColor(dArray[i], colorArray[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(colorDictionary);
    }

    ColorDictionary(long l) {
        this.setHandle(l, false);
    }

    ColorDictionary(long l, boolean bl) {
        this.setHandle(l, bl);
    }

    public double[] getKeys() {
        int n = this.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[1];
        int[] nArray = new int[1];
        for (int i = 0; i < n; ++i) {
            ColorDictNative.jni_GetItem(this.getHandle(), i, dArray2, nArray);
            dArray[i] = dArray2[0];
        }
        return dArray;
    }

    public Color[] getColors() {
        int n = this.getCount();
        Color[] colorArray = new Color[n];
        double[] dArray = new double[1];
        int[] nArray = new int[1];
        for (int i = 0; i < n; ++i) {
            Color color;
            ColorDictNative.jni_GetItem(this.getHandle(), i, dArray, nArray);
            colorArray[i] = color = new Color(nArray[0]);
        }
        return colorArray;
    }

    public Color getColor(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColor(double key)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!ColorDictNative.jni_IsExist(this.getHandle(), d)) {
            String string = InternalResource.loadString("key", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = ColorDictNative.jni_GetColor(this.getHandle(), d);
        Color color = new Color(n);
        return color;
    }

    public void setColor(double d, Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColor(int key, Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (color == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        Color color2 = color;
        if (!ColorDictNative.jni_IsExist(this.getHandle(), d)) {
            ColorDictNative.jni_Add(this.getHandle(), d, color2.getRGB());
        }
        ColorDictNative.jni_SetColor(this.getHandle(), d, color2.getRGB());
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ColorDictNative.jni_GetCount(this.getHandle());
    }

    public void removeKey(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(double dValue)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!ColorDictNative.jni_IsExist(this.getHandle(), d)) {
            String string = InternalResource.loadString("key", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        ColorDictNative.jni_Remove(this.getHandle(), d);
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ColorDictNative.jni_Clear(this.getHandle());
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            ColorDictNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected static ColorDictionary createInstance(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new ColorDictionary(l);
    }

    protected static void clearHandle(ColorDictionary colorDictionary) {
        colorDictionary.clearHandle();
    }

    protected static void changeHandle(ColorDictionary colorDictionary, long l) {
        colorDictionary._$1(l);
    }

    private void _$1(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            ColorDictNative.jni_Delete(this.getHandle());
        }
        this.setHandle(l, false);
    }
}

