// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>The select element allows the selection of an option. The contained options can be directly accessed through the select element as a collection. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-SELECT">SELECT element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-type><CODE>&nbsp;type</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getType()'>getType</a>
</TD>
<TD>
  <P>The type of control created. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-selectedIndex><CODE>&nbsp;selectedIndex</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSelectedIndex()'>getSelectedIndex</a>
<a href='#setSelectedIndex(java.lang.String)'>setSelectedIndex</a>
</TD>
<TD>
  <P>The ordinal index of the selected option. The value -1 is returned if no element is selected. If multiple options are selected, the index of the first selected option is returned. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-value><CODE>&nbsp;value</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getValue()'>getValue</a>
<a href='#setValue(java.lang.String)'>setValue</a>
</TD>
<TD>
  <P>The current form control value. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-length><CODE>&nbsp;length</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLength()'>getLength</a>
</TD>
<TD>
  <P>The number of options in this 
    <code>SELECT</code>. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-form><CODE>&nbsp;form</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getForm()'>getForm</a>
</TD>
<TD>
  <P>Returns the 
    <code>FORM</code> element containing this control. Returns null if this control is not within the context of a form. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-options><CODE>&nbsp;options</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getOptions()'>getOptions</a>
</TD>
<TD>
  <P>The collection of 
    <code>OPTION</code> elements contained by this element. 
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-disabled><CODE>&nbsp;disabled</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDisabled()'>getDisabled</a>
<a href='#setDisabled(java.lang.String)'>setDisabled</a>
</TD>
<TD>
  <P>The control is unavailable in this context. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-disabled">disabled attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-multiple><CODE>&nbsp;multiple</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getMultiple()'>getMultiple</a>
<a href='#setMultiple(java.lang.String)'>setMultiple</a>
</TD>
<TD>
  <P>If true, multiple 
    <code>OPTION</code> elements may be selected in this 
    <code>SELECT</code>. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-multiple">multiple attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-name><CODE>&nbsp;name</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getName()'>getName</a>
<a href='#setName(java.lang.String)'>setName</a>
</TD>
<TD>
  <P>Form control or object name when submitted with a form. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-name-SELECT">name attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-size><CODE>&nbsp;size</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSize()'>getSize</a>
<a href='#setSize(java.lang.String)'>setSize</a>
</TD>
<TD>
  <P>Number of visible rows. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-size-SELECT">size attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-tabIndex><CODE>&nbsp;tabIndex</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTabIndex()'>getTabIndex</a>
<a href='#setTabIndex(java.lang.String)'>setTabIndex</a>
</TD>
<TD>
  <P>Index that represents the element's position in the tabbing order. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-tabindex">tabindex attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLSelectElement
extends HTMLElement
{
	/**
	 * Returns the value of the <code><a href=#att-type>type</a></code> property.
	*/
	String getType ();


	/** Assigns the value of the <code><a href=#att-selectedIndex>selectedIndex</a></code> property.
	 */
	void setSelectedIndex (int selectedIndex);

	/**
	 * Returns the value of the <code><a href=#att-selectedIndex>selectedIndex</a></code> property.
	*/
	int getSelectedIndex ();


	/** Assigns the value of the <code><a href=#att-value>value</a></code> property.
	 */
	void setValue (String value);

	/**
	 * Returns the value of the <code><a href=#att-value>value</a></code> property.
	*/
	String getValue ();


	/**
	 * Returns the value of the <code><a href=#att-length>length</a></code> property.
	*/
	int getLength ();


	/**
	 * Returns the value of the <code><a href=#att-form>form</a></code> property.
	*/
	HTMLFormElement getForm ();


	/**
	 * Returns the value of the <code><a href=#att-options>options</a></code> property.
	*/
	HTMLCollection getOptions ();


	/** Assigns the value of the <code><a href=#att-disabled>disabled</a></code> property.
	 */
	void setDisabled (boolean disabled);

	/**
	 * Returns the value of the <code><a href=#att-disabled>disabled</a></code> property.
	*/
	boolean getDisabled ();


	/** Assigns the value of the <code><a href=#att-multiple>multiple</a></code> property.
	 */
	void setMultiple (boolean multiple);

	/**
	 * Returns the value of the <code><a href=#att-multiple>multiple</a></code> property.
	*/
	boolean getMultiple ();


	/** Assigns the value of the <code><a href=#att-name>name</a></code> property.
	 */
	void setName (String name);

	/**
	 * Returns the value of the <code><a href=#att-name>name</a></code> property.
	*/
	String getName ();


	/** Assigns the value of the <code><a href=#att-size>size</a></code> property.
	 */
	void setSize (int size);

	/**
	 * Returns the value of the <code><a href=#att-size>size</a></code> property.
	*/
	int getSize ();


	/** Assigns the value of the <code><a href=#att-tabIndex>tabIndex</a></code> property.
	 */
	void setTabIndex (int tabIndex);

	/**
	 * Returns the value of the <code><a href=#att-tabIndex>tabIndex</a></code> property.
	*/
	int getTabIndex ();


/**

  <P>Add a new element to the collection of 
    <code>OPTION</code> elements for this 
    <code>SELECT</code>.
  
</P>

@param element
The element to add.
@param before
The element to insert before, or NULL for the head of the list.
*/
void add (HTMLElement element, HTMLElement before);

/**

  <P>Remove an element from the collection of 
    <code>OPTION</code> elements for this 
    <code>SELECT</code>. Does nothing if no element has the given index.
  
</P>

@param index
The index of the item to remove.
*/
void remove (int index);

/**

  <P>Removes keyboard focus from this element.
</P>

*/
void blur ();

/**

  <P>Gives keyboard focus to this element.
</P>

*/
void focus ();

}
