/**
 * 菜单维护js
 * 
 * @author 袁晓冬
 */
$.namespace("menu.main");
/** 菜单树 */
menu.main.$menuBtnTree = null;
/** 一览控件 */
menu.main.$grid = null;
/** 查询面板-组织名 */
menu.main.q$menuname = null;
/** 查询面板-是否有效 */
menu.main.q$valid = null;
/** 通用弹窗 */
menu.main.$popWin = null;
/** 初始化组件引用 */
menu.main.initComp = function() {
	menu.main.$menuBtnTree = $('#menuTree');
	menu.main.$grid = $('#grid');
	menu.main.$popWin = $('#popWin');
	menu.main.q$valid = $('#qvalid');
	menu.main.q$menuname = $('#qmenuname');
}
/** 页面初始化 */
menu.main.init = function() {
	menu.main.initComp();
	menu.main.initCombox();
	// 初始化树图
	menu.main.$menuBtnTree.tree({
		url : $.ctx + "/menu/tree",
		method : 'get',
		queryParams : {
			root : "true"
		},
		onClick : function(node) {
			menu.main.refreshGrid(node);
		}
	});
	// 初始化一览列表
	menu.main.$grid.datagrid({
		pageSize : 20,

		onBeforeLoad : function(param) {
			param.menuname = $.trim(menu.main.q$menuname.val());
			param.valid = menu.main.q$valid.combobox('getValue');
		}
	});
}
/**
 * 初始化下拉框
 */
menu.main.initCombox = function() {
	// 初始化人员状态下拉框
	var dataArr = new Array();
	dataArr = dataArr.concat(menu.main.sfCodeArray);
	dataArr.push({
		'code' : '',
		'text' : '全部'
	});
	menu.main.q$valid.combobox({
		valueField : 'code',
		textField : 'text',
		data : dataArr,
		editable : false
	});
};
/** 根据树图所选择的节点刷新一览列表 */
menu.main.refreshGrid = function(node) {
	if (!node) {
		node = menu.main.$menuBtnTree.tree('getSelected');
	}
	if (!node) {
		return;
	}
	// 平台根节点新增
	if (node.attributes.leaf != 'true') {
		// 刷新一览列表
		menu.main.$grid.datagrid({
			pageSize : 20,
			url : $.ctx + "/menu/list",
			queryParams : {
				pid : node.id
			},
			columns : [ [ {
				field : 'id',
				checkbox : true
			}, {
				title : "名称",
				field : 'name',
				sortable : true,
				halign : 'center'
			}, {
				title : "编码",
				field : 'code',
				sortable : true,
				halign : 'center'
			}, {
				title : "功能链接",
				field : 'url',
				sortable : true,
				halign : 'center'
			}, {
				title : "显示样式",
				field : 'icon',
				sortable : true,
				halign : 'center'
			}, {
				title : "显示样式2",
				field : 'icon2',
				sortable : true,
				halign : 'center'
			}, {
				title : "排序号",
				field : 'sortno',
				sortable : true,
				halign : 'center'
			}, {
				title : "是否末级",
				field : 'leaf',
				align : 'center',
				halign : 'center',
				formatter : sfFormatter
			}, {
				title : "是否有效",
				field : 'valid',
				align : 'center',
				halign : 'center',
				formatter : sfFormatter
			} ] ]
		});
	} else {
		// 刷新一览列表
		menu.main.$grid.datagrid({
			pageSize : 20,
			url : $.ctx + "/menu/listBtn",
			queryParams : {
				mid : node.id
			},
			columns : [ [ {
				field : 'id',
				checkbox : true
			}, {
				title : "名称",
				field : 'name',
				sortable : true,
				halign : 'center'
			}, {
				title : "编码",
				field : 'code',
				sortable : true,
				halign : 'center'
			}, {
				title : "显示样式",
				field : 'icon',
				sortable : true,
				halign : 'center'
			}, {
				title : "显示样式2",
				field : 'icon2',
				sortable : true,
				halign : 'center'
			}, {
				title : "排序号",
				field : 'sortno',
				sortable : true,
				halign : 'center'
			}, {
				title : "是否末级",
				field : 'leaf',
				align : 'center',
				halign : 'center',
				formatter : sfFormatter
			}, {
				title : "是否有效",
				field : 'valid',
				align : 'center',
				halign : 'center',
				formatter : sfFormatter
			} ] ]
		});
	}

}
/**
 * 记录新增处理
 */
menu.main.doAdd = function() {
	var selectedNode = menu.main.$menuBtnTree.tree('getSelected');
	if (!selectedNode) {
		$.messager.alert("提示", "请选择上级菜单！");
		return;
	}
	// 平台根节点新增
	if (selectedNode.attributes.leaf != 'true') {
		menu.main.addMenu(selectedNode.id);
	} else {
		menu.main.addButton(selectedNode.id);
	}
}
/**
 * 记录编辑处理
 */
menu.main.doEdit = function() {
	var rows = menu.main.$grid.datagrid("getSelections");
	if (rows.length > 0) {
		if (rows.length == 1) {
			var node = menu.main.$menuBtnTree.tree('getSelected');
			if (node && node.attributes.leaf == 'true') {
				menu.main.$popWin.dialog({
					href : $.ctx + "/menu/editBtn",
					title : "编辑",
					queryParams : {
						id : rows[0].id
					},
					onClose : menu.main.refreshGrid
				}).dialog('open');
			} else {
				menu.main.$popWin.dialog({
					href : $.ctx + "/menu/edit",
					title : "编辑",
					queryParams : {
						id : rows[0].id
					},
					onClose : menu.main.refreshGrid
				}).dialog('open');
			}
		} else {
			$.messager.alert("提示", "只能选择一条记录！");
		}
	} else {
		$.messager.alert("提示", "请选择要修改的记录！");
	}
}

/** 删除处理 */
menu.main.doDel = function() {
	var rows = menu.main.$grid.datagrid("getSelections");
	if (rows.length > 0) {
		$.messager.confirm("确认", "确定要删除吗？", function(msg) {
			if (msg) {
				// 确认删除
				var ids = [];
				$.each(rows, function(i) {
					ids.push(rows[i].id);
				});
				$.post($.ctx + "/menu/delete", {
					ids : ids.join(",")
				}, function(data, status) {
					if (data.success) {
						// close the dialog
						menu.main.$popWin.dialog('close');
						var selectedNode = menu.main.$menuBtnTree
								.tree('getSelected');
						menu.main.$menuBtnTree.tree('reload',
								selectedNode.target);
						menu.main.refreshGrid(selectedNode);
					} else {
						$.messager.showError(data.message);
					}
				}, "json");
			}
		});
	} else {
		$.messager.alert("提示", "请选择要删除的记录！");
	}
}
/**
 * 新增菜单
 */
menu.main.addMenu = function(pid) {
	menu.main.$popWin.dialog({
		href : $.ctx + '/menu/add?pid=' + pid,
		title : "菜单新增"
	}).dialog('open');
}
menu.main.addButton = function(mid) {
	menu.main.$popWin.dialog({
		href : $.ctx + '/menu/addBtn?mid=' + mid,
		title : "功能新增"
	}).dialog('open');
}
//刷新树图
menu.main.treeReload = function() {
    var selectedNode = menu.main.$menuBtnTree.tree('getSelected');
    if(!selectedNode){
    	menu.main.$menuBtnTree.tree('reload');	    	
    }else{
    	menu.main.$menuBtnTree.tree('reload', selectedNode.target);	
    }
}
