/**
 * 字典维护js
 * 
 * @author 袁晓冬
 */
$.namespace("code.main");
/** 一览控件 */
code.main.$grid = null;
/** 通用弹窗 */
code.main.$popWin = null;
code.main.$permWin = null;
code.main.$userWin = null;
/** 公用代码【是否】 */
code.main.sfCodeArray = null;
/** 组织树 */
code.main.$orgTree = null;
/** 初始化组件引用 */
code.main.initComp = function() {
    code.main.$grid = $('#grid');
    code.main.$popWin = $('#popWin');
    code.main.$permWin = $('#permWin');
    code.main.$userWin = $('#userWin');
}
/** 页面初始化 */
code.main.init = function() {
    code.main.initComp();
    var init = false;
    // 初始化一览列表
    // code.main.refreshGrid();
    code.main.initpage()
}
/** 根据树图所选择的节点刷新一览列表 */
code.main.refreshGrid = function() {
    // 刷新一览列表
    code.main.$grid.datagrid({
        pageSize : 20,
        url : $.ctx + "/code/list"
    });
}

/** 页面初始化 */
code.main.initpage = function() {
    $("#pagetools").hide();
    // 把form传入，构造翻页控件
    pageinfo($("#codeform"));// 见common.js
}

code.main.query = function(){
    $("#codeform").submit();
}

//新增字典
code.main.doAdd = function(pid) {
    $dialog = code.main.$popWin.dialog({
        href : $.ctx + '/code/add?pid='+pid,
        title : "新增字典",
        width : 400,
        height : 280,
        onClose : function() {
            $dialog.dialog('destroy');
        },
        buttons : [ {
            text : '完成',
            iconCls : 'icon-xt-ok',
            handler : function() {
            	$('#rform').form('submit', {
                    url : $.ctx + '/code/save',
                    onSubmit : function() {
                    	if(isEmpty($("#text").val())){
                    		$.messager.alert("提示", "请填写名称！");
          	        	  	$("#text").focus();
          	        	  	return false;
          	          	}else if(isEmpty($("#code").val())){
                    		$.messager.alert("提示", "请填写编码！");
          	        	  	$("#code").focus();
          	        	  	return false;
          	          	}else if(isEmpty($("#sortno").val())){
                    		$.messager.alert("提示", "请填写编号！");
          	        	  	$("#sortno").focus();
          	        	  	return false;
          	          	}else if(!isEmpty($("#sortno").val())&&isNaN(parseInt($("#sortno").val()))){
                    		$.messager.alert("提示", "编号只能为数字！");
          	        	  	$("#sortno").focus();
          	        	  	return false;
          	          	}
                    },
                    success : function(data,status) {
                        if (data) {
                            data = $.parseJSON(data);
                        }
                        if (data.success){
                        	$.messager.alert("提示", "新增字典成功！");
                        	$dialog.dialog('close');
                        	if("00"==pid&&!isEmpty(pid)){
                        		window.location = $.ctx + '/code/main';
                        	}else if(!isEmpty(pid)){
                        		window.location = $.ctx + '/code/view?id=' + pid;
                        	}
                            
                        }else {
                            $.messager.showError(data.message);
                            $dialog.dialog('close');
                        }
                    }
                });
                
            }
        }, {
            text : '取消',
            iconCls : 'icon-cancel',
            handler : function() {
                $dialog.dialog('close');
            }
        } ]
    });
    $dialog.dialog('open');
}

/**
 * 保存菜单
 */
code.main.save = function() {
	var pid = $('#pid').val();
    $('#rform').form('submit', {
        url : $.ctx + '/code/save',
        onSubmit : function() {
            return $(this).form('validate');
        },
        success : function(data,status) {
            if (data) {
                data = $.parseJSON(data);
            }
            if (data.success){
            	if("00"==pid&&!isEmpty(pid)){
            		window.location = $.ctx + '/code/main';
            	}else if(!isEmpty(pid)){
            		window.location = $.ctx + '/code/view?id=' + pid;
            	}
            }else {
                $.messager.showError(data.message);
            }
        }
    });
}

code.main.view = function(id) {
    window.location = $.ctx + '/code/view?id=' + id;
}

/**
 * 全选/全不选
 */
code.main.all = function() {
    if ($("#all").prop("checked")) {
        $(".fwgl_table_checkbox").each(function() {
            $(this).prop("checked", true);
        });
    }
    else {
        $(".fwgl_table_checkbox").each(function() {
            $(this).prop("checked", false);
        });
    }
}

/**
 * 获取选中的数据 返回选中数据的id数组
 */
code.main.getSelectedRecords = function() {
    var ids = new Array();
    $(".fwgl_table_checkbox").each(function() {
        if ($(this).prop("checked")) {
            ids.push($(this).val());
        }
    });
    return ids;
}

/**
 * 记录编辑处理
 */
code.main.doEdit = function() {
    var rows = code.main.getSelectedRecords();
    if (rows.length > 0) {
        if (rows.length == 1) {
            $dialog = code.main.$popWin.dialog({
                href : $.ctx + "/code/edit",
                title : "编辑字典",
                queryParams : {
                    id : rows[0]
                },
                width : 400,
                height : 280,
                onClose : function() {
                    $dialog.dialog('destroy');
                },
                buttons : [ {
                    text : '完成',
                    iconCls : 'icon-xt-ok',
                    handler : function() {
                    	var pid = $('#pid').val();
                    	$('#rform').form('submit', {
                            url : $.ctx + '/code/save',
                            onSubmit : function() {
                            	if(isEmpty($("#text").val())){
                            		$.messager.alert("提示", "请填写名称！");
                  	        	  	$("#text").focus();
                  	        	  	return false;
                  	          	}else if(isEmpty($("#code").val())){
                            		$.messager.alert("提示", "请填写编码！");
                  	        	  	$("#code").focus();
                  	        	  	return false;
                  	          	}else if(isEmpty($("#sortno").val())){
                            		$.messager.alert("提示", "请填写编号！");
                  	        	  	$("#sortno").focus();
                  	        	  	return false;
                  	          	}else if(!isEmpty($("#sortno").val())&&isNaN(parseInt($("#sortno").val()))){
                            		$.messager.alert("提示", "编号只能为数字！");
                  	        	  	$("#sortno").focus();
                  	        	  	return false;
                  	          	}
                            },
                            success : function(data,status) {
                                if (data) {
                                    data = $.parseJSON(data);
                                }
                                if (data.success){
                                	$.messager.alert("提示", "修改字典成功！");
                                	$dialog.dialog('close');
                                	if("00"==pid&&!isEmpty(pid)){
                                		window.location = $.ctx + '/code/main';
                                	}else if(!isEmpty(pid)){
                                		window.location = $.ctx + '/code/view?id=' + pid;
                                	}
                                }else {
                                    $.messager.showError(data.message);
                                    $dialog.dialog('close');
                                }
                            }
                        });
                    }
                }, {
                    text : '取消',
                    iconCls : 'icon-cancel',
                    handler : function() {
                        $dialog.dialog('close');
                    }
                } ]
            });
            $dialog.dialog('open');
        }
        else {
            $.messager.alert("提示", "只能选择一条记录！");
        }
    }
    else {
        $.messager.alert("提示", "请选择要修改的记录！");
    }

}
/** 删除处理 */
code.main.doDel = function(pid) {
    var rows = code.main.getSelectedRecords();
    if (rows.length > 0) {
        $.messager.confirm("确认", "确定要删除吗？", function(msg) {
            if (msg) {
                // 确认删除
                $.post($.ctx + "/code/delete", {
                    ids : rows.join(",")
                }, function(data, status) {
                    if (data.success) {
                        // close the dialog
                        code.main.$popWin.dialog('close');
                        if("00"==pid&&!isEmpty(pid)){
                    		window.location = $.ctx + '/code/main';
                    	}else if(!isEmpty(pid)){
                    		window.location = $.ctx + '/code/view?id=' + pid;
                    	}
                    }
                    else {
                        $.messager.showError(data.message);
                    }
                }, "json");
            }
            ;
        });
    }
    else {
        $.messager.alert("提示", "请选择要删除的记录！");
    }
}
// 刷新树图
code.main.treeReload = function() {
    var selectedNode = code.main.$orgTree.tree('getSelected');
    if (!selectedNode) {
        code.main.$orgTree.tree('reload');
    }
    else {
        code.main.$orgTree.tree('reload', selectedNode.target);
    }
}
code.main.setQx = function(val, row) {
    /*
     * var ret = '<a href="#" onclick="code.main.setPermission(\''+val+'\')" >设置</a> '; return ret;
     */
}
code.main.setPermission = function(roleId) {
    // window.location= $.ctx + "/role/menuAuthTree" + "?roleid=" + roleId;
    window.location = $.ctx + "/role/auth/" + roleId;
}

/**
 * 判断是否为空
 * @param str
 * @returns {Boolean}
 */
function isEmpty(str){
    if(str!=null&&str!=""&&str.length!=0){
        return false;
    }else{
        return true;
    }
}

code.main.back = function() {
    window.location = $.ctx + "/code/main";
}