/**
 * 活动结点授权js
 */
$.namespace("aman.detail");

/** 通用弹窗 */
aman.detail.$popWin = null;
aman.detail.$userWin = null;

/** 初始化组件引用 */
aman.detail.initComp = function() {
	aman.detail.$popWin = $('#popWin');
	aman.detail.$userWin = $('#userWin');
}
/** 页面初始化 */
aman.detail.init = function() {
	aman.detail.initComp();
}
// 选择组织
aman.detail.chooseOrg=function(config){
    config = config || {};
    var orgs="";
    $("input[name='orgs']").each(function(){
        orgs=orgs+$(this).val()+",";
    });
    if(orgs.length>0){
        orgs= orgs.substring(0,orgs.length-1)
    }
    $dialog = aman.detail.$popWin.dialog({
       href : $.ctx + "/workflow/orgTree?orgs="+orgs,
       title : "选择组织",
       width : 300,
       height : 250,
       onClose : function() {
           $dialog.dialog('destroy');
       },
       buttons : [ {
           text : '完成',
           iconCls : 'icon-xt-ok',
           handler : function() {
               $("#orgdiv").empty("");
               var nodes = $('#tt').tree('getChecked');
               var u="",n="";
               for ( var i = 0; i < nodes.length; i++) {  
                       var str = "";
                       str = "<span id='"+nodes[i].id+"'>" 
                             + "<input value='"+nodes[i].id+"' name='orgs' type='hidden'>" 
                             + nodes[i].text;
                            
                       $("#orgdiv").append(str + "<a onclick='aman.detail.chooseOrg.del(\""+ nodes[i].id +"\")'><img src='/gkoa/static/xt/images/swgl_icon_8.png'></a></span>&nbsp;&nbsp;");
               }  
               if (config.callback && typeof config.callback == 'function') {
                   config.callback(true,rows);
               }
               $dialog.dialog('close');
           }
       }, {
           text : '取消',
           iconCls : 'icon-cancel',
           handler : function() {
               if (config.callback && typeof config.callback == 'function') {
                   config.callback(false);
               }
               $dialog.dialog('close');
           }
       } ]
   });
   $dialog.dialog('open');
}

aman.detail.chooseOrg.del=function(id){
    $("#"+id+"").remove();
}

// 选择人员
aman.detail.chooseUser=function(config){
    config = config || {};
    var users="";
    $("input[name='users']").each(function(){
        users=users+$(this).val()+",";
    });
    if(users.length>0){
        users= users.substring(0,users.length-1)
    }
    $dialog = aman.detail.$popWin.dialog({
       href : $.ctx + "/workflow/userTree?users="+users,
       title : "选择人员",
       width : 300,
       height : 260,
       onClose : function() {
           $dialog.dialog('destroy');
       },
       buttons : [ {
           text : '完成',
           iconCls : 'icon-xt-ok',
           handler : function() {
               $("#usediv").empty("");
               var nodes = $('#tt').tree('getChecked');
               var u="",n="";
               for ( var i = 0; i < nodes.length; i++) {  
                   if(nodes[i].children == null){
                       var str = "";
                       str = "<span id='"+nodes[i].id+"'>" 
                             + "<input value='"+nodes[i].id+"' name='users' type='hidden'>" 
                             + nodes[i].text;
                            
                       $("#usediv").append(str + "<a onclick='aman.detail.chooseUser.del(\""+ nodes[i].id +"\")'><img src='/gkoa/static/xt/images/swgl_icon_8.png'></a></spansp;&nbsp;");
                   }
               }  
           if (config.callback && typeof config.callback == 'function') {
               config.callback(true,rows);
           }
           $dialog.dialog('close');
           }
       }, {
           text : '取消',
           iconCls : 'icon-cancel',
           handler : function() {
               if (config.callback && typeof config.callback == 'function') {
                   config.callback(false);
               }
               $dialog.dialog('close');
           }
       } ]
   });
   $dialog.dialog('open');
}

aman.detail.chooseUser.del=function(id){
    $("#"+id+"").remove();
}


// 选择角色
aman.detail.chooseRole=function(config){
    config = config || {};
    var roles="";
    $("input[name='roles']").each(function(){
        roles=roles+$(this).val()+",";
    });
    if(roles.length>0){
        roles= roles.substring(0,roles.length-1)
    }
    $dialog = aman.detail.$popWin.dialog({
       href : $.ctx + "/workflow/roleTree?roles="+roles,
       title : "选择角色",
       width : 300,
       height : 260,
       onClose : function() {
           $dialog.dialog('destroy');
       },
       buttons : [ {
           text : '完成',
           iconCls : 'icon-xt-ok',
           handler : function() {
               $("#rolediv").empty("");
               var nodes = $('#tt').tree('getChecked');
               var u="",n="";
               for ( var i = 0; i < nodes.length; i++) {  
                       var str = "";
                       str = "<span id='"+nodes[i].id+"'>" 
                             + "<input  value='"+nodes[i].id+"' name='roles' type='hidden'>" 
                             + nodes[i].text;
                            
                       $("#rolediv").append(str + "<a onclick='aman.detail.chooseOrg.del(\""+ nodes[i].id +"\")'><img src='/gkoa/static/xt/images/swgl_icon_8.png'></a></span>&nbsp;&nbsp;");
               }  
               if (config.callback && typeof config.callback == 'function') {
                   config.callback(true,rows);
               }
               $dialog.dialog('close');
           }
       }, {
           text : '取消',
           iconCls : 'icon-cancel',
           handler : function() {
               if (config.callback && typeof config.callback == 'function') {
                   config.callback(false);
               }
               $dialog.dialog('close');
           }
       } ]
   });
   $dialog.dialog('open');
}

aman.detail.chooseRole.del=function(id){
    $("#"+id+"").remove();
}

// 选择guizhi
aman.detail.chooseGz=function(config){
    config = config || {};
    $dialog = aman.detail.$popWin.dialog({
       href : $.ctx + '/workflow/chooseGz?gzflag='+$('#blgz').val(),
       title : "选择规则",
       width : 300,
       height : 100,
       onClose : function() {
           $dialog.dialog('destroy');
       },
       buttons : [ {
           text : '完成',
           iconCls : 'icon-xt-ok',
           handler : function() {
               $("#gzdiv").empty("");
               var value  = $('input[name=gzflag]:checked').val();
               $("#blgz").val(value);
               if(value == 1){
                   value="单人"
               }else{
                   value ="全部"
               }
               $("#gzdiv").append(value);
               if (config.callback && typeof config.callback == 'function') {
                   config.callback(true,rows);
               }
               $dialog.dialog('close');
           }
       }, {
           text : '取消',
           iconCls : 'icon-cancel',
           handler : function() {
               if (config.callback && typeof config.callback == 'function') {
                   config.callback(false);
               }
               $dialog.dialog('close');
           }
       } ]
   });
   $dialog.dialog('open');
}

aman.detail.editNext = function(key){
    var  config = config || {};
    var  stepids = $('#stepids').val();
    
     $dialog = aman.detail.$popWin.dialog({
        href : $.ctx + "/workflow/checkNextNode?wfid="+key+"&stepids="+stepids+"&mrflag="+$('#ynextid').val(),
        title : "设置下一环节",
        width : 360,
        height : 320,
        onClose : function() {
            $dialog.dialog('destroy');
        },
        buttons : [ {
            text : '完成',
            iconCls : 'icon-xt-ok',
            handler : function() {
               /* var value  = $('input[name=flag]:checked').val();
                if(isEmpty(value)){
                    $.messager.alert("提示", "请选择默认的环节！");
                    return false;
                }*/
                aman.detail.savestep();
            if (config.callback && typeof config.callback == 'function') {
                config.callback(true,rows);
            }
            $dialog.dialog('close');
            }
        }, {
            text : '取消',
            iconCls : 'icon-cancel',
            handler : function() {
                if (config.callback && typeof config.callback == 'function') {
                    config.callback(false);
                }
                $dialog.dialog('close');
            }
        } ]
    });
    $dialog.dialog('open');
 }

aman.detail.all =  function(){
    if ($("#all").prop("checked")) {
        $(".fwgl_table_checkbox").each(function() {
            $(this).prop("checked", true);
        });
    }
    else {
        $(".fwgl_table_checkbox").each(function() {
            $(this).prop("checked", false);
        });
    }
}

 /**
     * 获取选中的数据 返回选中数据的id数组
     */
aman.detail.getSelectedRecords = function() {
     var ids = new Array();
     $(".fwgl_table_checkbox").each(function() {
         if ($(this).prop("checked")) {
             ids.push($(this).val());
         }
     });
     return ids;
 }

/**
 * 判断是否为空
 * 
 * @param str
 * @returns {Boolean}
 */
function isEmpty(str){
    if(str!=null&&str!=""&&str.length!=0){
        return false;
    }else{
        return true;
    }
}


aman.detail.check=function(id){
   $('input[name='+id+']').prop("checked", true);
}

aman.detail.checkbox=function(id){
    if(!$('input[name='+id+']').prop("checked")){
        $('input[name=flag]').each(function(){
            if($(this).prop("checked")){
                if($(this).val()==id){
                    $(this).prop("checked",false);
                }
            }
        });
    }
}

 // 保存
aman.detail.savestep = function(){
     var ids =aman.detail.getSelectedRecords();
     if (ids.length > 0) {
         var value  = $('input[name=flag]:checked').val();
         var steps = new Array();
         var nextnames = "";
         var nextids="";
         $('#stepdiv').empty("");
         $('#mrdiv').empty("");
         for(var i = 0 ;i<ids.length;i++){
             var a = ids[i].split(",");
             if (a[0] == value){
                 $('#mrdiv').append(a[1]);
                 $('#ynextid').val(a[0]);
                 steps.push(a+","+"Y")
             }else{
                 steps.push(a+","+"N")
             }
             nextnames=nextnames+a[1]+","
             nextids=nextids+a[0]+","
         }
         if(nextnames.length>0){
             nextnames= nextnames.substring(0,nextnames.length-1);
             nextids= nextids.substring(0,nextids.length-1)
             $("#stepdiv").append(nextnames);
             $('#stepids').val(nextids);
         }
       $('#steps').val(JSON.stringify(steps));
     }
     else {
         $('#stepdiv').empty("");
         $('#steps').val("");
     }
     
 }

// 返回
aman.detail.back=function(){
    window.location=$.ctx + "/wf/wfConfig/list?processKey="+$('#processKey').val()+"&taskKey="+$('#taskKey').val()+"&processKeyName="+encodeURI(encodeURI($('#processName').val()));
}

var isCommitted = false;//表单是否已经提交标识，默认为false

// 保存
aman.detail.save=function(){
    if(isCommitted==false){
        isCommitted = true;//提交表单后，将表单是否已经提交标识设置为true
        var steps = $('#steps').val();
        if(!isEmpty(steps)){
            if(steps.indexOf(";") > 0){
                var ss = steps.split(";");
                $('#steps').val(JSON.stringify(ss));
            }else{
                
                if(steps.indexOf("[")<0){
                    var stepss = new Array();
                    stepss.push(steps);
                    $('#steps').val(JSON.stringify(stepss));
                }
            }
        }
        $('#wfform').form('submit', {
            url : $.ctx + "/wf/wfConfig/save",
            onSubmit : function() {
            },
            success : function(data, status) {
                if (data) {
                    data = $.parseJSON(data);
                    window.location =  $.ctx + "/wf/wfConfig/list?processKey="+$('#processKey').val()+"&processKeyName="+encodeURI(encodeURI($('#processName').val()));
                }
                else {
                    $.messager.showError(data.message);
                }
            }
        });
        return true;//返回true让表单正常提交
    }else{
        setTimeout(function() { isCommitted = false; }, 5000);
        return false;//返回false那么表单将不提交
   }
}