<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>  
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>待办一览</title>
<%@ include file="../../include/common.jsp"%>
<script type="text/javascript" src="${ctx}/static/xt/js/grsw/dbyl/main.js"></script>
<script type="text/javascript" src="${ctx}/static/xt/js/sys/main.js"></script>
<script type="text/javascript">
    // 页面加载完成后执行
    $(document).ready(function() {
        grsw.dbyl.main.init();
        
        $('#key').combobox({    
        	url:'${ctx}/db/dblx',
	        valueField:'code',    
	        textField:'text',
	        panelHeight:'200'
	    });
    });
    
    function view(processid,processname){
        if("分发"==processname){
    	    parent.sys.main.addmaintab('已收发文', $.ctx+'/ysfw/main', true);
    	}else{
    	    $.post($.ctx + "/wf/task/isExit", {
                id:processid
            }, function(data, status) {
                if (data.success) {
        		    //待办
                	if("发文"==processname){
                		parent.sys.main.addmaintab('待办发文', $.ctx+"/dbfw/view?id="+processid, true);
                	}else if("收文"==processname){
           			    //待办
           			    parent.sys.main.addmaintab('待办收文', $.ctx + '/dbsw/view?flag=0&rflag=0&id='+processid+'&cltype='+data.attrs.cltype, true);
                	}else if("政务"==processname){
                		parent.sys.main.addmaintab('待办政务', $.ctx + '/dbzw/view?flag=0&rflag=0&id='+processid, true);
                	}else if("公告管理"==processname){
                		parent.sys.main.addmaintab('待办公告', $.ctx + '/dbgg/view?flag=0&rflag=0&id='+processid+'&backurl='+$.ctx+'/dbgg/main', true);
                	}else if("签报"==processname){
                		parent.sys.main.addmaintab('待办签报', $.ctx + '/dbqb/view?flag=0&rflag=0&id='+processid, true);
                	}else if("干部选拔"==processname){
                		parent.sys.main.addmaintab('干部选拔任用', $.ctx + '/gbxb/view?flag=0&rflag=0&id='+processid, true);
                	}else if("因公出国"==processname){
                		parent.sys.main.addmaintab('因公出国（境）', $.ctx + '/ygcg/view?flag=0&rflag=0&id='+processid, true);
                	}else if("年度预算"==processname){
                		parent.sys.main.addmaintab('年度预算', $.ctx + '/ndys/edit?method=workflow&id='+processid, true);
                	}else if("预算执行"==processname){
                		parent.sys.main.addmaintab('预算执行', $.ctx+'/yszx/view?flag=0&rflag=0&id='+processid, true);
                	}else if("资产申购"==processname){
                		parent.sys.main.addmaintab('资产申购', $.ctx+'/zcsg/edit?method=workflow&id=' + processid, true);
                	}else if("港口项目管理"==processname){
                		parent.sys.main.addmaintab('港口课题管理', $.ctx + '/gkxmgl/view?flag=0&rflag=0&id='+processid, true);
                	}else if("信访件办理"==processname){
                		parent.sys.main.addmaintab('待办信访件', $.ctx + '/dbxfj/edit?method=workflow'+'&id='+processid, true);
                	}else if("建议提案"==processname || "建设提案" == processname){
                		parent.sys.main.addmaintab('待办建议提案', $.ctx+'/dbjsta/view?id='+processid, true);
                	}else if("公务出差"==processname){
                		parent.sys.main.addmaintab('公务出差审批', $.ctx+'/gwcc/view?flag=0&rflag=0&id='+processid, true);
                	}else{
                		$.messager.alert("提示", "待办类型有误！", "info", function () {
                            window.location=$.ctx+"/dbyl/main";
                        });
                	}
                }else{
                	$.messager.alert("提示", data.message, "info", function () {
                        window.location=$.ctx+"/dbyl/main";
                    });
                }
            }, "json");
        	
    	}
    }

</script>
</head>
<body>
<form action="${ctx}/db/main" method="post" id="dbylform">
	<div class="work_box">
		<h1 class="work_title"><span >${menuPath }</span></h1>
		<table class="btn_left_1">
			<tr>
	        	<td style="width: 17%;text-align: right;height: 40px;"><span style="margin-right: 10px;font-size:15px;color: #3e3e3e;">待办类型</span>
	            	<input name="key" id="key" class="easyui-combobox" value="${key }"
	            		style="width:66.5%;height:30px;border-radius:5px;border:1px #888888 solid;font-size:15px;line-height:30px;padding-left:1%;"/>
	            </td>
	            <td class="input_data"></td>
	                       
	            <td class="input_data_1">
	                  <button type="button" class="fwgl_sy_cx_btn" onclick="grsw.dbyl.main.search()"><span>查询</span></button>
	            </td>
            </tr>
         </table>
            	
         <table class="fwgl_table" id="list">
			<tr align="center" style="font-weight: bolder; font-size:15px;" class="fwgl_table_title">
				<td width="160px">实例名称</td>
				<td width="263px">发送人</td>
				<td width="263px">发送时间</td>
				<td width="104px">当前环节</td>
				<td width="104px">操作</td>
			</tr>
			<c:forEach items="${list}" var="db" varStatus="status">
				<tr align="center">
					<td>${db.processName}</td>
					<td>${db.senderName}</td>
					<td><fmt:formatDate value="${db.senderTime }" pattern="yyyy-MM-dd HH:mm:ss" /> </td>
					<td>${db.stepName}</td>
					<td><span class="main_title" onclick="view('${db.bizKey}','${db.processName }')">办理</span></td>
				</tr>
			</c:forEach>

			<%-- <tr>
				<td colspan="5" class="last_page_td"
					style="height: 28px; line-height: 31px;">
					<jsp:include page="../../include/pageinfo.jsp"></jsp:include>
				</td>
			</tr> --%>
		</table>
	</div>
</form>
</body>
</html>
