/*
 * Decompiled with CFR 0.152.
 */
package com.xtframe.sec.role.service.impl;

import com.xtframe.core.org.entity.Org;
import com.xtframe.core.role.entity.Role;
import com.xtframe.core.role.service.RoleService;
import com.xtframe.core.utils.Assert;
import com.xtframe.sec.common.BaseSecurityService;
import com.xtframe.sec.org.dao.OrgDao;
import com.xtframe.sec.org.entity.OrgEntity;
import com.xtframe.sec.role.dao.RoleDao;
import com.xtframe.sec.role.entity.RoleEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.transaction.Transactional;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public class RoleServiceImpl
extends BaseSecurityService
implements RoleService {
    private RoleDao dao;
    private OrgDao orgDao;

    @Transactional
    public void delete(String ... ids) {
        this.dao.delete((Serializable[])ids);
    }

    public List<Role> findAll() {
        System.out.println("1::::");
        List roleEntities = this.dao.findAll(new Sort(new String[]{"sortno"}));
        System.out.println("2::::");
        ArrayList<Role> roles = new ArrayList<Role>(roleEntities.size());
        for (Role r : roleEntities) {
            if (!r.getValid().booleanValue()) continue;
            roles.add(r);
        }
        return roles;
    }

    public List<Role> findByCode(String code) {
        return this.dao.findByCode(code);
    }

    public List<Role> findByCodeAndOrgCodeIn(final String code, final Collection<String> orgCodes) {
        if (orgCodes == null || orgCodes.size() == 0) {
            return new ArrayList<Role>(0);
        }
        Specification<RoleEntity> spec = new Specification<RoleEntity>(){

            public Predicate toPredicate(Root<RoleEntity> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> list = new ArrayList<Predicate>();
                list.add(cb.equal(root.get("code").as(String.class), (Object)code));
                list.add(cb.equal(root.get("valid").as(Boolean.class), (Object)true));
                Subquery subquery = query.subquery(OrgEntity.class);
                Root orgRoot = subquery.from(OrgEntity.class);
                subquery.select((Expression)orgRoot);
                ArrayList<Object> subQueryPredicates = new ArrayList<Object>();
                subQueryPredicates.add(cb.equal(root.get("orgid").as(String.class), orgRoot.get("id").as(String.class)));
                subQueryPredicates.add(cb.equal(orgRoot.get("valid").as(Boolean.class), (Object)true));
                CriteriaBuilder.In codeIn = cb.in(orgRoot.get("code").as(String.class));
                for (String oc : orgCodes) {
                    codeIn.value((Object)oc);
                }
                subQueryPredicates.add(codeIn);
                subquery.where(subQueryPredicates.toArray(new Predicate[0]));
                list.add(cb.exists(subquery));
                return cb.and(list.toArray(new Predicate[0]));
            }
        };
        List roleEntities = this.dao.findAll((Specification)spec);
        ArrayList<Role> roles = new ArrayList<Role>();
        for (RoleEntity r : roleEntities) {
            roles.add(r);
        }
        return roles;
    }

    public List<Role> findByCodeAndOrgIdIn(String code, Collection<String> orgIds) {
        return this.dao.findByCodeAndOrgidIn(code, orgIds);
    }

    public List<Role> findByCodeAndPOrgCode(String code, final String orgCode) {
        Specification<RoleEntity> spec = new Specification<RoleEntity>(){

            public Predicate toPredicate(Root<RoleEntity> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> list = new ArrayList<Predicate>();
                Subquery subquery = query.subquery(OrgEntity.class);
                Root orgRoot = subquery.from(OrgEntity.class);
                subquery.select((Expression)orgRoot);
                ArrayList<Predicate> subQueryPredicates = new ArrayList<Predicate>();
                subQueryPredicates.add(cb.equal(root.get("orgid").as(String.class), orgRoot.get("id").as(String.class)));
                subQueryPredicates.add(cb.equal(orgRoot.get("valid").as(Boolean.class), (Object)true));
                subQueryPredicates.add(cb.like(orgRoot.get("code").as(String.class), String.valueOf(orgCode) + "_%"));
                subquery.where(subQueryPredicates.toArray(new Predicate[0]));
                list.add(cb.exists(subquery));
                return cb.and(list.toArray(new Predicate[0]));
            }
        };
        List roleEntities = this.dao.findAll((Specification)spec);
        ArrayList<Role> roles = new ArrayList<Role>();
        for (RoleEntity r : roleEntities) {
            roles.add(r);
        }
        return roles;
    }

    public List<Role> findByCodeAndSubOrgCode(String code, String orgCode) {
        List orgs = this.securityMgr.orgService().findBySubCode(orgCode);
        ArrayList<String> codes = new ArrayList<String>();
        for (Org o : orgs) {
            codes.add(o.getCode());
        }
        return this.findByCodeAndOrgCodeIn(code, codes);
    }

    public Role findById(String id) {
        return this.dao.findById(id);
    }

    public List<Role> findByOrgCode(final String orgCode) {
        Specification<RoleEntity> spec = new Specification<RoleEntity>(){

            public Predicate toPredicate(Root<RoleEntity> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> list = new ArrayList<Predicate>();
                Subquery subquery = query.subquery(OrgEntity.class);
                Root orgRoot = subquery.from(OrgEntity.class);
                subquery.select((Expression)orgRoot);
                ArrayList<Predicate> subQueryPredicates = new ArrayList<Predicate>();
                subQueryPredicates.add(cb.equal(root.get("orgid").as(String.class), orgRoot.get("id").as(String.class)));
                subQueryPredicates.add(cb.equal(orgRoot.get("valid").as(Boolean.class), (Object)true));
                subQueryPredicates.add(cb.equal(orgRoot.get("code").as(String.class), (Object)orgCode));
                subquery.where(subQueryPredicates.toArray(new Predicate[0]));
                list.add(cb.exists(subquery));
                return cb.and(list.toArray(new Predicate[0]));
            }
        };
        List roleEntities = this.dao.findAll((Specification)spec);
        ArrayList<Role> roles = new ArrayList<Role>();
        for (RoleEntity r : roleEntities) {
            roles.add(r);
        }
        return roles;
    }

    public List<Role> findByOrgid(String orgid) {
        return this.dao.findValidByOrgid(orgid);
    }

    public List<Role> findByUserId(String userid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userid", userid);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select r.* from T_XTFRAME_ROLE r join T_XTFRAME_ROLE_USER ru on r.id=ru.rid where ru.userid=:userid");
        List<RoleEntity> mes = this.dao.nativeQuery(sqlBuilder.toString(), RoleEntity.class, params);
        ArrayList<Role> ms = new ArrayList<Role>(mes.size());
        for (Role role : mes) {
            ms.add(role);
        }
        return ms;
    }

    public void init() {
        this.dao = (RoleDao)this.getBeans().get("roleDao");
        this.orgDao = (OrgDao)this.getBeans().get("orgDao");
        Assert.notNull((Object)this.dao);
        Assert.notNull((Object)this.orgDao);
    }

    @Transactional
    public Role save(Role role) {
        Assert.isInstanceOf(RoleEntity.class, (Object)role);
        return (Role)this.dao.save((Object)((RoleEntity)role));
    }
}

