/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.task.TaskDefinition;

public class UserTaskActivityBehavior
extends TaskActivityBehavior {
    protected TaskDefinition taskDefinition;

    public UserTaskActivityBehavior(TaskDefinition taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        String formKey;
        Object category;
        Object priority;
        Object dueDate;
        TaskEntity task = TaskEntity.createAndInsert(execution);
        task.setExecution(execution);
        task.setTaskDefinition(this.taskDefinition);
        if (this.taskDefinition.getNameExpression() != null) {
            String name = (String)this.taskDefinition.getNameExpression().getValue(execution);
            task.setName(name);
        }
        if (this.taskDefinition.getDescriptionExpression() != null) {
            String description = (String)this.taskDefinition.getDescriptionExpression().getValue(execution);
            task.setDescription(description);
        }
        if (this.taskDefinition.getDueDateExpression() != null && (dueDate = this.taskDefinition.getDueDateExpression().getValue(execution)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar("dueDate");
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
            } else {
                throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + this.taskDefinition.getDueDateExpression().getExpressionText());
            }
        }
        if (this.taskDefinition.getPriorityExpression() != null && (priority = this.taskDefinition.getPriorityExpression().getValue(execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority));
                }
                catch (NumberFormatException e) {
                    throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + this.taskDefinition.getPriorityExpression().getExpressionText());
            }
        }
        if (this.taskDefinition.getCategoryExpression() != null && (category = this.taskDefinition.getCategoryExpression().getValue(execution)) != null) {
            if (category instanceof String) {
                task.setCategory((String)category);
            } else {
                throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + this.taskDefinition.getCategoryExpression().getExpressionText());
            }
        }
        if (this.taskDefinition.getFormKeyExpression() != null && (formKey = (String)this.taskDefinition.getFormKeyExpression().getValue(execution)) != null) {
            if (formKey instanceof String) {
                task.setFormKey(formKey);
            } else {
                throw new ActivitiIllegalArgumentException("FormKey expression does not resolve to a string: " + this.taskDefinition.getFormKeyExpression().getExpressionText());
            }
        }
        this.handleAssignments(task, execution);
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_CREATED, task));
        }
        task.fireEvent("create");
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if (((ExecutionEntity)execution).getTasks().size() != 0) {
            throw new ActivitiException("UserTask should not be signalled before complete");
        }
        this.leave(execution);
    }

    protected void handleAssignments(TaskEntity task, ActivityExecution execution) {
        Object value;
        Map<String, Set<Expression>> identityLinks;
        List<String> candiates;
        Object value2;
        if (this.taskDefinition.getAssigneeExpression() != null) {
            task.setAssignee((String)this.taskDefinition.getAssigneeExpression().getValue(execution), true, false);
        }
        if (this.taskDefinition.getOwnerExpression() != null) {
            task.setOwner((String)this.taskDefinition.getOwnerExpression().getValue(execution));
        }
        if (!this.taskDefinition.getCandidateGroupIdExpressions().isEmpty()) {
            for (Expression groupIdExpr : this.taskDefinition.getCandidateGroupIdExpressions()) {
                value2 = groupIdExpr.getValue(execution);
                if (value2 instanceof String) {
                    candiates = this.extractCandidates((String)value2);
                    task.addCandidateGroups(candiates);
                    continue;
                }
                if (value2 instanceof Collection) {
                    task.addCandidateGroups((Collection)value2);
                    continue;
                }
                throw new ActivitiIllegalArgumentException("Expression did not resolve to a string or collection of strings");
            }
        }
        if (!this.taskDefinition.getCandidateUserIdExpressions().isEmpty()) {
            for (Expression userIdExpr : this.taskDefinition.getCandidateUserIdExpressions()) {
                value2 = userIdExpr.getValue(execution);
                if (value2 instanceof String) {
                    candiates = this.extractCandidates((String)value2);
                    task.addCandidateUsers(candiates);
                    continue;
                }
                if (value2 instanceof Collection) {
                    task.addCandidateUsers((Collection)value2);
                    continue;
                }
                throw new ActivitiException("Expression did not resolve to a string or collection of strings");
            }
        }
        if (!this.taskDefinition.getCustomUserIdentityLinkExpressions().isEmpty()) {
            identityLinks = this.taskDefinition.getCustomUserIdentityLinkExpressions();
            for (String identityLinkType : identityLinks.keySet()) {
                for (Expression idExpression : identityLinks.get(identityLinkType)) {
                    value = idExpression.getValue(execution);
                    if (value instanceof String) {
                        List<String> userIds = this.extractCandidates((String)value);
                        for (String userId : userIds) {
                            task.addUserIdentityLink(userId, identityLinkType);
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator userIdSet = ((Collection)value).iterator();
                        while (userIdSet.hasNext()) {
                            task.addUserIdentityLink((String)userIdSet.next(), identityLinkType);
                        }
                        continue;
                    }
                    throw new ActivitiException("Expression did not resolve to a string or collection of strings");
                }
            }
        }
        if (!this.taskDefinition.getCustomGroupIdentityLinkExpressions().isEmpty()) {
            identityLinks = this.taskDefinition.getCustomGroupIdentityLinkExpressions();
            for (String identityLinkType : identityLinks.keySet()) {
                for (Expression idExpression : identityLinks.get(identityLinkType)) {
                    value = idExpression.getValue(execution);
                    if (value instanceof String) {
                        List<String> groupIds = this.extractCandidates((String)value);
                        for (String groupId : groupIds) {
                            task.addGroupIdentityLink(groupId, identityLinkType);
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator groupIdSet = ((Collection)value).iterator();
                        while (groupIdSet.hasNext()) {
                            task.addGroupIdentityLink((String)groupIdSet.next(), identityLinkType);
                        }
                        continue;
                    }
                    throw new ActivitiException("Expression did not resolve to a string or collection of strings");
                }
            }
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }
}

