/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;

public class ValueTimestamp
extends Value {
    public static final int PRECISION = 23;
    static final int DISPLAY_SIZE = 23;
    static final int DEFAULT_SCALE = 10;
    private final long dateValue;
    private final long nanos;

    private ValueTimestamp(long l, long l2) {
        this.dateValue = l;
        this.nanos = l2;
    }

    public static ValueTimestamp fromDateValueAndNanos(long l, long l2) {
        return (ValueTimestamp)Value.cache(new ValueTimestamp(l, l2));
    }

    public static ValueTimestamp get(Timestamp timestamp) {
        long l = timestamp.getTime();
        long l2 = timestamp.getNanos() % 1000000;
        long l3 = DateTimeUtils.dateValueFromDate(l);
        return ValueTimestamp.fromDateValueAndNanos(l3, l2 += DateTimeUtils.nanosFromDate(l));
    }

    public static ValueTimestamp parse(String string) {
        try {
            return ValueTimestamp.parseTry(string);
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIMESTAMP", string);
        }
    }

    private static ValueTimestamp parseTry(String string) {
        long l;
        int n;
        int n2 = string.indexOf(32);
        if (n2 < 0) {
            n2 = string.indexOf(84);
        }
        if (n2 < 0) {
            n2 = string.length();
            n = -1;
        } else {
            n = n2 + 1;
        }
        long l2 = DateTimeUtils.parseDateValue(string, 0, n2);
        if (n < 0) {
            l = 0L;
        } else {
            int n3;
            int n4 = string.length();
            TimeZone timeZone = null;
            if (string.endsWith("Z")) {
                timeZone = TimeZone.getTimeZone("UTC");
                --n4;
            } else {
                String string2;
                n3 = string.indexOf(43, n2);
                if (n3 < 0) {
                    n3 = string.indexOf(45, n2);
                }
                if (n3 >= 0) {
                    string2 = "GMT" + string.substring(n3);
                    timeZone = TimeZone.getTimeZone(string2);
                    if (!timeZone.getID().startsWith(string2)) {
                        throw new IllegalArgumentException(string2);
                    }
                    n4 = n3;
                } else {
                    n3 = string.indexOf(32, n2 + 1);
                    if (n3 > 0) {
                        string2 = string.substring(n3 + 1);
                        timeZone = TimeZone.getTimeZone(string2);
                        if (!timeZone.getID().startsWith(string2)) {
                            throw new IllegalArgumentException(string2);
                        }
                        n4 = n3;
                    }
                }
            }
            l = DateTimeUtils.parseTimeNanos(string, n2 + 1, n4, true);
            if (timeZone != null) {
                n3 = DateTimeUtils.yearFromDateValue(l2);
                int n5 = DateTimeUtils.monthFromDateValue(l2);
                int n6 = DateTimeUtils.dayFromDateValue(l2);
                long l3 = l / 1000000L;
                l -= l3 * 1000000L;
                long l4 = l3 / 1000L;
                l3 -= l4 * 1000L;
                int n7 = (int)(l4 / 60L);
                l4 -= (long)(n7 * 60);
                int n8 = n7 / 60;
                long l5 = DateTimeUtils.getMillis(timeZone, n3, n5, n6, n8, n7 -= n8 * 60, (int)l4, (int)l3);
                l3 = DateTimeUtils.convertToLocal(new Date(l5), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                long l6 = 86400000L;
                long l7 = (l3 >= 0L ? l3 : l3 - l6 + 1L) / l6;
                l += (l3 -= l7 * l6) * 1000000L;
            }
        }
        return ValueTimestamp.fromDateValueAndNanos(l2, l);
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getNanos() {
        return this.nanos;
    }

    @Override
    public Timestamp getTimestamp() {
        return DateTimeUtils.convertDateValueToTimestamp(this.dateValue, this.nanos);
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(23);
        ValueDate.appendDate(stringBuilder, this.dateValue);
        stringBuilder.append(' ');
        ValueTime.appendTime(stringBuilder, this.nanos, true);
        return stringBuilder.toString();
    }

    @Override
    public String getSQL() {
        return "TIMESTAMP '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 23L;
    }

    @Override
    public int getScale() {
        return 10;
    }

    @Override
    public int getDisplaySize() {
        return 23;
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (n >= 10) {
            return this;
        }
        if (n < 0) {
            throw DbException.getInvalidValueException("scale", n);
        }
        long l = this.nanos;
        BigDecimal bigDecimal = BigDecimal.valueOf(l);
        bigDecimal = bigDecimal.movePointLeft(9);
        bigDecimal = MathUtils.setScale(bigDecimal, n);
        long l2 = (bigDecimal = bigDecimal.movePointRight(9)).longValue();
        if (l2 == l) {
            return this;
        }
        return ValueTimestamp.fromDateValueAndNanos(this.dateValue, l2);
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value;
        int n = MathUtils.compareLong(this.dateValue, valueTimestamp.dateValue);
        if (n != 0) {
            return n;
        }
        return MathUtils.compareLong(this.nanos, valueTimestamp.nanos);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueTimestamp)) {
            return false;
        }
        ValueTimestamp valueTimestamp = (ValueTimestamp)object;
        return this.dateValue == valueTimestamp.dateValue && this.nanos == valueTimestamp.nanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.nanos ^ this.nanos >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getTimestamp();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setTimestamp(n, this.getTimestamp());
    }

    @Override
    public Value add(Value value) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
        long l = DateTimeUtils.absoluteDayFromDateValue(this.dateValue);
        long l2 = DateTimeUtils.absoluteDayFromDateValue(valueTimestamp.dateValue);
        return DateTimeUtils.normalizeTimestamp(l + l2, this.nanos + valueTimestamp.nanos);
    }

    @Override
    public Value subtract(Value value) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
        long l = DateTimeUtils.absoluteDayFromDateValue(this.dateValue);
        long l2 = DateTimeUtils.absoluteDayFromDateValue(valueTimestamp.dateValue);
        return DateTimeUtils.normalizeTimestamp(l - l2, this.nanos - valueTimestamp.nanos);
    }
}

