/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.mustache;

import com.sampullara.mustache.Mustache;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MustacheTrace {
    private static ThreadLocal<MustacheTrace> traceThreadLocal = new ThreadLocal();
    private static Map<Long, MustacheTrace> traces = new ConcurrentHashMap<Long, MustacheTrace>();
    private long unique;
    private List<Event> events = new ArrayList<Event>();

    public static synchronized Event addEvent(String name, String parameter) {
        MustacheTrace trace = traceThreadLocal.get();
        String threadName = Thread.currentThread().getName();
        Event event = new Event(name, parameter, threadName);
        if (trace == null) {
            Mustache.logger.info("Current trace not set in thread " + threadName);
        } else {
            trace.events.add(event);
        }
        return event;
    }

    public static void toASCII(Writer w, long uniqueid, int range) throws IOException {
        MustacheTrace trace = traces.get(uniqueid);
        if (trace == null) {
            return;
        }
        long min = Long.MAX_VALUE;
        long max = 0L;
        for (Event event : trace.events) {
            if (event.end > max) {
                max = event.end;
            }
            if (event.start >= min) continue;
            min = event.start;
        }
        double scale = (double)range / ((double)max - (double)min);
        Collections.sort(trace.events, new Comparator<Event>(){

            @Override
            public int compare(Event event, Event event1) {
                return (int)(event.start - event1.start);
            }
        });
        for (Event event : trace.events) {
            int i;
            int total;
            long interval = event.end - event.start;
            if (interval <= 1L) continue;
            int during = (int)Math.round((double)interval * scale);
            int before = (int)Math.round((double)(event.start - min) * scale);
            int after = (int)Math.round((double)(max - event.end) * scale);
            int extra = 0;
            if (event.end == 0L) {
                during = 0;
                after = 0;
                extra = range - before;
            }
            if ((total = before + during + after) < range) {
                during += range - total;
            }
            if (total > range) {
                during -= total - range;
            }
            if (during == 0) continue;
            for (i = 0; i < before; ++i) {
                w.write("-");
            }
            for (i = 0; i < during; ++i) {
                w.write("*");
            }
            for (i = 0; i < after; ++i) {
                w.write("-");
            }
            for (i = 0; i < extra; ++i) {
                w.write("x");
            }
            w.write(" ");
            w.write(event.name);
            w.write(", ");
            w.write(String.valueOf(interval));
            w.write("ms\n");
        }
        w.write("Time: " + (max - min) + "ms Operations: " + trace.events.size() + "\n");
    }

    public static synchronized void setUniqueId(long unique) {
        MustacheTrace trace = traces.get(unique);
        if (trace == null) {
            trace = new MustacheTrace();
            traces.put(unique, trace);
        }
        trace.unique = unique;
        traceThreadLocal.set(trace);
    }

    public static synchronized long getUniqueId() {
        return MustacheTrace.traceThreadLocal.get().unique;
    }

    public static class Event {
        public long start = System.currentTimeMillis();
        public long end;
        public String thread;
        public String name;
        public String parameter;

        public Event(String name, String parameter, String thread) {
            this.name = name;
            this.parameter = parameter;
            this.thread = thread;
        }

        public String toString() {
            return this.start + ",\"" + this.end + ",\"" + this.name.replace("\"", "\\\"") + "\",\"" + this.parameter.replace("\"", "\\\"") + "\"";
        }

        public void end() {
            this.end = System.currentTimeMillis();
        }
    }
}

