/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.seg;

import java.util.LinkedList;
import java.util.List;
import org.wltea.analyzer.Context;
import org.wltea.analyzer.Lexeme;
import org.wltea.analyzer.dic.Dictionary;
import org.wltea.analyzer.dic.Hit;
import org.wltea.analyzer.help.CharacterHelper;
import org.wltea.analyzer.seg.ISegmenter;

public class CJKSegmenter
implements ISegmenter {
    private int doneIndex = -1;
    private List<Hit> hitList = new LinkedList<Hit>();

    public void nextLexeme(char[] segmentBuff, Context context) {
        char input = segmentBuff[context.getCursor()];
        if (CharacterHelper.isCJKCharacter(input)) {
            Hit hit;
            if (this.hitList.size() > 0) {
                Hit[] tmpArray;
                Hit[] hitArray = tmpArray = this.hitList.toArray(new Hit[this.hitList.size()]);
                int n = tmpArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Hit hit2 = hitArray[n2];
                    hit2 = Dictionary.matchWithHit(segmentBuff, context.getCursor(), hit2);
                    if (hit2.isMatch()) {
                        if (hit2.getBegin() > this.doneIndex + 1) {
                            this.processUnknown(segmentBuff, context, this.doneIndex + 1, hit2.getBegin() - 1);
                        }
                        Lexeme newLexeme = new Lexeme(context.getBuffOffset(), hit2.getBegin(), context.getCursor() - hit2.getBegin() + 1, 0);
                        context.addLexeme(newLexeme);
                        if (this.doneIndex < context.getCursor()) {
                            this.doneIndex = context.getCursor();
                        }
                        if (!hit2.isPrefix()) {
                            this.hitList.remove(hit2);
                        }
                    } else if (!hit2.isPrefix() && hit2.isUnmatch()) {
                        this.hitList.remove(hit2);
                    }
                    ++n2;
                }
            }
            if ((hit = Dictionary.matchInMainDict(segmentBuff, context.getCursor(), 1)).isMatch()) {
                if (context.getCursor() > this.doneIndex + 1) {
                    this.processUnknown(segmentBuff, context, this.doneIndex + 1, context.getCursor() - 1);
                }
                Lexeme newLexeme = new Lexeme(context.getBuffOffset(), context.getCursor(), 1, 0);
                context.addLexeme(newLexeme);
                if (this.doneIndex < context.getCursor()) {
                    this.doneIndex = context.getCursor();
                }
                if (hit.isPrefix()) {
                    this.hitList.add(hit);
                }
            } else if (hit.isPrefix()) {
                this.hitList.add(hit);
            } else if (hit.isUnmatch()) {
                if (this.doneIndex >= context.getCursor()) {
                    return;
                }
                this.processUnknown(segmentBuff, context, this.doneIndex + 1, context.getCursor());
                this.doneIndex = context.getCursor();
            }
        } else {
            if (this.hitList.size() > 0 && this.doneIndex < context.getCursor() - 1) {
                for (Hit hit : this.hitList) {
                    if (this.doneIndex >= hit.getEnd()) continue;
                    this.processUnknown(segmentBuff, context, this.doneIndex + 1, hit.getEnd());
                }
            }
            this.hitList.clear();
            if (this.doneIndex < context.getCursor()) {
                this.doneIndex = context.getCursor();
            }
        }
        if (context.getCursor() == context.getAvailable() - 1) {
            if (this.hitList.size() > 0 && this.doneIndex < context.getCursor()) {
                for (Hit hit : this.hitList) {
                    if (this.doneIndex >= hit.getEnd()) continue;
                    this.processUnknown(segmentBuff, context, this.doneIndex + 1, hit.getEnd());
                }
            }
            this.hitList.clear();
        }
        if (this.hitList.size() == 0) {
            context.unlockBuffer(this);
        } else {
            context.lockBuffer(this);
        }
    }

    private void processUnknown(char[] segmentBuff, Context context, int uBegin, int uEnd) {
        Lexeme newLexeme = null;
        Hit hit = Dictionary.matchInPrepDict(segmentBuff, uBegin, 1);
        if (hit.isUnmatch() && uBegin > 0 && (hit = Dictionary.matchInSurnameDict(segmentBuff, uBegin - 1, 1)).isMatch()) {
            newLexeme = new Lexeme(context.getBuffOffset(), uBegin - 1, 1, 1);
            context.addLexeme(newLexeme);
        }
        int i = uBegin;
        while (i <= uEnd) {
            newLexeme = new Lexeme(context.getBuffOffset(), i, 1, 3);
            context.addLexeme(newLexeme);
            ++i;
        }
        hit = Dictionary.matchInPrepDict(segmentBuff, uEnd, 1);
        if (hit.isUnmatch()) {
            int length = 1;
            while (uEnd < context.getAvailable() - length) {
                hit = Dictionary.matchInSuffixDict(segmentBuff, uEnd + 1, length);
                if (hit.isMatch()) {
                    newLexeme = new Lexeme(context.getBuffOffset(), uEnd + 1, length, 2);
                    context.addLexeme(newLexeme);
                    break;
                }
                if (hit.isUnmatch()) break;
                ++length;
            }
        }
    }

    public void reset() {
        this.doneIndex = -1;
        this.hitList.clear();
    }
}

