/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.LobStorage;
import org.h2.tools.SimpleResultSet;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public abstract class Value {
    public static final int UNKNOWN = -1;
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int DECIMAL = 6;
    public static final int DOUBLE = 7;
    public static final int FLOAT = 8;
    public static final int TIME = 9;
    public static final int DATE = 10;
    public static final int TIMESTAMP = 11;
    public static final int BYTES = 12;
    public static final int STRING = 13;
    public static final int STRING_IGNORECASE = 14;
    public static final int BLOB = 15;
    public static final int CLOB = 16;
    public static final int ARRAY = 17;
    public static final int RESULT_SET = 18;
    public static final int JAVA_OBJECT = 19;
    public static final int UUID = 20;
    public static final int STRING_FIXED = 21;
    public static final int TYPE_COUNT = 22;
    private static SoftReference<Value[]> softCache = new SoftReference<Object>(null);
    private static final BigDecimal MAX_LONG_DECIMAL = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_LONG_DECIMAL = BigDecimal.valueOf(Long.MIN_VALUE);

    public abstract String getSQL();

    public abstract int getType();

    public abstract long getPrecision();

    public abstract int getDisplaySize();

    public int getMemory() {
        return DataType.getDataType((int)this.getType()).memory;
    }

    public abstract String getString();

    public abstract Object getObject();

    public abstract void set(PreparedStatement var1, int var2) throws SQLException;

    protected abstract int compareSecure(Value var1, CompareMode var2);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static int getOrder(int n) {
        switch (n) {
            case -1: {
                return 1;
            }
            case 0: {
                return 2;
            }
            case 13: {
                return 10;
            }
            case 16: {
                return 11;
            }
            case 21: {
                return 12;
            }
            case 14: {
                return 13;
            }
            case 1: {
                return 20;
            }
            case 2: {
                return 21;
            }
            case 3: {
                return 22;
            }
            case 4: {
                return 23;
            }
            case 5: {
                return 24;
            }
            case 6: {
                return 25;
            }
            case 8: {
                return 26;
            }
            case 7: {
                return 27;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 32;
            }
            case 12: {
                return 40;
            }
            case 15: {
                return 41;
            }
            case 20: {
                return 42;
            }
            case 19: {
                return 43;
            }
            case 17: {
                return 50;
            }
            case 18: {
                return 51;
            }
        }
        throw DbException.throwInternalError("type:" + n);
    }

    public static int getHigherOrder(int n, int n2) {
        int n3;
        if (n == -1 || n2 == -1) {
            if (n == n2) {
                throw DbException.get(50004, "?, ?");
            }
            if (n == 0) {
                throw DbException.get(50004, "NULL, ?");
            }
            if (n2 == 0) {
                throw DbException.get(50004, "?, NULL");
            }
        }
        if (n == n2) {
            return n;
        }
        int n4 = Value.getOrder(n);
        return n4 > (n3 = Value.getOrder(n2)) ? n : n2;
    }

    static Value cache(Value value) {
        if (SysProperties.OBJECT_CACHE) {
            int n;
            Value value2;
            Value[] valueArray;
            int n2 = value.hashCode();
            if (softCache == null) {
                softCache = new SoftReference<Object>(null);
            }
            if ((valueArray = softCache.get()) == null) {
                valueArray = new Value[SysProperties.OBJECT_CACHE_SIZE];
                softCache = new SoftReference<Value[]>(valueArray);
            }
            if ((value2 = valueArray[n = n2 & SysProperties.OBJECT_CACHE_SIZE - 1]) != null && value2.getType() == value.getType() && value.equals(value2)) {
                return value2;
            }
            valueArray[n] = value;
        }
        return value;
    }

    public static void clearCache() {
        softCache = null;
    }

    public Boolean getBoolean() {
        return ((ValueBoolean)this.convertTo(1)).getBoolean();
    }

    public Date getDate() {
        return ((ValueDate)this.convertTo(10)).getDate();
    }

    public Time getTime() {
        return ((ValueTime)this.convertTo(9)).getTime();
    }

    public Timestamp getTimestamp() {
        return ((ValueTimestamp)this.convertTo(11)).getTimestamp();
    }

    public byte[] getBytes() {
        return ((ValueBytes)this.convertTo(12)).getBytes();
    }

    public byte[] getBytesNoCopy() {
        return ((ValueBytes)this.convertTo(12)).getBytesNoCopy();
    }

    public byte getByte() {
        return ((ValueByte)this.convertTo(2)).getByte();
    }

    public short getShort() {
        return ((ValueShort)this.convertTo(3)).getShort();
    }

    public BigDecimal getBigDecimal() {
        return ((ValueDecimal)this.convertTo(6)).getBigDecimal();
    }

    public double getDouble() {
        return ((ValueDouble)this.convertTo(7)).getDouble();
    }

    public float getFloat() {
        return ((ValueFloat)this.convertTo(8)).getFloat();
    }

    public int getInt() {
        return ((ValueInt)this.convertTo(4)).getInt();
    }

    public long getLong() {
        return ((ValueLong)this.convertTo(5)).getLong();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getBytesNoCopy());
    }

    public Reader getReader() {
        return IOUtils.getReaderFromString(this.getString());
    }

    public Value add(Value value) {
        throw this.throwUnsupportedExceptionForType("+");
    }

    public int getSignum() {
        throw this.throwUnsupportedExceptionForType("SIGNUM");
    }

    public Value negate() {
        throw this.throwUnsupportedExceptionForType("NEG");
    }

    public Value subtract(Value value) {
        throw this.throwUnsupportedExceptionForType("-");
    }

    public Value divide(Value value) {
        throw this.throwUnsupportedExceptionForType("/");
    }

    public Value multiply(Value value) {
        throw this.throwUnsupportedExceptionForType("*");
    }

    public Value modulus(Value value) {
        throw this.throwUnsupportedExceptionForType("%");
    }

    public Value convertTo(int n) {
        if (this.getType() == n) {
            return this;
        }
        try {
            switch (n) {
                case 1: {
                    switch (this.getType()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            return ValueBoolean.get(this.getSignum() != 0);
                        }
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 19: 
                        case 20: {
                            throw DbException.get(22018, this.getString());
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueByte.get(this.getBoolean() != false ? (byte)1 : 0);
                        }
                        case 3: {
                            return ValueByte.get(Value.convertToByte(this.getShort()));
                        }
                        case 4: {
                            return ValueByte.get(Value.convertToByte(this.getInt()));
                        }
                        case 5: {
                            return ValueByte.get(Value.convertToByte(this.getLong()));
                        }
                        case 6: {
                            return ValueByte.get(Value.convertToByte(Value.convertToLong(this.getBigDecimal())));
                        }
                        case 7: {
                            return ValueByte.get(Value.convertToByte(Value.convertToLong(this.getDouble())));
                        }
                        case 8: {
                            return ValueByte.get(Value.convertToByte(Value.convertToLong(this.getFloat())));
                        }
                        case 12: {
                            return ValueByte.get((byte)Integer.parseInt(this.getString(), 16));
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueShort.get(this.getBoolean() != false ? (short)1 : 0);
                        }
                        case 2: {
                            return ValueShort.get(this.getByte());
                        }
                        case 4: {
                            return ValueShort.get(Value.convertToShort(this.getInt()));
                        }
                        case 5: {
                            return ValueShort.get(Value.convertToShort(this.getLong()));
                        }
                        case 6: {
                            return ValueShort.get(Value.convertToShort(Value.convertToLong(this.getBigDecimal())));
                        }
                        case 7: {
                            return ValueShort.get(Value.convertToShort(Value.convertToLong(this.getDouble())));
                        }
                        case 8: {
                            return ValueShort.get(Value.convertToShort(Value.convertToLong(this.getFloat())));
                        }
                        case 12: {
                            return ValueShort.get((short)Integer.parseInt(this.getString(), 16));
                        }
                    }
                    break;
                }
                case 4: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueInt.get(this.getBoolean() != false ? 1 : 0);
                        }
                        case 2: {
                            return ValueInt.get(this.getByte());
                        }
                        case 3: {
                            return ValueInt.get(this.getShort());
                        }
                        case 5: {
                            return ValueInt.get(Value.convertToInt(this.getLong()));
                        }
                        case 6: {
                            return ValueInt.get(Value.convertToInt(Value.convertToLong(this.getBigDecimal())));
                        }
                        case 7: {
                            return ValueInt.get(Value.convertToInt(Value.convertToLong(this.getDouble())));
                        }
                        case 8: {
                            return ValueInt.get(Value.convertToInt(Value.convertToLong(this.getFloat())));
                        }
                        case 12: {
                            return ValueInt.get((int)Long.parseLong(this.getString(), 16));
                        }
                    }
                    break;
                }
                case 5: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueLong.get(this.getBoolean() != false ? 1L : 0L);
                        }
                        case 2: {
                            return ValueLong.get(this.getByte());
                        }
                        case 3: {
                            return ValueLong.get(this.getShort());
                        }
                        case 4: {
                            return ValueLong.get(this.getInt());
                        }
                        case 6: {
                            return ValueLong.get(Value.convertToLong(this.getBigDecimal()));
                        }
                        case 7: {
                            return ValueLong.get(Value.convertToLong(this.getDouble()));
                        }
                        case 8: {
                            return ValueLong.get(Value.convertToLong(this.getFloat()));
                        }
                        case 12: {
                            byte[] byArray = this.getBytes();
                            if (byArray.length == 8) {
                                return ValueLong.get(Utils.readLong(byArray, 0));
                            }
                            return ValueLong.get(Long.parseLong(this.getString(), 16));
                        }
                    }
                    break;
                }
                case 6: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueDecimal.get(BigDecimal.valueOf(this.getBoolean() != false ? 1L : 0L));
                        }
                        case 2: {
                            return ValueDecimal.get(BigDecimal.valueOf(this.getByte()));
                        }
                        case 3: {
                            return ValueDecimal.get(BigDecimal.valueOf(this.getShort()));
                        }
                        case 4: {
                            return ValueDecimal.get(BigDecimal.valueOf(this.getInt()));
                        }
                        case 5: {
                            return ValueDecimal.get(BigDecimal.valueOf(this.getLong()));
                        }
                        case 7: {
                            double d = this.getDouble();
                            if (Double.isInfinite(d) || Double.isNaN(d)) {
                                throw DbException.get(22018, "" + d);
                            }
                            return ValueDecimal.get(BigDecimal.valueOf(d));
                        }
                        case 8: {
                            float f = this.getFloat();
                            if (Float.isInfinite(f) || Float.isNaN(f)) {
                                throw DbException.get(22018, "" + f);
                            }
                            return ValueDecimal.get(new BigDecimal(Float.toString(f)));
                        }
                    }
                    break;
                }
                case 7: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueDouble.get(this.getBoolean() != false ? 1.0 : 0.0);
                        }
                        case 2: {
                            return ValueDouble.get(this.getByte());
                        }
                        case 3: {
                            return ValueDouble.get(this.getShort());
                        }
                        case 4: {
                            return ValueDouble.get(this.getInt());
                        }
                        case 5: {
                            return ValueDouble.get(this.getLong());
                        }
                        case 6: {
                            return ValueDouble.get(this.getBigDecimal().doubleValue());
                        }
                        case 8: {
                            return ValueDouble.get(this.getFloat());
                        }
                    }
                    break;
                }
                case 8: {
                    switch (this.getType()) {
                        case 1: {
                            return ValueFloat.get(this.getBoolean() != false ? 1.0f : 0.0f);
                        }
                        case 2: {
                            return ValueFloat.get(this.getByte());
                        }
                        case 3: {
                            return ValueFloat.get(this.getShort());
                        }
                        case 4: {
                            return ValueFloat.get(this.getInt());
                        }
                        case 5: {
                            return ValueFloat.get(this.getLong());
                        }
                        case 6: {
                            return ValueFloat.get(this.getBigDecimal().floatValue());
                        }
                        case 7: {
                            return ValueFloat.get((float)this.getDouble());
                        }
                    }
                    break;
                }
                case 10: {
                    switch (this.getType()) {
                        case 9: {
                            return ValueDate.fromDateValue(DateTimeUtils.dateValue(1970L, 1, 1));
                        }
                        case 11: {
                            return ValueDate.fromDateValue(((ValueTimestamp)this).getDateValue());
                        }
                    }
                    break;
                }
                case 9: {
                    switch (this.getType()) {
                        case 10: {
                            return ValueTime.fromNanos(0L);
                        }
                        case 11: {
                            return ValueTime.fromNanos(((ValueTimestamp)this).getNanos());
                        }
                    }
                    break;
                }
                case 11: {
                    switch (this.getType()) {
                        case 9: {
                            return DateTimeUtils.normalizeTimestamp(0L, ((ValueTime)this).getNanos());
                        }
                        case 10: {
                            return ValueTimestamp.fromDateValueAndNanos(((ValueDate)this).getDateValue(), 0L);
                        }
                    }
                    break;
                }
                case 12: {
                    switch (this.getType()) {
                        case 15: 
                        case 19: {
                            return ValueBytes.getNoCopy(this.getBytesNoCopy());
                        }
                        case 20: {
                            return ValueBytes.getNoCopy(this.getBytes());
                        }
                        case 2: {
                            return ValueBytes.getNoCopy(new byte[]{this.getByte()});
                        }
                        case 3: {
                            short s = this.getShort();
                            return ValueBytes.getNoCopy(new byte[]{(byte)(s >> 8), (byte)s});
                        }
                        case 4: {
                            int n2 = this.getInt();
                            return ValueBytes.getNoCopy(new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2});
                        }
                        case 5: {
                            long l = this.getLong();
                            return ValueBytes.getNoCopy(new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l});
                        }
                    }
                    break;
                }
                case 19: {
                    switch (this.getType()) {
                        case 12: 
                        case 15: {
                            return ValueJavaObject.getNoCopy(null, this.getBytesNoCopy());
                        }
                    }
                    break;
                }
                case 15: {
                    switch (this.getType()) {
                        case 12: {
                            return LobStorage.createSmallLob(15, this.getBytesNoCopy());
                        }
                    }
                    break;
                }
                case 20: {
                    switch (this.getType()) {
                        case 12: {
                            return ValueUuid.get(this.getBytesNoCopy());
                        }
                    }
                }
            }
            String string = this.getString();
            switch (n) {
                case 0: {
                    return ValueNull.INSTANCE;
                }
                case 1: {
                    if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y")) {
                        return ValueBoolean.get(true);
                    }
                    if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("f") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("n")) {
                        return ValueBoolean.get(false);
                    }
                    return ValueBoolean.get(new BigDecimal(string).signum() != 0);
                }
                case 2: {
                    return ValueByte.get(Byte.parseByte(string.trim()));
                }
                case 3: {
                    return ValueShort.get(Short.parseShort(string.trim()));
                }
                case 4: {
                    return ValueInt.get(Integer.parseInt(string.trim()));
                }
                case 5: {
                    return ValueLong.get(Long.parseLong(string.trim()));
                }
                case 6: {
                    return ValueDecimal.get(new BigDecimal(string.trim()));
                }
                case 9: {
                    return ValueTime.parse(string.trim());
                }
                case 10: {
                    return ValueDate.parse(string.trim());
                }
                case 11: {
                    return ValueTimestamp.parse(string.trim());
                }
                case 12: {
                    return ValueBytes.getNoCopy(StringUtils.convertHexToBytes(string.trim()));
                }
                case 19: {
                    return ValueJavaObject.getNoCopy(null, StringUtils.convertHexToBytes(string.trim()));
                }
                case 13: {
                    return ValueString.get(string);
                }
                case 14: {
                    return ValueStringIgnoreCase.get(string);
                }
                case 21: {
                    return ValueStringFixed.get(string);
                }
                case 7: {
                    return ValueDouble.get(Double.parseDouble(string.trim()));
                }
                case 8: {
                    return ValueFloat.get(Float.parseFloat(string.trim()));
                }
                case 16: {
                    return LobStorage.createSmallLob(16, StringUtils.utf8Encode(string));
                }
                case 15: {
                    return LobStorage.createSmallLob(15, StringUtils.convertHexToBytes(string.trim()));
                }
                case 17: {
                    return ValueArray.get(new Value[]{ValueString.get(string)});
                }
                case 18: {
                    SimpleResultSet simpleResultSet = new SimpleResultSet();
                    simpleResultSet.addColumn("X", 12, string.length(), 0);
                    simpleResultSet.addRow(string);
                    return ValueResultSet.get(simpleResultSet);
                }
                case 20: {
                    return ValueUuid.get(string);
                }
            }
            throw DbException.throwInternalError("type=" + n);
        }
        catch (NumberFormatException numberFormatException) {
            throw DbException.get(22018, numberFormatException, this.getString());
        }
    }

    public final int compareTypeSave(Value value, CompareMode compareMode) {
        if (this == value) {
            return 0;
        }
        if (this == ValueNull.INSTANCE) {
            return -1;
        }
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        return this.compareSecure(value, compareMode);
    }

    public final int compareTo(Value value, CompareMode compareMode) {
        if (this == value) {
            return 0;
        }
        if (this == ValueNull.INSTANCE) {
            return value == ValueNull.INSTANCE ? 0 : -1;
        }
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        if (this.getType() == value.getType()) {
            return this.compareSecure(value, compareMode);
        }
        int n = Value.getHigherOrder(this.getType(), value.getType());
        return this.convertTo(n).compareSecure(value.convertTo(n), compareMode);
    }

    public int getScale() {
        return 0;
    }

    public Value convertScale(boolean bl, int n) {
        return this;
    }

    public Value convertPrecision(long l, boolean bl) {
        return this;
    }

    private static byte convertToByte(long l) {
        if (l > 127L || l < -128L) {
            throw DbException.get(22003, Long.toString(l));
        }
        return (byte)l;
    }

    private static short convertToShort(long l) {
        if (l > 32767L || l < -32768L) {
            throw DbException.get(22003, Long.toString(l));
        }
        return (short)l;
    }

    private static int convertToInt(long l) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw DbException.get(22003, Long.toString(l));
        }
        return (int)l;
    }

    private static long convertToLong(double d) {
        if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
            throw DbException.get(22003, Double.toString(d));
        }
        return Math.round(d);
    }

    private static long convertToLong(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(MAX_LONG_DECIMAL) > 0 || bigDecimal.compareTo(MIN_LONG_DECIMAL) < 0) {
            throw DbException.get(22003, bigDecimal.toString());
        }
        return bigDecimal.setScale(0, 4).longValue();
    }

    public Value link(DataHandler dataHandler, int n) {
        return this;
    }

    public boolean isLinked() {
        return false;
    }

    public void unlink() {
    }

    public void close() {
    }

    public boolean checkPrecision(long l) {
        return this.getPrecision() <= l;
    }

    public String getTraceSQL() {
        return this.getSQL();
    }

    public String toString() {
        return this.getTraceSQL();
    }

    protected DbException throwUnsupportedExceptionForType(String string) {
        throw DbException.getUnsupportedException(DataType.getDataType((int)this.getType()).name + " " + string);
    }

    public int getTableId() {
        return 0;
    }

    public byte[] getSmall() {
        return null;
    }

    public Value copyToTemp() {
        return this;
    }

    public ResultSet getResultSet() {
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        simpleResultSet.addColumn("X", DataType.convertTypeToSQLType(this.getType()), MathUtils.convertLongToInt(this.getPrecision()), this.getScale());
        simpleResultSet.addRow(this.getObject());
        return simpleResultSet;
    }

    public static interface ValueBlob {
    }

    public static interface ValueClob {
    }
}

