/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.h2.mvstore.ChangeCursor;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.Page;
import org.h2.mvstore.type.DataType;
import org.h2.util.New;

public class MVMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    protected MVStore store;
    protected volatile Page root;
    private int id;
    private String name;
    private long createVersion;
    private final DataType keyType;
    private final DataType valueType;
    private ArrayList<Page> oldRoots = new ArrayList();
    private boolean closed;
    private boolean readOnly;

    public MVMap(DataType dataType, DataType dataType2) {
        this.keyType = dataType;
        this.valueType = dataType2;
        this.root = Page.createEmpty(this, -1L);
    }

    public void open(MVStore mVStore, HashMap<String, String> hashMap) {
        this.store = mVStore;
        this.id = Integer.parseInt(hashMap.get("id"));
        this.name = hashMap.get("name");
        this.createVersion = Long.parseLong(hashMap.get("createVersion"));
    }

    @Override
    public V put(K k, V v) {
        this.checkWrite();
        long l = this.store.getCurrentVersion();
        Page page = this.root.copyOnWrite(l);
        if (page.getMemory() > this.store.getPageSize() && page.getKeyCount() > 1) {
            int n = page.getKeyCount() / 2;
            long l2 = page.getTotalCount();
            Object object = page.getKey(n);
            Page page2 = page.split(n);
            Object[] objectArray = new Object[]{object};
            long[] lArray = new long[]{page.getPos(), page2.getPos()};
            Page[] pageArray = new Page[]{page, page2};
            long[] lArray2 = new long[]{page.getTotalCount(), page2.getTotalCount()};
            page = Page.create(this, l, 1, objectArray, null, lArray, pageArray, lArray2, l2, 0, 0);
            this.store.registerUnsavedPage();
        }
        Object object = this.put(page, l, k, v);
        this.newRoot(page);
        return (V)object;
    }

    protected Object put(Page page, long l, Object object, Object object2) {
        if (page.isLeaf()) {
            int n = page.binarySearch(object);
            if (n < 0) {
                n = -n - 1;
                page.insertLeaf(n, object, object2);
                return null;
            }
            return page.setValue(n, object2);
        }
        int n = page.binarySearch(object);
        n = n < 0 ? -n - 1 : ++n;
        Page page2 = page.getChildPage(n).copyOnWrite(l);
        if (page2.getMemory() > this.store.getPageSize() && page2.getKeyCount() > 1) {
            int n2 = page2.getKeyCount() / 2;
            Object object3 = page2.getKey(n2);
            Page page3 = page2.split(n2);
            page.setChild(n, page3);
            page.insertNode(n, object3, page2);
            return this.put(page, l, object, object2);
        }
        Object object4 = this.put(page2, l, object, object2);
        page.setChild(n, page2);
        return object4;
    }

    public K firstKey() {
        return this.getFirstLast(true);
    }

    public K lastKey() {
        return this.getFirstLast(false);
    }

    public K getKey(long l) {
        this.checkOpen();
        if (l < 0L || l >= (long)this.size()) {
            return null;
        }
        Page page = this.root;
        long l2 = 0L;
        while (true) {
            long l3;
            int n;
            if (page.isLeaf()) {
                if (l >= l2 + (long)page.getKeyCount()) {
                    return null;
                }
                return (K)page.getKey((int)(l - l2));
            }
            int n2 = page.getChildPageCount();
            for (n = 0; n < n2 && l >= (l3 = page.getCounts(n)) + l2; ++n) {
                l2 += l3;
            }
            if (n == n2) {
                return null;
            }
            page = page.getChildPage(n);
        }
    }

    public List<K> keyList() {
        return new AbstractList<K>(){

            @Override
            public K get(int n) {
                return MVMap.this.getKey(n);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public int indexOf(Object object) {
                return (int)MVMap.this.getKeyIndex(object);
            }
        };
    }

    public long getKeyIndex(K k) {
        this.checkOpen();
        if (this.size() == 0) {
            return -1L;
        }
        Page page = this.root;
        long l = 0L;
        while (true) {
            int n;
            if (page.isLeaf()) {
                n = page.binarySearch(k);
                if (n < 0) {
                    return -l + (long)n;
                }
                return l + (long)n;
            }
            int n2 = n = k == null ? -1 : page.binarySearch(k);
            n = n < 0 ? -n - 1 : ++n;
            for (int i = 0; i < n; ++i) {
                l += page.getCounts(i);
            }
            page = page.getChildPage(n);
        }
    }

    private K getFirstLast(boolean bl) {
        this.checkOpen();
        if (this.size() == 0) {
            return null;
        }
        Page page = this.root;
        while (!page.isLeaf()) {
            page = page.getChildPage(bl ? 0 : page.getChildPageCount() - 1);
        }
        return (K)page.getKey(bl ? 0 : page.getKeyCount() - 1);
    }

    public K higherKey(K k) {
        return this.getMinMax(k, false, true);
    }

    public K ceilingKey(K k) {
        return this.getMinMax(k, false, false);
    }

    public K floorKey(K k) {
        return this.getMinMax(k, true, false);
    }

    public K lowerKey(K k) {
        return this.getMinMax(k, true, true);
    }

    private K getMinMax(K k, boolean bl, boolean bl2) {
        this.checkOpen();
        if (this.size() == 0) {
            return null;
        }
        return this.getMinMax(this.root, k, bl, bl2);
    }

    private K getMinMax(Page page, K k, boolean bl, boolean bl2) {
        int n;
        if (page.isLeaf()) {
            if (k == null) {
                return (K)page.getKey(bl ? 0 : page.getKeyCount() - 1);
            }
            int n2 = page.binarySearch(k);
            if (n2 < 0) {
                n2 = -n2 - (bl ? 2 : 1);
            } else if (bl2) {
                n2 += bl ? -1 : 1;
            }
            if (n2 < 0 || n2 >= page.getKeyCount()) {
                return null;
            }
            return (K)page.getKey(n2);
        }
        n = k == null ? (bl ? 0 : page.getKeyCount() - 1) : ((n = page.binarySearch(k)) < 0 ? -n - 1 : ++n);
        while (n >= 0 && n < page.getChildPageCount()) {
            K k2 = this.getMinMax(page.getChildPage(n), k, bl, bl2);
            if (k2 != null) {
                return k2;
            }
            n += bl ? -1 : 1;
        }
        return null;
    }

    @Override
    public V get(Object object) {
        this.checkOpen();
        return (V)this.binarySearch(this.root, object);
    }

    protected Object binarySearch(Page page, Object object) {
        int n = page.binarySearch(object);
        if (!page.isLeaf()) {
            n = n < 0 ? -n - 1 : ++n;
            page = page.getChildPage(n);
            return this.binarySearch(page, object);
        }
        if (n >= 0) {
            return page.getValue(n);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    protected Page getPage(K k) {
        return this.binarySearchPage(this.root, k);
    }

    protected Page binarySearchPage(Page page, Object object) {
        int n = page.binarySearch(object);
        if (!page.isLeaf()) {
            n = n < 0 ? -n - 1 : ++n;
            page = page.getChildPage(n);
            return this.binarySearchPage(page, object);
        }
        if (n >= 0) {
            return page;
        }
        return null;
    }

    @Override
    public void clear() {
        this.checkWrite();
        this.root.removeAllRecursive();
        this.newRoot(Page.createEmpty(this, this.store.getCurrentVersion()));
    }

    public void removeMap() {
        if (this != this.store.getMetaMap()) {
            this.checkWrite();
            this.root.removeAllRecursive();
            this.store.removeMap(this.name);
            this.close();
        }
    }

    public void close() {
        this.closed = true;
        this.readOnly = true;
        this.removeAllOldVersions();
        this.root = null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public V remove(Object object) {
        this.checkWrite();
        long l = this.store.getCurrentVersion();
        Page page = this.root.copyOnWrite(l);
        Object object2 = this.remove(page, l, object);
        this.newRoot(page);
        return (V)object2;
    }

    @Override
    public synchronized V putIfAbsent(K k, V v) {
        V v2 = this.get(k);
        if (v2 == null) {
            this.put(k, v);
        }
        return v2;
    }

    @Override
    public synchronized boolean remove(Object object, Object object2) {
        V v = this.get(object);
        if (v.equals(object2)) {
            this.remove(object);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean replace(K k, V v, V v2) {
        V v3 = this.get(k);
        if (v3.equals(v)) {
            this.put(k, v2);
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K k, V v) {
        V v2 = this.get(k);
        if (v2 != null) {
            this.put(k, v);
            return v2;
        }
        return null;
    }

    protected Object remove(Page page, long l, Object object) {
        int n = page.binarySearch(object);
        Object object2 = null;
        if (page.isLeaf()) {
            if (n >= 0) {
                object2 = page.getValue(n);
                page.remove(n);
                if (page.getKeyCount() == 0) {
                    this.removePage(page);
                }
            }
            return object2;
        }
        n = n < 0 ? -n - 1 : ++n;
        Page page2 = page.getChildPage(n);
        Page page3 = page2.copyOnWrite(l);
        long l2 = page3.getTotalCount();
        object2 = this.remove(page3, l, object);
        if (l2 == page3.getTotalCount()) {
            return null;
        }
        if (page3.getTotalCount() == 0L) {
            if (page.getKeyCount() == 0) {
                page.setChild(n, page3);
                this.removePage(page);
            } else {
                page.remove(n);
            }
        } else {
            page.setChild(n, page3);
        }
        return object2;
    }

    protected void newRoot(Page page) {
        if (this.root != page) {
            this.removeUnusedOldVersions();
            if (this.root.getVersion() != page.getVersion()) {
                ArrayList<Page> arrayList = this.oldRoots;
                if (arrayList.size() > 0) {
                    Page page2 = arrayList.get(arrayList.size() - 1);
                    if (page2.getVersion() != this.root.getVersion()) {
                        arrayList.add(this.root);
                    }
                } else {
                    arrayList.add(this.root);
                }
                this.store.markChanged(this);
            }
            this.root = page;
        }
    }

    public boolean hasUnsavedChanges() {
        return !this.oldRoots.isEmpty();
    }

    int compare(Object object, Object object2) {
        return this.keyType.compare(object, object2);
    }

    protected DataType getKeyType() {
        return this.keyType;
    }

    protected DataType getValueType() {
        return this.valueType;
    }

    Page readPage(long l) {
        return this.store.readPage(this, l);
    }

    void setRootPos(long l, long l2) {
        this.root = l == 0L ? Page.createEmpty(this, -1L) : this.readPage(l);
        this.root.setVersion(l2);
    }

    public Cursor<K> keyIterator(K k) {
        this.checkOpen();
        return new Cursor<K>(this, this.root, k);
    }

    public Iterator<K> changeIterator(long l) {
        this.checkOpen();
        MVMap<K, V> mVMap = this.openVersion(l);
        return new ChangeCursor(this, this.root, mVMap.root);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        for (K k : this.keySet()) {
            hashMap.put(k, this.get(k));
        }
        return hashMap.entrySet();
    }

    @Override
    public Set<K> keySet() {
        this.checkOpen();
        final MVMap mVMap = this;
        final Page page = this.root;
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Cursor<Object>(mVMap, page, null);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return MVMap.this.containsKey(object);
            }
        };
    }

    public Page getRoot() {
        return this.root;
    }

    String getName() {
        return this.name;
    }

    MVStore getStore() {
        return this.store;
    }

    int getId() {
        return this.id;
    }

    void rollbackTo(long l) {
        this.checkWrite();
        this.removeUnusedOldVersions();
        if (l <= this.createVersion) {
            this.removeMap();
        } else if (this.root.getVersion() >= l) {
            ArrayList<Page> arrayList = this.oldRoots;
            while (arrayList.size() > 0) {
                Page page;
                int n = arrayList.size() - 1;
                this.root = page = arrayList.get(n);
                arrayList.remove(n);
                if (page.getVersion() >= l) continue;
                break;
            }
        }
    }

    void removeAllOldVersions() {
        this.oldRoots = new ArrayList();
    }

    void removeUnusedOldVersions() {
        long l = this.store.getRetainVersion();
        if (l == -1L) {
            return;
        }
        int n = this.searchRoot(l);
        if (n < 0) {
            return;
        }
        ArrayList<Page> arrayList = new ArrayList<Page>();
        arrayList.addAll(this.oldRoots.subList(n, this.oldRoots.size()));
        this.oldRoots = arrayList;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException("This map is closed");
        }
    }

    protected void checkWrite() {
        if (this.readOnly) {
            this.checkOpen();
            throw new IllegalStateException("This map is read-only");
        }
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int size() {
        long l = this.getSize();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public long getSize() {
        return this.root.getTotalCount();
    }

    long getCreateVersion() {
        return this.createVersion;
    }

    protected void removePage(Page page) {
        this.store.removePage(page.getPos());
    }

    public MVMap<K, V> openVersion(long l) {
        if (this.readOnly) {
            throw new IllegalArgumentException("This map is read-only - need to call the method on the writable map");
        }
        if (l < this.createVersion) {
            throw new IllegalArgumentException("Unknown version");
        }
        Page page = null;
        Page page2 = this.root;
        if (page2.getVersion() <= l && page2.getVersion() >= 0L) {
            page = page2;
        } else {
            int n = this.searchRoot(l);
            if (n < 0) {
                if (n == -1) {
                    return this.store.openMapVersion(l, this.name, this);
                }
                n = -n - 2;
            }
            page = this.oldRoots.get(n);
        }
        MVMap<K, V> mVMap = this.openReadOnly();
        mVMap.root = page;
        return mVMap;
    }

    protected MVMap<K, V> openReadOnly() {
        MVMap<K, V> mVMap = new MVMap<K, V>(this.keyType, this.valueType);
        mVMap.readOnly = true;
        HashMap<String, String> hashMap = New.hashMap();
        hashMap.put("id", String.valueOf(this.id));
        hashMap.put("name", this.name);
        hashMap.put("createVersion", String.valueOf(this.createVersion));
        mVMap.open(this.store, hashMap);
        mVMap.root = this.root;
        return mVMap;
    }

    private int searchRoot(long l) {
        int n = 0;
        int n2 = this.oldRoots.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            long l2 = this.oldRoots.get(n3).getVersion();
            if (l2 < l) {
                n = n3 + 1;
                continue;
            }
            if (l < l2) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public long getVersion() {
        return this.root.getVersion();
    }

    protected int getChildPageCount(Page page) {
        return page.getChildPageCount();
    }

    public String getType() {
        return "btree";
    }

    public String asString() {
        StringBuilder stringBuilder = new StringBuilder();
        DataUtils.appendMap(stringBuilder, "id", this.id);
        DataUtils.appendMap(stringBuilder, "name", this.name);
        DataUtils.appendMap(stringBuilder, "type", this.getType());
        DataUtils.appendMap(stringBuilder, "createVersion", this.createVersion);
        if (this.keyType != null) {
            DataUtils.appendMap(stringBuilder, "key", this.keyType.asString());
        }
        if (this.valueType != null) {
            DataUtils.appendMap(stringBuilder, "value", this.valueType.asString());
        }
        return stringBuilder.toString();
    }
}

