/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.parser;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Interface;
import org.activiti.bpmn.model.Operation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceParser
implements BpmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)InterfaceParser.class.getName());

    public void parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        Interface interfaceObject = new Interface();
        BpmnXMLUtil.addXMLLocation((BaseElement)interfaceObject, xtr);
        interfaceObject.setId(model.getTargetNamespace() + ":" + xtr.getAttributeValue(null, "id"));
        interfaceObject.setName(xtr.getAttributeValue(null, "name"));
        interfaceObject.setImplementationRef(this.parseMessageRef(xtr.getAttributeValue(null, "implementationRef"), model));
        boolean readyWithInterface = false;
        Operation operation = null;
        try {
            while (!readyWithInterface && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "operation".equals(xtr.getLocalName())) {
                    operation = new Operation();
                    BpmnXMLUtil.addXMLLocation((BaseElement)operation, xtr);
                    operation.setId(model.getTargetNamespace() + ":" + xtr.getAttributeValue(null, "id"));
                    operation.setName(xtr.getAttributeValue(null, "name"));
                    operation.setImplementationRef(this.parseMessageRef(xtr.getAttributeValue(null, "implementationRef"), model));
                    continue;
                }
                if (xtr.isStartElement() && "inMessageRef".equals(xtr.getLocalName())) {
                    String inMessageRef = xtr.getElementText();
                    if (operation == null || !StringUtils.isNotEmpty((CharSequence)inMessageRef)) continue;
                    operation.setInMessageRef(this.parseMessageRef(inMessageRef.trim(), model));
                    continue;
                }
                if (xtr.isStartElement() && "outMessageRef".equals(xtr.getLocalName())) {
                    String outMessageRef = xtr.getElementText();
                    if (operation == null || !StringUtils.isNotEmpty((CharSequence)outMessageRef)) continue;
                    operation.setOutMessageRef(this.parseMessageRef(outMessageRef.trim(), model));
                    continue;
                }
                if (xtr.isEndElement() && "operation".equalsIgnoreCase(xtr.getLocalName())) {
                    if (operation == null || !StringUtils.isNotEmpty((CharSequence)operation.getImplementationRef())) continue;
                    interfaceObject.getOperations().add(operation);
                    continue;
                }
                if (!xtr.isEndElement() || !"interface".equals(xtr.getLocalName())) continue;
                readyWithInterface = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing interface child elements", (Throwable)e);
        }
        model.getInterfaces().add(interfaceObject);
    }

    protected String parseMessageRef(String messageRef, BpmnModel model) {
        String result = null;
        if (StringUtils.isNotEmpty((CharSequence)messageRef)) {
            int indexOfP = messageRef.indexOf(58);
            if (indexOfP != -1) {
                String prefix = messageRef.substring(0, indexOfP);
                String resolvedNamespace = model.getNamespace(prefix);
                result = resolvedNamespace + ":" + messageRef.substring(indexOfP + 1);
            } else {
                result = model.getTargetNamespace() + ":" + messageRef;
            }
        }
        return result;
    }
}

