/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem.athandler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smslib.GatewayException;
import org.smslib.InboundMessage;
import org.smslib.TimeoutException;
import org.smslib.modem.ModemGateway;
import org.smslib.modem.athandler.ATHandler_Wavecom;

public class ATHandler_Wavecom_Q2438F
extends ATHandler_Wavecom {
    public ATHandler_Wavecom_Q2438F(ModemGateway myGateway) {
        super(myGateway);
        this.setStorageLocations("MT");
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        String line = null;
        StringBuffer msgList = new StringBuffer();
        String listMsgRespons = super.listMessages(messageClass);
        BufferedReader reader = new BufferedReader(new StringReader(listMsgRespons));
        while ((line = reader.readLine()) != null) {
            if (!line.matches("^\\+CMGL:\\s*\\d+,.*")) continue;
            int memIndex = 0;
            int i = line.indexOf(58);
            int j = line.indexOf(44);
            memIndex = Integer.parseInt(line.substring(i + 1, j).trim());
            String oneMessage = this.getGateway().getMessageByIndex(memIndex);
            BufferedReader oneMessageReader = new BufferedReader(new StringReader(oneMessage));
            String header = oneMessageReader.readLine().trim();
            String headerRegex = "(^\\+CMGR:)(\\\"[^\\\"]+\\\",)(\\\"[^\\\"]+\\\",)(\\\"[^,]+,)(\\d+)\\s+(:\\d+)\\s+(:\\d+\\\")(,\\d,)(\\d)";
            Pattern headerPattern = Pattern.compile(headerRegex);
            Matcher headerMatcher = headerPattern.matcher(header);
            header = headerMatcher.replaceAll("$1 " + memIndex + ",$2$3,$4$5$6$7$8$9");
            char encoding = headerMatcher.replaceAll("$9").charAt(0);
            StringBuffer msgContent = new StringBuffer();
            String bodyLine = "";
            while ((bodyLine = oneMessageReader.readLine()) != null) {
                if ((bodyLine = bodyLine.trim()).length() <= 0 || bodyLine.equalsIgnoreCase("OK")) continue;
                msgContent.append(bodyLine);
            }
            String msgContentStr = msgContent.toString();
            if (encoding == '4') {
                char[] unicodeText = msgContentStr.toCharArray();
                msgContentStr = new String(unicodeText);
            }
            String msgText = header + "\r" + msgContentStr + "\r";
            msgList.append(msgText);
        }
        reader.close();
        return msgList.toString();
    }

    @Override
    public String getManufacturer() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+WGMI\r");
        return this.getModemDriver().getResponse().replaceAll("\\+WGMI: ", "");
    }

    @Override
    public String getModel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+WGMM\r");
        return this.getModemDriver().getResponse().replaceAll("\\+WGMM: ", "");
    }

    @Override
    public String getSimStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+WPIN?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public boolean enterPin(String pin) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+WPIN=3,_1_\r".replaceAll("_1_", pin));
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    @Override
    public String getBatteryLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CBC?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGSN\r");
        return this.getModemDriver().getResponse().replaceAll("\\+CGSN: ", "");
    }

    @Override
    public boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CSCS=\"CDMA\"\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }
}

