// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>The <A HREF='ProcessingInstruction.html'><CODE>ProcessingInstruction</CODE></A> interface
      represents a  "processing instruction", used in XML
      as a way to keep processor-specific information in the text of the
      document.

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-target><CODE>&nbsp;target</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTarget()'>getTarget</a>
</TD>
<TD><P>The target of this processing instruction. XML defines this as
	being the first token following the markup that begins the processing
	instruction.
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-data><CODE>&nbsp;data</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getData()'>getData</a>
<a href='#setData(java.lang.String)'>setData</a>
</TD>
<TD><P>The content of this processing instruction. This
	is from the first non white space character after the target
	to the character immediately preceding the <code>?&gt;</code>.
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface ProcessingInstruction
extends Node
{
	/**
	 * Returns the value of the <code><a href=#att-target>target</a></code> property.
	*/
	String getTarget ();


	/** Assigns the value of the <code><a href=#att-data>data</a></code> property.
	 * @exception DOMException <P>NO_MODIFICATION_ALLOWED_ERR: Raised when the node is
	    readonly.

 */
	void setData (String data) throws DOMException;

	/**
	 * Returns the value of the <code><a href=#att-data>data</a></code> property.
	*/
	String getData ();


}
