/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.user.SimpSession;
import org.springframework.messaging.simp.user.SimpSubscription;
import org.springframework.messaging.simp.user.SimpSubscriptionMatcher;
import org.springframework.messaging.simp.user.SimpUser;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class MultiServerUserRegistry
implements SimpUserRegistry,
SmartApplicationListener {
    private final String id;
    private final SimpUserRegistry localRegistry;
    private final SmartApplicationListener listener;
    private final Map<String, UserRegistryDto> remoteRegistries = new ConcurrentHashMap<String, UserRegistryDto>();

    public MultiServerUserRegistry(SimpUserRegistry localRegistry) {
        Assert.notNull((Object)localRegistry, (String)"'localRegistry' is required.");
        this.localRegistry = localRegistry;
        this.listener = this.localRegistry instanceof SmartApplicationListener ? (SmartApplicationListener)this.localRegistry : new NoOpSmartApplicationListener();
        this.id = MultiServerUserRegistry.generateId();
    }

    private static String generateId() {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            host = "unknown";
        }
        return host + "-" + UUID.randomUUID();
    }

    @Override
    public SimpUser getUser(String userName) {
        SimpUser user = this.localRegistry.getUser(userName);
        if (user != null) {
            return user;
        }
        for (UserRegistryDto registry : this.remoteRegistries.values()) {
            user = registry.getUsers().get(userName);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    @Override
    public Set<SimpUser> getUsers() {
        HashSet<SimpUser> result = new HashSet<SimpUser>(this.localRegistry.getUsers());
        for (UserRegistryDto registry : this.remoteRegistries.values()) {
            result.addAll(registry.getUsers().values());
        }
        return result;
    }

    @Override
    public Set<SimpSubscription> findSubscriptions(SimpSubscriptionMatcher matcher) {
        HashSet<SimpSubscription> result = new HashSet<SimpSubscription>(this.localRegistry.findSubscriptions(matcher));
        for (UserRegistryDto registry : this.remoteRegistries.values()) {
            result.addAll(registry.findSubscriptions(matcher));
        }
        return result;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return this.listener.supportsEventType(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return this.listener.supportsSourceType(sourceType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        this.listener.onApplicationEvent(event);
    }

    public int getOrder() {
        return this.listener.getOrder();
    }

    Object getLocalRegistryDto() {
        return new UserRegistryDto(this.id, this.localRegistry);
    }

    void addRemoteRegistryDto(Message<?> message, MessageConverter converter, long expirationPeriod) {
        UserRegistryDto registryDto = (UserRegistryDto)converter.fromMessage(message, UserRegistryDto.class);
        if (registryDto != null && !registryDto.getId().equals(this.id)) {
            long expirationTime = System.currentTimeMillis() + expirationPeriod;
            registryDto.setExpirationTime(expirationTime);
            registryDto.restoreParentReferences();
            this.remoteRegistries.put(registryDto.getId(), registryDto);
        }
    }

    void purgeExpiredRegistries() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<String, UserRegistryDto>> iterator = this.remoteRegistries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, UserRegistryDto> entry = iterator.next();
            if (now <= entry.getValue().getExpirationTime()) continue;
            iterator.remove();
        }
    }

    public String toString() {
        return "local=[" + this.localRegistry + "], remote=" + this.remoteRegistries + "]";
    }

    private static class NoOpSmartApplicationListener
    implements SmartApplicationListener {
        private NoOpSmartApplicationListener() {
        }

        public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
            return false;
        }

        public boolean supportsSourceType(Class<?> sourceType) {
            return false;
        }

        public void onApplicationEvent(ApplicationEvent event) {
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }
    }

    private static class SimpSubscriptionDto
    implements SimpSubscription {
        private String id;
        private SimpSessionDto session;
        private String destination;

        public SimpSubscriptionDto() {
        }

        public SimpSubscriptionDto(SimpSubscription subscription) {
            this.id = subscription.getId();
            this.destination = subscription.getDestination();
        }

        @Override
        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public SimpSessionDto getSession() {
            return this.session;
        }

        public void setSession(SimpSessionDto session) {
            this.session = session;
        }

        @Override
        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public int hashCode() {
            return 31 * this.id.hashCode() + ObjectUtils.nullSafeHashCode((Object)this.getSession());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof SimpSubscription)) {
                return false;
            }
            SimpSubscription otherSubscription = (SimpSubscription)other;
            return ObjectUtils.nullSafeEquals((Object)this.getSession(), (Object)otherSubscription.getSession()) && this.id.equals(otherSubscription.getId());
        }

        public String toString() {
            return "destination=" + this.destination;
        }
    }

    private static class SimpSessionDto
    implements SimpSession {
        private String id;
        private SimpUserDto user;
        private Set<SimpSubscriptionDto> subscriptions;

        public SimpSessionDto() {
            this.subscriptions = new HashSet<SimpSubscriptionDto>(4);
        }

        public SimpSessionDto(SimpSession session) {
            this.id = session.getId();
            Set<SimpSubscription> subscriptions = session.getSubscriptions();
            this.subscriptions = new HashSet<SimpSubscriptionDto>(subscriptions.size());
            for (SimpSubscription subscription : subscriptions) {
                this.subscriptions.add(new SimpSubscriptionDto(subscription));
            }
        }

        @Override
        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public SimpUserDto getUser() {
            return this.user;
        }

        public void setUser(SimpUserDto user) {
            this.user = user;
        }

        @Override
        public Set<SimpSubscription> getSubscriptions() {
            return new HashSet<SimpSubscription>(this.subscriptions);
        }

        public void setSubscriptions(Set<SimpSubscriptionDto> subscriptions) {
            this.subscriptions.addAll(subscriptions);
        }

        private void restoreParentReferences() {
            for (SimpSubscriptionDto subscription : this.subscriptions) {
                subscription.setSession(this);
            }
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof SimpSession)) {
                return false;
            }
            return this.id.equals(((SimpSession)other).getId());
        }

        public String toString() {
            return "id=" + this.id + ", subscriptions=" + this.subscriptions;
        }
    }

    private static class SimpUserDto
    implements SimpUser {
        private String name;
        private Set<SimpSessionDto> sessions;

        public SimpUserDto() {
            this.sessions = new HashSet<SimpSessionDto>(1);
        }

        public SimpUserDto(SimpUser user) {
            this.name = user.getName();
            Set<SimpSession> sessions = user.getSessions();
            this.sessions = new HashSet<SimpSessionDto>(sessions.size());
            for (SimpSession session : sessions) {
                this.sessions.add(new SimpSessionDto(session));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public boolean hasSessions() {
            return !this.sessions.isEmpty();
        }

        @Override
        public Set<SimpSession> getSessions() {
            return new HashSet<SimpSession>(this.sessions);
        }

        public void setSessions(Set<SimpSessionDto> sessions) {
            this.sessions.addAll(sessions);
        }

        @Override
        public SimpSessionDto getSession(String sessionId) {
            for (SimpSessionDto session : this.sessions) {
                if (!session.getId().equals(sessionId)) continue;
                return session;
            }
            return null;
        }

        private void restoreParentReferences() {
            for (SimpSessionDto session : this.sessions) {
                session.setUser(this);
                session.restoreParentReferences();
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof SimpUser)) {
                return false;
            }
            return this.name.equals(((SimpUser)other).getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "name=" + this.name + ", sessions=" + this.sessions;
        }
    }

    private static class UserRegistryDto {
        private String id;
        private Map<String, SimpUserDto> users;
        private long expirationTime;

        public UserRegistryDto() {
        }

        public UserRegistryDto(String id, SimpUserRegistry registry) {
            this.id = id;
            Set<SimpUser> users = registry.getUsers();
            this.users = new HashMap<String, SimpUserDto>(users.size());
            for (SimpUser user : users) {
                this.users.put(user.getName(), new SimpUserDto(user));
            }
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setUsers(Map<String, SimpUserDto> users) {
            this.users = users;
        }

        public Map<String, SimpUserDto> getUsers() {
            return this.users;
        }

        public Set<SimpSubscription> findSubscriptions(SimpSubscriptionMatcher matcher) {
            HashSet<SimpSubscription> result = new HashSet<SimpSubscription>();
            for (SimpUserDto user : this.users.values()) {
                for (SimpSessionDto session : user.sessions) {
                    for (SimpSubscription subscription : session.subscriptions) {
                        if (!matcher.match(subscription)) continue;
                        result.add(subscription);
                    }
                }
            }
            return result;
        }

        public void setExpirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        private void restoreParentReferences() {
            for (SimpUserDto user : this.users.values()) {
                user.restoreParentReferences();
            }
        }

        public String toString() {
            return "id=" + this.id + ", users=" + this.users;
        }
    }
}

