/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.navigation;

import net.sf.sojo.navigation.PathAction;
import net.sf.sojo.navigation.PathParseException;

public class PathParser {
    public static PathAction[] parse(String pvParth) {
        PathAction[] lvPathAction = null;
        if (pvParth == null) {
            lvPathAction = new PathAction[]{};
        } else {
            String[] lvPathArray = pvParth.split("\\.");
            lvPathAction = new PathAction[lvPathArray.length];
            for (int i = 0; i < lvPathArray.length; ++i) {
                PathAction lvAction;
                String lvPath = lvPathArray[i];
                if (lvPath.trim().length() <= 0) continue;
                lvPathAction[i] = lvAction = PathParser.getActionByPath(lvPath);
            }
            if (pvParth.indexOf(".") < 0 && pvParth.trim().length() > 0) {
                PathAction lvAction = PathParser.getActionByPath(pvParth.trim());
                lvPathAction = new PathAction[]{lvAction};
            }
        }
        lvPathAction = PathParser.removeEmptyActions(lvPathAction);
        return lvPathAction;
    }

    protected static int testBrackets(String pvPath, String pvOpen, String pvClosed) {
        int lvIndexClosedBracket = pvPath.indexOf(pvClosed);
        int lvIndexOpenBracket = pvPath.indexOf(pvOpen);
        int lvIndexOpenBracketLast = pvPath.lastIndexOf(pvOpen);
        int l = pvPath.length() - 1;
        if (lvIndexOpenBracket < 0) {
            throw new PathParseException("Missing open bracket '" + pvOpen + "' in path: " + pvPath);
        }
        if (lvIndexOpenBracket != lvIndexOpenBracketLast) {
            throw new PathParseException("In the path is only one open bracket '" + pvOpen + "' allowed: " + pvPath);
        }
        if (lvIndexClosedBracket != l) {
            throw new PathParseException("In the path is only one closed bracket '" + pvClosed + "' allowed: " + pvPath);
        }
        return lvIndexOpenBracket;
    }

    public static PathAction getActionByPath(String pvPath) {
        int lvActionType = 0;
        PathAction lvPathAction = new PathAction();
        lvPathAction.setPath(pvPath);
        if (pvPath.indexOf(")") > 0) {
            int x = PathParser.testBrackets(pvPath, "(", ")");
            String lvPropertyName = pvPath.substring(0, x);
            String lvKey = pvPath.substring(x + 1, pvPath.length() - 1);
            if (lvPropertyName != null && lvPropertyName.length() > 0) {
                lvPathAction.setProperty(lvPropertyName);
            }
            lvPathAction.setKey(lvKey);
            lvActionType = 2;
        } else if (pvPath.indexOf("]") > 0) {
            int x = PathParser.testBrackets(pvPath, "[", "]");
            String lvPropertyName = pvPath.substring(0, x);
            String lvIndex = pvPath.substring(x + 1, pvPath.length() - 1);
            if (lvPropertyName != null && lvPropertyName.length() > 0) {
                lvPathAction.setProperty(lvPropertyName);
            }
            if (lvIndex.length() > 0) {
                try {
                    Integer lvIndexInt = Integer.valueOf(lvIndex.trim());
                    lvPathAction.setIndex(lvIndexInt);
                }
                catch (Exception e) {
                    throw new PathParseException("The index must be a integer and not: " + lvIndex);
                }
            }
            lvActionType = 1;
        } else {
            lvPathAction.setProperty(pvPath);
        }
        lvPathAction.setType(lvActionType);
        return lvPathAction;
    }

    public static PathAction[] removeEmptyActions(PathAction[] pvActions) {
        int lvNumberOfNullValues = 0;
        for (int i = 0; i < pvActions.length; ++i) {
            if (pvActions[i] != null) continue;
            ++lvNumberOfNullValues;
        }
        PathAction[] lvNewPathAction = new PathAction[pvActions.length - lvNumberOfNullValues];
        for (int i = 0; i < pvActions.length; ++i) {
            if (pvActions[i] == null) continue;
            lvNewPathAction[i] = pvActions[i];
        }
        return lvNewPathAction;
    }
}

