/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.filter;

import java.util.HashMap;
import java.util.Map;
import net.sf.sojo.core.filter.ClassPropertyFilter;
import net.sf.sojo.core.filter.ClassPropertyFilterHandler;
import net.sf.sojo.core.filter.ClassPropertyFilterHelper;

public class ClassPropertyFilterHandlerImpl
implements ClassPropertyFilterHandler {
    private Map<Class<?>, ClassPropertyFilter> classPropertyFilterMap = new HashMap();
    private boolean withAssignableFilterClasses = true;

    public ClassPropertyFilterHandlerImpl() {
    }

    public ClassPropertyFilterHandlerImpl(ClassPropertyFilter pvFilter) {
        this.addClassPropertyFilter(pvFilter);
    }

    public ClassPropertyFilterHandlerImpl(Class<?>[] pvClassPropertyFilterClasses) {
        this.addClassPropertyFilterByFilterClasses(pvClassPropertyFilterClasses);
    }

    public void setWithAssignableFilterClasses(boolean pvWithAssignableFilterClasses) {
        this.withAssignableFilterClasses = pvWithAssignableFilterClasses;
    }

    public boolean getWithAssignableFilterClasses() {
        return this.withAssignableFilterClasses;
    }

    public void addClassPropertyFilterByFilterClasses(Class<?>[] pvClassPropertyFilterClasses) {
        if (pvClassPropertyFilterClasses != null) {
            for (Class<?> cls : pvClassPropertyFilterClasses) {
                ClassPropertyFilter lvFilter = ClassPropertyFilterHelper.createClassPropertyFilterByClass(cls);
                this.addClassPropertyFilter(lvFilter);
            }
        }
    }

    public void addClassPropertyFilter(ClassPropertyFilter pvClassPropertyFilter) {
        this.classPropertyFilterMap.put(pvClassPropertyFilter.getFilterClass(), pvClassPropertyFilter);
    }

    public void removeClassPropertyFilterByClassName(Class<?> pvFilterClass) {
        this.classPropertyFilterMap.remove(pvFilterClass);
    }

    @Override
    public ClassPropertyFilter getClassPropertyFilterByClass(Class<?> pvFilterClass) {
        if (this.withAssignableFilterClasses) {
            for (Map.Entry<Class<?>, ClassPropertyFilter> lvEntry : this.classPropertyFilterMap.entrySet()) {
                Class<?> lvClass = lvEntry.getKey();
                if (!lvClass.isAssignableFrom(pvFilterClass)) continue;
                return lvEntry.getValue();
            }
            return null;
        }
        return this.classPropertyFilterMap.get(pvFilterClass);
    }

    public int getClassPropertyFilterSize() {
        return this.classPropertyFilterMap.size();
    }
}

