/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.conversion;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.sojo.core.IConverter;
import net.sf.sojo.core.IConverterExtension;
import net.sf.sojo.core.IterableConversion;
import net.sf.sojo.core.reflect.ReflectionHelper;

public class IterateableMap2MapConversion
extends IterableConversion {
    public static final Class<?> DEFAULT_MAP_TYPE = LinkedHashMap.class;

    public IterateableMap2MapConversion() {
        this(null, false);
    }

    public IterateableMap2MapConversion(Class<?> pvNewIteratableType) {
        this(pvNewIteratableType, false);
    }

    public IterateableMap2MapConversion(Class<?> pvNewIteratableType, boolean pvIgnoreNullValues) {
        this.newIteratableType = pvNewIteratableType;
        if (this.newIteratableType == null) {
            this.newIteratableType = DEFAULT_MAP_TYPE;
        }
        this.validateTargetIteratableType(this.newIteratableType);
        this.setIgnoreNullValues(pvIgnoreNullValues);
    }

    private void validateTargetIteratableType(Class<?> pvIteratableType) {
        if (!Map.class.isAssignableFrom(pvIteratableType)) {
            throw new IllegalArgumentException("The class: " + pvIteratableType + " must be implements the java.util.Map interface.");
        }
        if (pvIteratableType.isInterface()) {
            throw new IllegalArgumentException("The class: " + pvIteratableType + " must be a implementation and not an interface.");
        }
    }

    @Override
    public boolean isAssignableFrom(Object pvObject) {
        boolean lvReturn = false;
        if (ReflectionHelper.isMapType(pvObject) && !ReflectionHelper.isComplexMapType(pvObject)) {
            lvReturn = true;
        }
        return lvReturn;
    }

    @Override
    public boolean isAssignableTo(Class<?> pvToType) {
        return ReflectionHelper.isMapType(pvToType);
    }

    @Override
    public Object convert(Object pvObject, Class<?> pvToType, IConverterExtension pvConverter) {
        Class<?> lvToType = pvToType == null || pvToType.isInterface() ? this.newIteratableType : pvToType;
        Map lvOldMap = (Map)pvObject;
        Map lvNewMap = (Map)ReflectionHelper.createNewIterableInstance(lvToType, lvOldMap.size());
        Iterator iter = lvOldMap.entrySet().iterator();
        return super.iterate(pvObject, lvNewMap, iter, pvConverter);
    }

    @Override
    protected Object[] doTransformIteratorObject2KeyValuePair(Object pvIteratorObject) {
        Map.Entry lvMapEntry = (Map.Entry)pvIteratorObject;
        Object lvKey = lvMapEntry.getKey();
        Object lvValue = lvMapEntry.getValue();
        return new Object[]{lvKey, lvValue};
    }

    @Override
    protected Object[] doConvert(Object pvSourceObject, Object pvNewTargetObject, Object pvKey, Object pvValue, IConverter pvConverter) {
        Object lvKey = pvConverter.convert(pvKey);
        Object lvValue = pvConverter.convert(pvValue);
        return new Object[]{lvKey, lvValue};
    }

    @Override
    protected void doAddObject(Object pvSourceObject, Object pvNewTargetObject, Object pvKey, Object pvValue, int pvIteratorPosition) {
        Map lvNewMap = (Map)pvNewTargetObject;
        lvNewMap.put(pvKey, pvValue);
    }
}

