/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.conversion;

import java.lang.reflect.AccessibleObject;
import java.util.Iterator;
import java.util.Map;
import net.sf.sojo.core.ConversionException;
import net.sf.sojo.core.IConverter;
import net.sf.sojo.core.IConverterExtension;
import net.sf.sojo.core.conversion.IterateableMap2MapConversion;
import net.sf.sojo.core.reflect.Property;
import net.sf.sojo.core.reflect.ReflectionHelper;
import net.sf.sojo.core.reflect.ReflectionPropertyHelper;

public class IterateableMap2BeanConversion
extends IterateableMap2MapConversion {
    private Class<?> toType = null;

    @Override
    public boolean isAssignableFrom(Object pvObject) {
        boolean lvReturn = false;
        if (pvObject != null && this.toType != null) {
            lvReturn = ReflectionHelper.isComplexType(this.toType);
        }
        if (!lvReturn) {
            lvReturn = ReflectionHelper.isComplexMapType(pvObject);
        }
        this.toType = null;
        return lvReturn;
    }

    @Override
    public boolean isAssignableTo(Class<?> pvToType) {
        this.toType = pvToType;
        return ReflectionHelper.isComplexMapType(pvToType);
    }

    @Override
    public Object convert(Object pvObject, Class<?> pvToType, IConverterExtension pvConverter) {
        Map lvOldMap = (Map)pvObject;
        Object beanObject = null;
        try {
            beanObject = ReflectionHelper.createBeanFromMap(lvOldMap, pvToType);
        }
        catch (Exception e) {
            throw new ConversionException(e.getMessage(), e);
        }
        String lvUniqueId = (String)lvOldMap.get("~unique-id~");
        if (lvUniqueId != null) {
            pvConverter.addObject(lvUniqueId, beanObject);
        }
        String[] lvFilter = lvOldMap.keySet().toArray(new String[0]);
        Map<?, ?> lvSetterMap = ReflectionPropertyHelper.getAllSetterProperties(beanObject.getClass(), lvFilter);
        Iterator<Map.Entry<?, ?>> iter = lvSetterMap.entrySet().iterator();
        Object lvReturn = super.iterate(pvObject, beanObject, iter, pvConverter);
        return lvReturn;
    }

    @Override
    protected Object[] doConvert(Object pvSourceObject, Object pvNewTargetObject, Object pvKey, Object pvValue, IConverter pvConverter) {
        Object lvReturnValue = null;
        AccessibleObject lvAccessibleObject = (AccessibleObject)pvValue;
        Property lvProperty = new Property(lvAccessibleObject);
        Class<?> lvParamType = lvProperty.getParameterType();
        Map lvMap = (Map)pvSourceObject;
        Object lvValue = lvMap.get(pvKey);
        if (lvValue != null && lvValue.toString().startsWith("~unique-id~")) {
            String lvKey = lvValue.toString().substring("~unique-id~".length());
            lvReturnValue = ((IConverterExtension)pvConverter).getObjectByUniqueId(lvKey);
        } else {
            lvReturnValue = pvConverter.convert(lvValue, lvParamType);
        }
        try {
            if (lvReturnValue != null) {
                Class<?> lvClass = ReflectionHelper.mapFromSimpeToWrapper(lvReturnValue.getClass());
                Class<?> lvParamClass = ReflectionHelper.mapFromSimpeToWrapper(lvParamType);
                if (!lvParamClass.isAssignableFrom(lvClass) && !lvParamClass.isAssignableFrom((lvReturnValue = ReflectionHelper.createNewSimpleObject(lvParamClass, lvReturnValue)).getClass())) {
                    throw new ConversionException("Can't execute property: " + lvAccessibleObject + ". Parameter are not assignable: " + lvParamClass + " <--> " + lvClass + " and value: " + lvReturnValue);
                }
            }
            lvProperty.executeSetValue(pvNewTargetObject, lvReturnValue);
        }
        catch (Exception e) {
            if (e instanceof ConversionException) {
                throw (ConversionException)e;
            }
            throw new ConversionException("Can't invoke set property: " + lvAccessibleObject + " with arg: " + lvReturnValue, e);
        }
        return new Object[]{pvKey, lvReturnValue};
    }

    @Override
    protected void doAddObject(Object pvSourceObject, Object pvNewTargetObject, Object pvKey, Object pvValue, int pvIteratorPosition) {
    }
}

