/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.conversion;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.sojo.core.ConversionException;
import net.sf.sojo.core.IConverter;
import net.sf.sojo.core.IConverterExtension;
import net.sf.sojo.core.IterableConversion;
import net.sf.sojo.core.reflect.ReflectionHelper;
import net.sf.sojo.util.ArrayIterator;

public class Iterateable2IterateableConversion
extends IterableConversion {
    public static final Class<?> DEFAULT_COLLECTION_TYPE = ArrayList.class;

    public Iterateable2IterateableConversion() {
        this(null);
    }

    public Iterateable2IterateableConversion(Class<?> pvNewIteratableType) {
        this.newIteratableType = pvNewIteratableType;
        if (this.newIteratableType == null) {
            this.newIteratableType = DEFAULT_COLLECTION_TYPE;
        }
        this.validateTargetIteratableType(this.newIteratableType);
    }

    private void validateTargetIteratableType(Class<?> pvIteratableType) {
        if (!Collection.class.isAssignableFrom(pvIteratableType)) {
            throw new IllegalArgumentException("The class: " + pvIteratableType + " must be implements the java.util.Collection interface.");
        }
        if (pvIteratableType.isInterface()) {
            throw new IllegalArgumentException("The class: " + pvIteratableType + " must be a implementation and not an interface.");
        }
    }

    @Override
    public final boolean isAssignableFrom(Object pvObject) {
        return ReflectionHelper.isIterableType(pvObject);
    }

    @Override
    public boolean isAssignableTo(Class<?> pvToType) {
        return ReflectionHelper.isIterateableType(pvToType);
    }

    @Override
    public Object convert(Object pvObject, Class<?> pvToType, IConverterExtension pvConverter) {
        Iterator<Object> it = null;
        int size = 0;
        if (pvObject.getClass().isArray()) {
            it = new ArrayIterator(pvObject);
            size = it.getLength();
        } else {
            Collection lvOldList = (Collection)pvObject;
            size = lvOldList.size();
            it = lvOldList.iterator();
        }
        Object lvNewTargetType = null;
        if (pvToType != null && pvToType.isArray()) {
            int lvSize = 0;
            if (pvObject instanceof Collection) {
                Collection lvOldList = (Collection)pvObject;
                lvSize = lvOldList.size();
            } else {
                Object[] lvObjectArray = (Object[])pvObject;
                lvSize = lvObjectArray.length;
            }
            lvNewTargetType = Array.newInstance(pvToType.getComponentType(), lvSize);
        } else {
            Class<Set> lvToType = pvToType == null || pvToType.isInterface() ? this.newIteratableType : pvToType;
            lvNewTargetType = pvToType != null && pvToType.isAssignableFrom(Set.class) && !lvToType.isAssignableFrom(Set.class) && pvObject instanceof Collection ? ReflectionHelper.createNewIterableInstance(HashSet.class, size) : ReflectionHelper.createNewIterableInstance(lvToType, size);
        }
        return super.iterate(pvObject, lvNewTargetType, it, pvConverter);
    }

    @Override
    protected Object[] doTransformIteratorObject2KeyValuePair(Object pvIteratorObject) {
        return new Object[]{null, pvIteratorObject};
    }

    @Override
    protected Object[] doConvert(Object pvSourceObject, Object pvNewTargetObject, Object pvKey, Object pvValue, IConverter pvConverter) {
        Object lvValueAfterConvert = pvConverter.convert(pvValue);
        return new Object[]{null, lvValueAfterConvert};
    }

    @Override
    protected void doAddObject(Object pvSourceObject, Object pvNewTargetObject, Object pvKey, Object pvValue, int pvIteratorPosition) {
        if (!pvNewTargetObject.getClass().isArray()) {
            Collection lvCollection = (Collection)pvNewTargetObject;
            lvCollection.add(pvValue);
        } else {
            try {
                Class<?> clazz = pvNewTargetObject.getClass().getComponentType();
                if (pvValue != null && !pvValue.getClass().equals(clazz)) {
                    pvValue = ReflectionHelper.createNewSimpleObject(clazz, pvValue);
                }
            }
            catch (InstantiationException e) {
                throw new ConversionException(e.getMessage(), e);
            }
            Array.set(pvNewTargetObject, pvIteratorPosition, pvValue);
        }
    }
}

