/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json.writer.sojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.sojo.common.ObjectUtil;
import net.sf.sojo.common.WalkerInterceptor;
import net.sf.sojo.core.Conversion;
import net.sf.sojo.core.conversion.ComplexBean2MapConversion;
import net.sf.sojo.core.filter.ClassPropertyFilterHandler;
import net.sf.sojo.core.reflect.ReflectionHelper;
import net.sf.sojo.util.ArrayIterator;

public class MapGraphWalker {
    private List interceptorList = new ArrayList();
    private ObjectUtil objectUtil = new ObjectUtil(false);
    private int numberOfRecursion = 0;
    private boolean ignoreNullValues = true;
    private String[] excludedProperties = null;
    private String objectName;

    public MapGraphWalker() {
        this.setIgnoreNullValues(true);
    }

    public MapGraphWalker(ClassPropertyFilterHandler pvFilterHandler) {
        this();
        this.objectUtil.setClassPropertyFilterHandler(pvFilterHandler);
    }

    public ObjectUtil getObjectUtil() {
        return this.objectUtil;
    }

    public void setExcludedProperties(String[] pvExcludedProperties) {
        this.excludedProperties = pvExcludedProperties;
    }

    public void setIgnoreNullValues(boolean pvBoolean) {
        this.ignoreNullValues = pvBoolean;
        ComplexBean2MapConversion lvBean2MapConversion = new ComplexBean2MapConversion();
        lvBean2MapConversion.setIgnoreNullValues(this.ignoreNullValues);
        this.objectUtil.getConverter().replaceConversion((Conversion)lvBean2MapConversion);
    }

    public void addInterceptor(WalkerInterceptor pvInterceptor) {
        this.interceptorList.add(pvInterceptor);
    }

    public int getInterceptorSize() {
        return this.interceptorList.size();
    }

    public void removeInterceptorByNumber(int pvPosition) {
        this.interceptorList.remove(pvPosition);
    }

    private boolean fireVisitElementEvent(Object pvKey, int pvIndex, Object pvValue, int pvType, String pvPath, int pvNumberOfRecursion) {
        for (int i = 0; i < this.interceptorList.size(); ++i) {
            boolean b = ((WalkerInterceptor)this.interceptorList.get(i)).visitElement(pvKey, pvIndex, pvValue, pvType, pvPath, pvNumberOfRecursion);
            if (!b) continue;
            return true;
        }
        return false;
    }

    private void fireVisitIterateableElement(Object pvValue, int pvType, String pvPath, int pvBeginEnd) {
        for (int i = 0; i < this.interceptorList.size(); ++i) {
            ((WalkerInterceptor)this.interceptorList.get(i)).visitIterateableElement(pvValue, pvType, pvPath, pvBeginEnd);
        }
    }

    private void fireStartWalk(Object pvStartObject) {
        for (int i = 0; i < this.interceptorList.size(); ++i) {
            ((WalkerInterceptor)this.interceptorList.get(i)).startWalk(pvStartObject);
        }
    }

    private void fireEndWalk() {
        for (int i = 0; i < this.interceptorList.size(); ++i) {
            ((WalkerInterceptor)this.interceptorList.get(i)).endWalk();
        }
    }

    public int getNumberOfRecursion() {
        return this.numberOfRecursion;
    }

    public void walk(Object pvObject) {
        this.numberOfRecursion = 0;
        this.fireStartWalk(pvObject);
        this.walkInternal(null, -1, pvObject, "");
        this.fireEndWalk();
    }

    public String removeLastPointOnPath(String pvPath) {
        String lvPath = pvPath;
        if (lvPath.endsWith(".")) {
            lvPath = lvPath.substring(0, lvPath.length() - 1);
        }
        return lvPath;
    }

    public boolean isPropertyExcluded(String property) {
        String prob = this.removeLastPointOnPath(property);
        if (this.excludedProperties == null || this.excludedProperties.length == 0) {
            return false;
        }
        for (String excluded : this.excludedProperties) {
            if (excluded != null && excluded.equals(prob)) {
                return true;
            }
            if (excluded.startsWith("(") || !("(" + this.objectName + ")." + excluded).equals(prob)) continue;
            return true;
        }
        return false;
    }

    private void walkInternal(Object pvKey, int pvIndex, Object pvValue, String pvPath) {
        ++this.numberOfRecursion;
        if (!this.isPropertyExcluded(pvPath)) {
            if (pvValue == null) {
                this.fireVisitElementEvent(pvKey, pvIndex, null, 0, this.removeLastPointOnPath(pvPath), this.numberOfRecursion);
            } else if (ReflectionHelper.isSimpleType((Object)pvValue)) {
                this.fireVisitElementEvent(pvKey, pvIndex, pvValue, 1, this.removeLastPointOnPath(pvPath), this.numberOfRecursion);
            } else if (ReflectionHelper.isMapType((Object)pvValue)) {
                Map lvMap = (Map)pvValue;
                boolean lvCancel = this.fireVisitElementEvent(pvKey, pvIndex, pvValue, 9, pvPath + "()", this.numberOfRecursion);
                if (ReflectionHelper.isComplexMapType((Object)pvValue)) {
                    if (pvPath.length() > 0 && !pvPath.endsWith(".")) {
                        pvPath = pvPath + ".";
                    }
                    this.mapWalker(lvMap, pvPath, false, lvCancel);
                } else {
                    this.mapWalker(lvMap, pvPath, true, lvCancel);
                }
            } else if (ReflectionHelper.isIterateableType((Object)pvValue)) {
                boolean lvCancel = this.fireVisitElementEvent(pvKey, pvIndex, pvValue, 7, pvPath + "[]", this.numberOfRecursion);
                this.iteratorWalker(pvValue, pvPath, lvCancel);
            } else {
                pvPath = this.removeLastPointOnPath(pvPath);
                Object lvSimple = this.objectUtil.makeSimple(pvValue, this.excludedProperties);
                if ("".equals(pvKey) || pvKey == null) {
                    this.walkInternal(null, -1, lvSimple, pvPath);
                } else {
                    this.walkInternal(pvKey, -1, lvSimple, pvPath);
                }
            }
        }
    }

    private void iteratorWalker(Object pvValue, String pvPath, boolean pvCancel) {
        if (!this.isPropertyExcluded(pvPath) && !pvCancel) {
            int lvIndex = -1;
            Object lvIterator = null;
            if (pvValue.getClass().isArray()) {
                lvIterator = new ArrayIterator(pvValue);
            } else {
                Collection lvCollection = (Collection)pvValue;
                lvIterator = lvCollection.iterator();
            }
            this.fireVisitIterateableElement(pvValue, 7, pvPath, 1);
            while (lvIterator.hasNext()) {
                Object o = lvIterator.next();
                StringBuffer sb = new StringBuffer(pvPath);
                sb.append("[").append(++lvIndex).append("]");
                sb.append(".");
                this.walkInternal(null, lvIndex, o, sb.toString());
            }
            this.fireVisitIterateableElement(pvValue, 7, pvPath, 2);
        }
    }

    private void mapWalker(Map pvMap, String pvPath, boolean pvWithBrackets, boolean pvCancel) {
        if (!this.isPropertyExcluded(pvPath) && !pvCancel) {
            this.fireVisitIterateableElement(pvMap, 9, pvPath, 1);
            for (Map.Entry lvEntry : pvMap.entrySet()) {
                Object lvKey = lvEntry.getKey();
                Object lvValue = lvEntry.getValue();
                StringBuffer sb = new StringBuffer(pvPath);
                if (pvWithBrackets) {
                    sb.append("(").append(lvKey).append(")");
                    sb.append(".");
                } else {
                    sb.append(lvKey);
                }
                this.walkInternal(lvKey, -1, lvValue, sb.toString());
            }
            this.fireVisitIterateableElement(pvMap, 9, pvPath, 2);
        }
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }
}

