/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.DatasetType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Resources;
import com.supermap.data.TextPart;
import com.supermap.data.Toolkit;
import com.supermap.mapping.Layer;
import com.supermap.mapping.ThemeGridRangeItem;
import com.supermap.mapping.ThemeGridUniqueItem;
import com.supermap.mapping.ThemeLabelItem;
import com.supermap.mapping.ThemeRangeItem;
import com.supermap.mapping.ThemeUniqueItem;
import com.supermap.ui.NodeDataType;
import com.supermap.ui.TreeNodeData;
import com.supermap.ui.TreeNodeDecorator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class ThemeItemGeneralNodeDecorator
implements TreeNodeDecorator {
    ThemeItemGeneralNodeDecorator() {
    }

    public void decorate(JLabel jLabel, TreeNodeData treeNodeData) {
        Layer layer = treeNodeData.getParentLayer();
        Resources resources = layer.getDataset().getDatasource().getWorkspace().getResources();
        Object object = treeNodeData.getData();
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Graphics graphics = bufferedImage.getGraphics();
        ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
        NodeDataType nodeDataType = treeNodeData.getType();
        if (nodeDataType.equals((Object)NodeDataType.THEMEGRIDUNIQUEITEM)) {
            ThemeGridRangeItem themeGridRangeItem = (ThemeGridRangeItem)object;
            jLabel.setText(themeGridRangeItem.getCaption());
            Color color = themeGridRangeItem.getColor();
            Geometry geometry = this._$1(layer.getDataset().getType());
            GeoStyle geoStyle = new GeoStyle();
            geoStyle.setFillBackColor(color);
            geoStyle.setFillForeColor(color);
            geoStyle.setLineColor(color);
            geometry.setStyle(geoStyle);
            Toolkit.draw((Geometry)geometry, (Resources)resources, (Graphics)graphics);
            imageIcon.setImage(bufferedImage);
        } else if (nodeDataType.equals((Object)NodeDataType.THEMEGRIDUNIQUEITEM)) {
            ThemeGridUniqueItem themeGridUniqueItem = (ThemeGridUniqueItem)object;
            jLabel.setText(themeGridUniqueItem.getCaption());
            Color color = themeGridUniqueItem.getColor();
            Geometry geometry = this._$1(layer.getDataset().getType());
            GeoStyle geoStyle = new GeoStyle();
            geoStyle.setFillBackColor(color);
            geoStyle.setFillForeColor(color);
            geoStyle.setLineColor(color);
            geometry.setStyle(geoStyle);
            Toolkit.draw((Geometry)geometry, (Resources)resources, (Graphics)graphics);
            imageIcon.setImage(bufferedImage);
        } else if (nodeDataType.equals((Object)NodeDataType.THEMELABELITEM)) {
            ThemeLabelItem themeLabelItem = (ThemeLabelItem)object;
            jLabel.setText(themeLabelItem.getCaption());
            TextPart textPart = new TextPart();
            textPart.setText(themeLabelItem.getCaption());
            GeoText geoText = new GeoText(textPart);
            geoText.setTextStyle(themeLabelItem.getStyle());
            Toolkit.draw((Geometry)geoText, (Resources)resources, (Graphics)graphics);
            imageIcon.setImage(bufferedImage);
        } else if (nodeDataType.equals((Object)NodeDataType.THEMERANGEITEM)) {
            ThemeRangeItem themeRangeItem = (ThemeRangeItem)object;
            jLabel.setText(themeRangeItem.getCaption());
            GeoStyle geoStyle = themeRangeItem.getStyle();
            Geometry geometry = this._$1(layer.getDataset().getType());
            GeoStyle geoStyle2 = geoStyle.clone();
            if (geoStyle2.getLineWidth() > 0.2) {
                geoStyle2.setLineWidth(0.2);
            }
            geometry.setStyle(geoStyle2);
            Toolkit.draw((Geometry)geometry, (Resources)resources, (Graphics)graphics);
            imageIcon.setImage(bufferedImage);
        } else if (object instanceof ThemeUniqueItem) {
            ThemeUniqueItem themeUniqueItem = (ThemeUniqueItem)object;
            jLabel.setText(themeUniqueItem.getCaption());
            GeoStyle geoStyle = themeUniqueItem.getStyle();
            Geometry geometry = this._$1(layer.getDataset().getType());
            GeoStyle geoStyle3 = geoStyle.clone();
            if (geoStyle3.getLineWidth() > 0.2) {
                geoStyle3.setLineWidth(0.2);
            }
            geometry.setStyle(geoStyle3);
            Toolkit.draw((Geometry)geometry, (Resources)resources, (Graphics)graphics);
            imageIcon.setImage(bufferedImage);
        }
    }

    private Geometry _$1(DatasetType datasetType) {
        if (datasetType.equals((Object)DatasetType.POINT)) {
            GeoPoint geoPoint = new GeoPoint();
            return geoPoint;
        }
        if (datasetType.equals((Object)DatasetType.LINE)) {
            Point2D[] point2DArray = new Point2D[]{new Point2D(0.0, 16.0), new Point2D(4.0, 0.0), new Point2D(12.0, 16.0), new Point2D(16.0, 0.0)};
            Point2Ds point2Ds = new Point2Ds(point2DArray);
            GeoLine geoLine = new GeoLine(point2Ds);
            return geoLine;
        }
        if (datasetType.equals((Object)DatasetType.REGION) || datasetType.equals((Object)DatasetType.GRID)) {
            Point2D[] point2DArray = new Point2D[]{new Point2D(1.0, 15.0), new Point2D(1.0, 5.0), new Point2D(10.0, 1.0), new Point2D(15.0, 5.0), new Point2D(15.0, 15.0), new Point2D(1.0, 15.0)};
            Point2Ds point2Ds = new Point2Ds(point2DArray);
            GeoRegion geoRegion = new GeoRegion(point2Ds);
            return geoRegion;
        }
        return null;
    }
}

