/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.layout;

import com.supermap.data.GeoMapScale;
import com.supermap.data.GeoNorthArrow;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.layout.InternalGeometry;
import com.supermap.layout.InternalHandle;
import com.supermap.layout.InternalHandleDisposable;
import com.supermap.layout.InternalResource;
import com.supermap.layout.LayoutElementsNative;
import com.supermap.layout.MapLayout;

public class LayoutElements {
    private MapLayout _$1;
    long m_handle;

    LayoutElements(MapLayout mapLayout) {
        this._$1 = mapLayout;
        this.m_handle = LayoutElementsNative.jni_GetRecordset(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1));
    }

    public boolean isBOF() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("isBOF()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_IsBOF(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
    }

    public boolean isEOF() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("isEOF()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_IsEOF(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
    }

    public boolean isEmpty() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("isEmpty()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_IsEmpty(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
    }

    public int getCount() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("getCount()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_GetCount(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
    }

    public boolean addNew(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("addNew(Geometry geometry)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (geometry.getType().equals((Object)GeometryType.GEOMAPSCALE)) {
            return LayoutElementsNative.jni_AddNewMapScale(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), l, ((GeoMapScale)geometry).getBindingGeoMapID(), this.m_handle);
        }
        if (geometry.getType().equals((Object)GeometryType.GEONORTHARROW)) {
            return LayoutElementsNative.jni_AddNewNorthArrow(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), l, ((GeoNorthArrow)geometry).getBindingGeoMapID(), this.m_handle);
        }
        Geometry geometry2 = geometry.clone();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry2);
        boolean bl = LayoutElementsNative.jni_AddNew(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), l2, this.m_handle);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry2);
        return bl;
    }

    public int delete(int[] nArray) {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("delete(int[] ids)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_DeleteIDs(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), nArray, this.m_handle);
    }

    public boolean delete() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("delete()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_DeleteCur(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
    }

    public boolean deleteAll() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("deleteAll()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_DeleteAll(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
    }

    public Geometry getGeometry() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("getGeometry()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        long l = LayoutElementsNative.jni_GetGeometry(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = InternalGeometry.createInstance2(l, this._$1.getWorkspace());
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, true);
            if (geometry.getType().equals((Object)GeometryType.GEOMAPSCALE)) {
                int n = LayoutElementsNative.jni_GetBindingGeoMapID(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), l, this.m_handle);
                ((GeoMapScale)geometry).setBindingGeoMapID(n);
            } else if (geometry.getType().equals((Object)GeometryType.GEONORTHARROW)) {
                int n = LayoutElementsNative.jni_GetBindingGeoMapID(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), l, this.m_handle);
                ((GeoNorthArrow)geometry).setBindingGeoMapID(n);
            }
        }
        return geometry;
    }

    public int getID() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("getID()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_GetID(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
    }

    public boolean move(int n) {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("move(int count)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_Move(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), n, this.m_handle);
    }

    public boolean moveFirst() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("moveFirst()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_MoveFirst(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
    }

    public boolean moveLast() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("moveLast()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_MoveLast(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
    }

    public boolean moveNext() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("moveNext()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_MoveNext(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
    }

    public boolean movePrev() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("movePrev()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_MovePrev(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
    }

    public boolean moveTo(int n) {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("moveTo(int position)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_MoveTo(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), n, this.m_handle);
    }

    public boolean refresh() {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("refresh()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return LayoutElementsNative.jni_Refresh(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
    }

    public boolean seekID(int n) {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("seekID(int id)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (n >= 0) {
            bl = LayoutElementsNative.jni_SeekID(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), n, this.m_handle);
        }
        return bl;
    }

    public boolean setGeometry(Geometry geometry) {
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string = InternalResource.loadString("addNew(Geometry geometry)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (geometry.getType().equals((Object)GeometryType.GEOMAPSCALE)) {
            return LayoutElementsNative.jni_SetMapScale(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), l, ((GeoMapScale)geometry).getBindingGeoMapID(), this.m_handle);
        }
        if (geometry.getType().equals((Object)GeometryType.GEONORTHARROW)) {
            return LayoutElementsNative.jni_SetNorthArrow(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), l, ((GeoNorthArrow)geometry).getBindingGeoMapID(), this.m_handle);
        }
        if (this.getGeometry().getType().equals((Object)GeometryType.GEOMAP) && geometry.getType().equals((Object)GeometryType.GEOMAP)) {
            return LayoutElementsNative.jni_SetGeoMap(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), l, this.m_handle);
        }
        boolean bl = LayoutElementsNative.jni_SetGeometry(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), l, this.m_handle);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        return bl;
    }

    void clearHandle() {
        LayoutElementsNative.jni_ClearHandle(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), this.m_handle);
        this._$1 = null;
    }

    public boolean setTagWithID(int n, String string) {
        if (n >= 0) {
            if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
                String string2 = InternalResource.loadString("setTagWithID(int id,String tag)", "Global_OwnerHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string2);
            }
            if (string == null || string.trim().length() == 0) {
                String string3 = InternalResource.loadString("tag", "Global_StringIsNullOrEmpty", "layout_resources");
                throw new IllegalArgumentException(string3);
            }
            return LayoutElementsNative.jni_SetTagWithID(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), n, string, this.m_handle);
        }
        return false;
    }

    public String getTagWithID(int n) {
        if (n >= 0) {
            if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
                String string = InternalResource.loadString("getTagWithID(int id)", "Global_OwnerHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            return LayoutElementsNative.jni_GetTagWithID(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1), n, this.m_handle);
        }
        return null;
    }

    public boolean seekTag(String string) {
        if (this._$1 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$1) == 0L) {
            String string2 = InternalResource.loadString("seekTag(String tag)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("tag", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        if (this._$1.getElements().getCount() > 0) {
            boolean bl = false;
            this._$1.getElements().moveFirst();
            while (!this._$1.getElements().isEOF()) {
                int n = this._$1.getElements().getID();
                String string4 = this._$1.getElements().getTagWithID(n);
                if (string4.trim().equals(string.trim())) {
                    bl = true;
                    break;
                }
                this._$1.getElements().moveNext();
            }
            return bl;
        }
        throw new IllegalStateException("no LayoutElement");
    }
}

