/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.data.VersionConflictOption;
import com.supermap.data.VersionInfo;
import com.supermap.data.VersionManagerNative;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class VersionManager
extends InternalHandle {
    private Datasource _$4;
    private VersionInfo _$3;
    private VersionInfo _$2;

    VersionManager(long l, Datasource datasource) {
        this.setHandle(l);
        this._$4 = datasource;
    }

    public VersionInfo getCurrentVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentVersion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == null) {
            int[] nArray = new int[2];
            String[] stringArray = new String[2];
            long[] lArray = new long[1];
            VersionManagerNative.jni_GetCurrentVersion(this.getHandle(), nArray, stringArray, lArray);
            Date date = null;
            if (lArray[0] != 0L) {
                date = this.toDate(lArray[0]);
            }
            this._$3 = new VersionInfo(nArray[0], stringArray[0], stringArray[1], nArray[1], date);
        }
        return this._$3;
    }

    public VersionInfo getRootVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentVersion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2 == null) {
            int[] nArray = new int[2];
            String[] stringArray = new String[2];
            long[] lArray = new long[1];
            VersionManagerNative.jni_GetRootVersion(this.getHandle(), nArray, stringArray, lArray);
            Date date = null;
            if (lArray[0] != 0L && lArray[0] != 0L) {
                date = this.toDate(lArray[0]);
            }
            this._$2 = new VersionInfo(nArray[0], stringArray[0], stringArray[1], nArray[1], date);
        }
        return this._$2;
    }

    public VersionInfo createVersion(String string, int n, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("getCurrentVersion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (this.isExsitVersionName(string)) {
            String string5 = InternalResource.loadString("name", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!this.isExsitVersionID(n)) {
            String string6 = InternalResource.loadString("parentID", "Version_IDIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (string2 == null) {
            string2 = "";
        }
        VersionInfo versionInfo = null;
        boolean bl = VersionManagerNative.jni_Create1(this.getHandle(), string, n, string2);
        if (bl) {
            int[] nArray = new int[2];
            String[] stringArray = new String[2];
            long[] lArray = new long[1];
            VersionManagerNative.jni_GetVersionByName(this.getHandle(), nArray, stringArray, lArray, string);
            Date date = null;
            if (lArray[0] != 0L) {
                date = this.toDate(lArray[0]);
            }
            versionInfo = new VersionInfo(nArray[0], stringArray[0], stringArray[1], nArray[1], date);
        }
        return versionInfo;
    }

    public VersionInfo createVersion(String string, String string2, String string3) {
        if (this.getHandle() == 0L) {
            String string4 = InternalResource.loadString("getCurrentVersion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string6 = InternalResource.loadString("parentName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (this.isExsitVersionName(string)) {
            String string7 = InternalResource.loadString("name", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (!this.isExsitVersionName(string2)) {
            String string8 = InternalResource.loadString("parentName", "Global_SpecifiedNameNotExist", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        if (string3 == null) {
            string3 = "";
        }
        VersionInfo versionInfo = null;
        boolean bl = VersionManagerNative.jni_Create2(this.getHandle(), string, string2, string3);
        if (bl) {
            int[] nArray = new int[2];
            String[] stringArray = new String[2];
            long[] lArray = new long[1];
            VersionManagerNative.jni_GetVersionByName(this.getHandle(), nArray, stringArray, lArray, string);
            Date date = null;
            if (lArray[0] != 0L) {
                date = this.toDate(lArray[0]);
            }
            versionInfo = new VersionInfo(nArray[0], stringArray[0], stringArray[1], nArray[1], date);
        }
        return versionInfo;
    }

    public boolean switchVersion(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("switchVersion(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isExsitVersionID(n)) {
            String string = InternalResource.loadString("id", "Version_IDIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = VersionManagerNative.jni_SwitchVersion(this.getHandle(), n);
        if (bl) {
            int[] nArray = new int[2];
            String[] stringArray = new String[2];
            long[] lArray = new long[1];
            VersionManagerNative.jni_GetCurrentVersion(this.getHandle(), nArray, stringArray, lArray);
            Date date = null;
            if (lArray[0] != 0L) {
                date = this.toDate(lArray[0]);
            }
            if (this._$3 == null) {
                this._$3 = new VersionInfo(nArray[0], stringArray[0], stringArray[1], nArray[1], date);
            } else {
                this._$3.reset(nArray[0], stringArray[0], stringArray[1], nArray[1], date);
            }
        }
        return bl;
    }

    public boolean switchVersion(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("switchVersion(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this.isExsitVersionName(string)) {
            String string4 = InternalResource.loadString("name", "Global_SpecifiedNameNotExist", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        boolean bl = VersionManagerNative.jni_SwitchVersionByName(this.getHandle(), string);
        if (bl) {
            int[] nArray = new int[2];
            String[] stringArray = new String[2];
            long[] lArray = new long[1];
            VersionManagerNative.jni_GetCurrentVersion(this.getHandle(), nArray, stringArray, lArray);
            Date date = null;
            if (lArray[0] != 0L) {
                date = this.toDate(lArray[0]);
            }
            if (this._$3 == null) {
                this._$3 = new VersionInfo(nArray[0], stringArray[0], stringArray[1], nArray[1], date);
            } else {
                this._$3.reset(nArray[0], stringArray[0], stringArray[1], nArray[1], date);
            }
        }
        return bl;
    }

    public boolean deleteVersion(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deleteVersion(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isExsitVersionID(n)) {
            if (n == this.getCurrentVersion().getID()) {
                String string = InternalResource.loadString("deleteVersion(int id)", "VersionManager_CurrentVersionCanNotBeDeleted", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (n == 1) {
                String string = InternalResource.loadString("deleteVersion(int id)", "VersionManager_RootVersionCanNotBeDeleted", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.getChildVersions(n).length > 0) {
                String string = InternalResource.loadString("deleteVersion(int id)", "VersionManager_CurrentVersionHasChildVersionCanNotBeDeleted", "data_resources");
                throw new IllegalArgumentException(string);
            }
            return VersionManagerNative.jni_DeleteVersionByID(this.getHandle(), n);
        }
        return false;
    }

    public boolean deleteVersion(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("deleteVersion(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (this.isExsitVersionName(string)) {
            if (string.equalsIgnoreCase(this.getCurrentVersion().getName())) {
                String string4 = InternalResource.loadString("deleteVersion(String name)", "VersionManager_CurrentVersionCanNotBeDeleted", "data_resources");
                throw new IllegalArgumentException(string4);
            }
            if (this.getVersionInfo(string).getID() == 1) {
                String string5 = InternalResource.loadString("deleteVersion(String name)", "VersionManager_RootVersionCanNotBeDeleted", "data_resources");
                throw new IllegalArgumentException(string5);
            }
            if (this.getChildVersions(string).length > 0) {
                String string6 = InternalResource.loadString("deleteVersion(String name)", "VersionManager_CurrentVersionHasChildVersionCanNotBeDeleted", "data_resources");
                throw new IllegalArgumentException(string6);
            }
            return VersionManagerNative.jni_DeleteVersionByName(this.getHandle(), string);
        }
        return false;
    }

    public VersionInfo getVersionInfo(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVersionInfo(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isExsitVersionID(n)) {
            return null;
        }
        VersionInfo versionInfo = null;
        int[] nArray = new int[2];
        String[] stringArray = new String[2];
        long[] lArray = new long[1];
        boolean bl = VersionManagerNative.jni_GetVersionByID(this.getHandle(), nArray, stringArray, lArray, n);
        if (bl) {
            Date date = null;
            if (lArray[0] != 0L) {
                date = this.toDate(lArray[0]);
            }
            versionInfo = new VersionInfo(nArray[0], stringArray[0], stringArray[1], nArray[1], date);
        }
        return versionInfo;
    }

    public VersionInfo getVersionInfo(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("deleteVersion(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this.isExsitVersionName(string)) {
            return null;
        }
        VersionInfo versionInfo = null;
        int[] nArray = new int[2];
        String[] stringArray = new String[2];
        long[] lArray = new long[1];
        boolean bl = VersionManagerNative.jni_GetVersionByName(this.getHandle(), nArray, stringArray, lArray, string);
        if (bl) {
            Date date = null;
            if (lArray[0] != 0L) {
                date = this.toDate(lArray[0]);
            }
            versionInfo = new VersionInfo(nArray[0], stringArray[0], stringArray[1], nArray[1], date);
        }
        return versionInfo;
    }

    public VersionInfo updateVersionInfo(int n, String string, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("updateVersionInfo(int id,String newName,String newDescription)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (!this.isExsitVersionID(n)) {
            String string4 = InternalResource.loadString("id", "Version_IDIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string6 = InternalResource.loadString("newDescription", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (this.isExsitVersionName(string)) {
            String string7 = InternalResource.loadString("newName", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        VersionInfo versionInfo = null;
        boolean bl = VersionManagerNative.jni_UpdateVersionInfo(this.getHandle(), n, string, string2);
        if (bl) {
            int[] nArray = new int[2];
            String[] stringArray = new String[2];
            long[] lArray = new long[1];
            VersionManagerNative.jni_GetVersionByID(this.getHandle(), nArray, stringArray, lArray, n);
            Date date = null;
            if (lArray[0] != 0L) {
                date = this.toDate(lArray[0]);
            }
            versionInfo = new VersionInfo(nArray[0], stringArray[0], stringArray[1], nArray[1], date);
        }
        return versionInfo;
    }

    public VersionInfo[] getChildVersions(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChildVersions(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isExsitVersionID(n)) {
            String string = InternalResource.loadString("id", "Version_IDIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = VersionManagerNative.jni_GetVersionsByID(this.getHandle(), n);
        VersionInfo[] versionInfoArray = new VersionInfo[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = new int[2];
            String[] stringArray = new String[2];
            long[] lArray = new long[1];
            boolean bl = VersionManagerNative.jni_GetVersionByID(this.getHandle(), nArray2, stringArray, lArray, nArray[i]);
            if (!bl) continue;
            Date date = null;
            if (lArray[0] != 0L) {
                date = this.toDate(lArray[0]);
            }
            versionInfoArray[i] = new VersionInfo(nArray2[0], stringArray[0], stringArray[1], nArray2[1], date);
        }
        return versionInfoArray;
    }

    public VersionInfo[] getChildVersions(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("getChildVersions(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (!this.isExsitVersionName(string)) {
            String string3 = InternalResource.loadString("name", "Version_IDIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        int n = this.getVersionInfo(string).getID();
        return this.getChildVersions(n);
    }

    public boolean registerDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("registerDataset(Dataset dataset)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!dataset.getDatasource().equals(this._$4)) {
            String string = InternalResource.loadString("dataset", "DatasetMustContainInDatasource", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!Dataset.isVector(dataset)) {
            String string = InternalResource.loadString("dataset", "UnsupprotDatasetType", "data_resources");
            throw new IllegalStateException(string);
        }
        return VersionManagerNative.jni_RegisterDataset(this.getHandle(), dataset.getHandle());
    }

    public boolean unRegisterDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("unRegisterDataset(Dataset dataset) ", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!dataset.getDatasource().equals(this._$4)) {
            String string = InternalResource.loadString("dataset", "DatasetMustContainInDatasource", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!Dataset.isVector(dataset)) {
            String string = InternalResource.loadString("dataset", "UnsupprotDatasetType", "data_resources");
            throw new IllegalStateException(string);
        }
        return VersionManagerNative.jni_UnRegisterDataset(this.getHandle(), dataset.getHandle());
    }

    public int[] reconcile(Dataset dataset, String string, VersionConflictOption versionConflictOption) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("reconcile(Dataset dataset, String targetVersionName,VersionConflictOption option) ", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (!dataset.getDatasource().equals(this._$4)) {
            String string3 = InternalResource.loadString("dataset", "DatasetMustContainInDatasource", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (!Dataset.isVector(dataset)) {
            String string4 = InternalResource.loadString("dataset", "UnsupprotDatasetType", "data_resources");
            throw new IllegalStateException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("targetVersionName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!this.isExsitVersionName(string)) {
            String string6 = InternalResource.loadString("name", "Global_SpecifiedNameNotExist", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        int[] nArray = new int[1];
        int[] nArray2 = VersionManagerNative.jni_Reconcile(this.getHandle(), dataset.getHandle(), string, versionConflictOption.getUGCValue(), nArray);
        if (nArray[0] == -1) {
            String string7 = InternalResource.loadString("name", "TagetVersionIsNotCurrentVersionParent", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (nArray[0] == -2) {
            String string8 = InternalResource.loadString("name", "CurrentVersionIsBeingEdited", "data_resources");
            throw new IllegalArgumentException(string8);
        }
        if (nArray[0] == -3) {
            String string9 = InternalResource.loadString("name", "CurrentVersionIsBeingReconciled", "data_resources");
            throw new IllegalArgumentException(string9);
        }
        if (nArray[0] == -4) {
            String string10 = InternalResource.loadString("name", "TagetVersionIsBeingReconciled", "data_resources");
            throw new IllegalArgumentException(string10);
        }
        return nArray2;
    }

    public int[] reconcile(Dataset dataset, int n, VersionConflictOption versionConflictOption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString(" reconcile(Dataset dataset, int targetVersionID,FVersionConflictOption option) ", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!dataset.getDatasource().equals(this._$4)) {
            String string = InternalResource.loadString("dataset", "DatasetMustContainInDatasource", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!Dataset.isVector(dataset)) {
            String string = InternalResource.loadString("dataset", "UnsupprotDatasetType", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.reconcile(dataset, this.getVersionInfo(n).getName(), versionConflictOption);
    }

    public boolean commit(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("commit(Dataset dataset) ", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!dataset.getDatasource().equals(this._$4)) {
            String string = InternalResource.loadString("dataset", "DatasetMustContainInDatasource", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!Dataset.isVector(dataset)) {
            String string = InternalResource.loadString("dataset", "UnsupprotDatasetType", "data_resources");
            throw new IllegalStateException(string);
        }
        return VersionManagerNative.jni_Commit(this.getHandle(), dataset.getHandle());
    }

    public boolean transactConflict(Dataset dataset, int n, VersionConflictOption versionConflictOption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("transactConflict(Dataset dataset,int conflictID, VersionConflictOption option)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!dataset.getDatasource().equals(this._$4)) {
            String string = InternalResource.loadString("dataset", "DatasetMustContainInDatasource", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!Dataset.isVector(dataset)) {
            String string = InternalResource.loadString("dataset", "UnsupprotDatasetType", "data_resources");
            throw new IllegalStateException(string);
        }
        return VersionManagerNative.jni_TransactConflict(this.getHandle(), dataset.getHandle(), n, versionConflictOption.getUGCValue());
    }

    public boolean saveVersion(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("saveVersion(Dataset dataset)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!dataset.getDatasource().equals(this._$4)) {
            String string = InternalResource.loadString("dataset", "DatasetMustContainInDatasource", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!Dataset.isVector(dataset)) {
            String string = InternalResource.loadString("dataset", "UnsupprotDatasetType", "data_resources");
            throw new IllegalStateException(string);
        }
        return VersionManagerNative.jni_SaveVersion(this.getHandle(), dataset.getHandle());
    }

    public boolean isSaveNeeded(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSaveNeeded(Dataset dataset)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!dataset.getDatasource().equals(this._$4)) {
            String string = InternalResource.loadString("dataset", "DatasetMustContainInDatasource", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!Dataset.isVector(dataset)) {
            String string = InternalResource.loadString("dataset", "UnsupprotDatasetType", "data_resources");
            throw new IllegalStateException(string);
        }
        return VersionManagerNative.jni_IsSaveNeeded(this.getHandle(), dataset.getHandle());
    }

    public boolean checkInheritingRelation(int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("checkInheritingRelation(int childVersionID,int ancestorVersionID) ", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isExsitVersionID(n)) {
            String string = InternalResource.loadString("childVersionID", "Version_IDIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.isExsitVersionID(n2)) {
            String string = InternalResource.loadString("ancestorVersionID", "Version_IDIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.checkInheritingRelation(this.getVersionInfo(n).getName(), this.getVersionInfo(n2).getName());
    }

    public boolean checkInheritingRelation(String string, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("checkInheritingRelation(String childVersionName, String ancestorVersionName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("childVersionName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string5 = InternalResource.loadString("ancestorVersionName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!this.isExsitVersionName(string)) {
            String string6 = InternalResource.loadString("childVersionID", "Version_IDIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (!this.isExsitVersionName(string2)) {
            String string7 = InternalResource.loadString("ancestorVersionID", "Version_IDIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        return VersionManagerNative.jni_CheckInheritingRelationByName(this.getHandle(), string, string2);
    }

    public Recordset getReconcileCurrentRecordset(Dataset dataset, QueryParameter queryParameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getReconcileCurrentRecordset(Dataset dataset,QueryParameter queryParameter) ", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!dataset.getDatasource().equals(this._$4)) {
            String string = InternalResource.loadString("dataset", "DatasetMustContainInDatasource", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!Dataset.isVector(dataset)) {
            String string = InternalResource.loadString("dataset", "UnsupprotDatasetType", "data_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter == null) {
            String string = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (queryParameter.getCursorType().equals(CursorType.DYNAMIC)) {
            String string = InternalResource.loadString("queryParameter", "QueryParameterMustBeStaticCursor", "data_resources");
            throw new NullPointerException(string);
        }
        long l = VersionManagerNative.jni_GetReconcileCurrentRecordset(this.getHandle(), dataset.getHandle(), queryParameter.getHandle());
        Recordset recordset = null;
        if (l != 0L) {
            recordset = new Recordset(l, (DatasetVector)dataset);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(queryParameter);
        return recordset;
    }

    public Recordset getReconcileTargetRecordset(Dataset dataset, QueryParameter queryParameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getReconcileTargetRecordset(Dataset dataset, QueryParameter queryParameter)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!dataset.getDatasource().equals(this._$4)) {
            String string = InternalResource.loadString("dataset", "DatasetMustContainInDatasource", "data_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter == null) {
            String string = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (queryParameter.getCursorType().equals(CursorType.DYNAMIC)) {
            String string = InternalResource.loadString("queryParameter", "QueryParameterMustBeStaticCursor", "data_resources");
            throw new NullPointerException(string);
        }
        if (!Dataset.isVector(dataset)) {
            String string = InternalResource.loadString("dataset", "UnsupprotDatasetType", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = VersionManagerNative.jni_GetReconcileTargetRecordset(this.getHandle(), dataset.getHandle(), queryParameter.getHandle());
        Recordset recordset = null;
        if (l != 0L) {
            recordset = new Recordset(l, (DatasetVector)dataset);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(queryParameter);
        return recordset;
    }

    public Recordset getReconcileCommonRecordset(Dataset dataset, QueryParameter queryParameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getReconcileCommonRecordset(Dataset dataset, QueryParameter queryParameter)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!dataset.getDatasource().equals(this._$4)) {
            String string = InternalResource.loadString("dataset", "DatasetMustContainInDatasource", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!Dataset.isVector(dataset)) {
            String string = InternalResource.loadString("dataset", "UnsupprotDatasetType", "data_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter == null) {
            String string = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (queryParameter.getCursorType().equals(CursorType.DYNAMIC)) {
            String string = InternalResource.loadString("queryParameter", "QueryParameterMustBeStaticCursor", "data_resources");
            throw new NullPointerException(string);
        }
        long l = VersionManagerNative.jni_GetReconcileCommonRecordset(this.getHandle(), dataset.getHandle(), queryParameter.getHandle());
        Recordset recordset = null;
        if (l != 0L) {
            recordset = new Recordset(l, (DatasetVector)dataset);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(queryParameter);
        return recordset;
    }

    boolean isExsitVersionName(String string) {
        return VersionManagerNative.jni_IsExsitVersionName(this.getHandle(), string);
    }

    boolean isExsitVersionID(int n) {
        return VersionManagerNative.jni_IsExsitVersionID(this.getHandle(), n);
    }

    Date toDate(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.US);
        Date date = null;
        try {
            date = simpleDateFormat.parse(VersionManagerNative.jni_GetDateString(l));
        }
        catch (Exception exception) {
            // empty catch block
        }
        VersionManagerNative.jni_DeleteDate(l);
        return date;
    }

    protected void clearHandle() {
        this._$3 = null;
        this._$2 = null;
        this._$4 = null;
        this.setHandle(0L);
    }
}

