/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CursorType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.JoinItems;
import com.supermap.data.LinkItems;
import com.supermap.data.Point2D;
import com.supermap.data.QueryParameterNative;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SpatialComparePattern;
import com.supermap.data.SpatialQueryMode;
import com.supermap.data.TimeCondition;
import com.supermap.data.Toolkit;

public class QueryParameter
extends InternalHandleDisposable {
    private Object _$6 = null;
    private JoinItems _$5 = null;
    private LinkItems _$4 = null;
    private SpatialQueryMode _$3 = SpatialQueryMode.NONE;

    public QueryParameter() {
        this.setHandle(QueryParameterNative.jni_New(), true);
        this.reset();
    }

    public QueryParameter(QueryParameter queryParameter) {
        if (queryParameter == null) {
            String string = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (queryParameter.getHandle() == 0L) {
            String string = InternalResource.loadString("queryParameter", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(QueryParameterNative.jni_New(), true);
        this.setAttributeFilter(queryParameter.getAttributeFilter());
        this.setCursorType(queryParameter.getCursorType());
        this.setGroupBy(queryParameter.getGroupBy());
        this.setJoinItems(queryParameter.getJoinItems());
        this.setLinkItems(queryParameter.getLinkItems());
        this.setOrderBy(queryParameter.getOrderBy());
        this.setGroupBy(queryParameter.getGroupBy());
        this.setResultFields(queryParameter.getResultFields());
        this.setSpatialQueryObject(queryParameter.getSpatialQueryObject());
        this.setSpatialQueryMode(queryParameter.getSpatialQueryMode());
        this.setHasGeometry(queryParameter.getHasGeometry());
        this.setTimeConditions(queryParameter.getTimeConditions());
        InternalHandleDisposable.makeSureNativeObjectLive(queryParameter);
    }

    QueryParameter(long l, Object object, SpatialQueryMode spatialQueryMode) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (object != null) {
            this._$6 = object;
            this._$3 = spatialQueryMode;
        }
        this.setHandle(l, true);
    }

    private QueryParameter(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, false);
    }

    public CursorType getCursorType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = QueryParameterNative.jni_GetCursorType(this.getHandle());
        return (CursorType)Enum.parseUGCValue(CursorType.class, n);
    }

    public void setCursorType(CursorType cursorType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        QueryParameterNative.jni_SetCursorType(this.getHandle(), cursorType.getUGCValue());
    }

    public String getAttributeFilter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return QueryParameterNative.jni_GetAttributeFilter(this.getHandle());
    }

    public void setAttributeFilter(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        QueryParameterNative.jni_SetAttributeFilter(this.getHandle(), string);
    }

    public TimeCondition[] getTimeConditions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = QueryParameterNative.jni_GetConditions(this.getHandle());
        TimeCondition[] timeConditionArray = new TimeCondition[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            timeConditionArray[i] = new TimeCondition(lArray[i]);
        }
        return timeConditionArray;
    }

    public void setTimeConditions(TimeCondition[] timeConditionArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[timeConditionArray.length];
        for (int i = 0; i < timeConditionArray.length; ++i) {
            if (timeConditionArray[i].getHandle() == 0L) {
                String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = timeConditionArray[i].getHandle();
        }
        QueryParameterNative.jni_SetConditions(this.getHandle(), lArray);
    }

    public void AddTimeCondition(TimeCondition timeCondition) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (timeCondition.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        QueryParameterNative.jni_AddCondition(this.getHandle(), timeCondition.getHandle());
    }

    public boolean getHasGeometry() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return QueryParameterNative.jni_GetHasGeometry(this.getHandle());
    }

    public void setHasGeometry(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        QueryParameterNative.jni_SetHasGeometry(this.getHandle(), bl);
    }

    public Object getSpatialQueryObject() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$6;
    }

    public void setSpatialQueryObject(Object object) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (object == null) {
            this._$6 = null;
            return;
        }
        if (!QueryParameter.isValidQueryObject(object)) {
            String string = InternalResource.loadString("value", "QueryParameter_InvalidQueryObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$6 = object;
    }

    public SpatialQueryMode getSpatialQueryMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$3;
    }

    public void setSpatialQueryMode(SpatialQueryMode spatialQueryMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (spatialQueryMode == null) {
            String string = "value";
            throw new NullPointerException(string);
        }
        this._$3 = spatialQueryMode;
    }

    public String[] getOrderBy() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = QueryParameterNative.jni_GetOrderBy(this.getHandle());
        return Toolkit.splitString(string, ",");
    }

    public void setOrderBy(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = Toolkit.joinString(stringArray, ",");
        QueryParameterNative.jni_SetOrderBy(this.getHandle(), string);
    }

    public String[] getGroupBy() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = QueryParameterNative.jni_GetGroupBy(this.getHandle());
        return Toolkit.splitString(string, ",");
    }

    public void setGroupBy(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = Toolkit.joinString(stringArray, ",");
        QueryParameterNative.jni_SetGroupBy(this.getHandle(), string);
    }

    public JoinItems getJoinItems() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$5 == null) {
            long l = QueryParameterNative.jni_GetJoinItems(this.getHandle());
            if (l == 0L) {
                String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
                throw new IllegalArgumentException(string);
            }
            this._$5 = new JoinItems(l);
        }
        return this._$5;
    }

    public void setJoinItems(JoinItems joinItems) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (joinItems == null) {
            String string = InternalResource.loadString("joinItems", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (joinItems.getHandle() == 0L) {
            String string = InternalResource.loadString("joinItems", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.getJoinItems().clear();
        this.getJoinItems().addRange(joinItems.toArray());
        InternalHandleDisposable.makeSureNativeObjectLive(joinItems);
    }

    public LinkItems getLinkItems() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null) {
            long l = QueryParameterNative.jni_GetLinkItems(this.getHandle());
            if (l == 0L) {
                String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
                throw new IllegalArgumentException(string);
            }
            this._$4 = new LinkItems(l);
        }
        return this._$4;
    }

    public void setLinkItems(LinkItems linkItems) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (linkItems == null) {
            String string = InternalResource.loadString("linkItems", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (linkItems.getHandle() == 0L) {
            String string = InternalResource.loadString("linkItems", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.getLinkItems().clear();
        this.getLinkItems().addRange(linkItems.toArray());
        InternalHandleDisposable.makeSureNativeObjectLive(linkItems);
    }

    public String[] getResultFields() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = QueryParameterNative.jni_GetResultFields(this.getHandle());
        return Toolkit.splitString(string, ";");
    }

    public void setResultFields(String[] stringArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = Toolkit.joinString(stringArray, ";");
        QueryParameterNative.jni_SetResultFields(this.getHandle(), string);
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{CursorType = ");
        stringBuffer.append(this.getCursorType().name());
        stringBuffer.append(",AttributeFilter = ");
        stringBuffer.append(this.getAttributeFilter());
        stringBuffer.append(",SpatialQueryMode = ");
        stringBuffer.append(this.getSpatialQueryMode().name());
        stringBuffer.append(",OrderBy = {");
        String string = this._$1(this.getOrderBy());
        stringBuffer.append(string);
        stringBuffer.append("},GroupBy = {");
        String string2 = this._$1(this.getOrderBy());
        stringBuffer.append(string2);
        stringBuffer.append("},ResultFields = { ");
        String string3 = this._$1(this.getResultFields());
        stringBuffer.append(string3);
        stringBuffer.append("}}\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            QueryParameterNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this._$6 = null;
        if (this._$5 != null) {
            this._$5.clearHandle();
            this._$5 = null;
        }
        if (this._$4 != null) {
            this._$4.clearHandle();
            this._$4 = null;
        }
        this._$6 = null;
        this._$3 = null;
        this.setHandle(0L);
    }

    protected static QueryParameter createInstance(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new QueryParameter(l);
    }

    protected static void clearHandle(QueryParameter queryParameter) {
        queryParameter.clearHandle();
    }

    static boolean isValidSpatialFilter(SpatialComparePattern[][] spatialComparePatternArray) {
        if (spatialComparePatternArray == null) {
            return false;
        }
        if (spatialComparePatternArray.length != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (spatialComparePatternArray[i] == null || spatialComparePatternArray[i].length != 3) {
                return false;
            }
            for (int j = 0; j < 3; ++j) {
                if (spatialComparePatternArray[i][j] != null) continue;
                return false;
            }
        }
        return true;
    }

    static boolean isValidQueryObject(Object object) {
        Class<?> clazz;
        if (object == null) {
            return false;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz2.equals(Point2D.class) || clazz2.equals(Rectangle2D.class) || clazz2.equals(DatasetVector.class) || clazz2.equals(Recordset.class)) {
            return true;
        }
        for (clazz = clazz2.getSuperclass(); clazz != null && !clazz.equals(Geometry.class) && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
        }
        return clazz != null && clazz.equals(Geometry.class);
    }

    private void _$1(QueryParameter queryParameter) {
        this.setSpatialQueryMode(queryParameter.getSpatialQueryMode());
        this.setSpatialQueryObject(queryParameter.getSpatialQueryObject());
    }

    protected static void identicalJavaObject(QueryParameter queryParameter, QueryParameter queryParameter2) {
        queryParameter._$1(queryParameter2);
    }

    void reset() {
        if (this.getHandle() != 0L) {
            QueryParameterNative.jni_Reset(this.getHandle());
        }
    }

    private String _$1(String[] stringArray) {
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }
}

