/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.InternalVariantNative;
import com.supermap.data.InternalVariantType;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Pattern;

class InternalVariant
extends InternalHandleDisposable {
    protected InternalVariant() {
        this.setHandle(InternalVariantNative.jni_New(), true);
    }

    public InternalVariant(Object object) {
        this();
        if (object.getClass().equals(Byte.class)) {
            Byte by = (Byte)object;
            this.setValue(by);
        } else if (object.getClass().equals(Integer.class)) {
            Integer n = (Integer)object;
            this.setValue(n);
        } else if (object.getClass().equals(Long.class)) {
            Long l = (Long)object;
            this.setValue(l);
        } else if (object.getClass().equals(Short.class)) {
            Short s = (Short)object;
            this.setValue(s);
        } else if (object.getClass().equals(Boolean.class)) {
            Boolean bl = (Boolean)object;
            this.setValue(bl);
        } else if (object.getClass().equals(Float.class)) {
            Float f = (Float)object;
            this.setValue(f.floatValue());
        } else if (object.getClass().equals(Double.class)) {
            Double d = (Double)object;
            this.setValue(d);
        } else if (object.getClass().equals(String.class)) {
            String string = (String)object;
            this.setValue(string);
        } else if (object.getClass().equals(Date.class)) {
            Date date = (Date)object;
            this.setValue(date);
        } else if (object.getClass().equals(byte[].class)) {
            byte[] byArray = (byte[])object;
            this.setValue(byArray);
        } else {
            String string = InternalResource.loadString("", "InternalVariant_UnsupportType", "data_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public InternalVariant(byte by) {
        this();
        this.setValue(by);
    }

    public InternalVariant(int n) {
        this();
        this.setValue(n);
    }

    public InternalVariant(long l) {
        this();
        this.setValue(l);
    }

    public InternalVariant(short s) {
        this();
        this.setValue(s);
    }

    public InternalVariant(boolean bl) {
        this();
        this.setValue(bl);
    }

    public InternalVariant(float f) {
        this();
        this.setValue(f);
    }

    public InternalVariant(double d) {
        this();
        this.setValue(d);
    }

    public InternalVariant(String string) {
        this();
        this.setValue(string);
    }

    public InternalVariant(Date date) {
        this();
        this.setValue(date);
    }

    public InternalVariant(byte[] byArray) {
        this();
        this.setValue(byArray);
    }

    public InternalVariant(Byte[] byteArray) {
        this();
        this.setValue(byteArray);
    }

    public InternalVariantType getType() {
        int n = InternalVariantNative.jni_GetType(this.getHandle());
        InternalVariantType internalVariantType = (InternalVariantType)Enum.parseUGCValue(InternalVariantType.class, n);
        return internalVariantType;
    }

    public void setValue(byte by) {
        InternalVariantNative.jni_SetValueByte(this.getHandle(), by);
    }

    public void setValue(int n) {
        InternalVariantNative.jni_SetValueInt(this.getHandle(), n);
    }

    public void setValue(long l) {
        InternalVariantNative.jni_SetValueLong(this.getHandle(), l);
    }

    public void setValue(short s) {
        InternalVariantNative.jni_SetValueShort(this.getHandle(), s);
    }

    public void setValue(boolean bl) {
        InternalVariantNative.jni_SetValueBoolean(this.getHandle(), bl);
    }

    public void setValue(float f) {
        InternalVariantNative.jni_SetValueFloat(this.getHandle(), f);
    }

    public void setValue(double d) {
        InternalVariantNative.jni_SetValueDouble(this.getHandle(), d);
    }

    public void setValue(String string) {
        InternalVariantNative.jni_SetValueString(this.getHandle(), string);
    }

    public void setValue(byte[] byArray) {
        InternalVariantNative.jni_SetValueBinary(this.getHandle(), byArray);
    }

    public void setValue(Byte[] byteArray) {
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        InternalVariantNative.jni_SetValueBinary(this.getHandle(), byArray);
    }

    public void setValue(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        InternalVariantNative.jni_SetValueTime(this.getHandle(), n, n2, n3, n4, n5, n6);
    }

    public int toByte() {
        return InternalVariantNative.jni_GetValueByte(this.getHandle());
    }

    public int toInt() {
        return InternalVariantNative.jni_GetValueInt(this.getHandle());
    }

    public long toLong() {
        return InternalVariantNative.jni_GetValueLong(this.getHandle());
    }

    public short toShort() {
        return InternalVariantNative.jni_GetValueShort(this.getHandle());
    }

    public boolean toBoolean() {
        return InternalVariantNative.jni_GetValueBoolean(this.getHandle());
    }

    public double toDouble() {
        return InternalVariantNative.jni_GetValueDouble(this.getHandle());
    }

    public float toFloat() {
        return InternalVariantNative.jni_GetValueFloat(this.getHandle());
    }

    public byte[] toBinary() {
        return InternalVariantNative.jni_GetValueBinary(this.getHandle());
    }

    public String toString() {
        String string = null;
        if (this.getType().equals(InternalVariantType.TIME) || this.getType().equals(InternalVariantType.DATE) || this.getType().equals(InternalVariantType.TIMESTAMP)) {
            Date date = this.toDate();
            string = DateFormat.getDateInstance().format(date);
        } else {
            string = InternalVariantNative.jni_GetValueString(this.getHandle());
        }
        return string;
    }

    public Date toDate() {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        String string = InternalVariantNative.jni_GetValueString(this.getHandle());
        Date date = null;
        if (pattern.matcher(string).matches()) {
            try {
                date = DateFormat.getDateInstance().parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public Object toObject() {
        InternalVariantType internalVariantType = this.getType();
        if (internalVariantType.equals(InternalVariantType.BYTE)) {
            return Byte.valueOf(String.valueOf(this.toByte()));
        }
        if (internalVariantType.equals(InternalVariantType.BOOLEAN)) {
            return this.toBoolean();
        }
        if (internalVariantType.equals(InternalVariantType.INTEGER)) {
            return this.toInt();
        }
        if (internalVariantType.equals(InternalVariantType.LONG)) {
            return this.toLong();
        }
        if (internalVariantType.equals(InternalVariantType.SHORT)) {
            return this.toShort();
        }
        if (internalVariantType.equals(InternalVariantType.FLOAT)) {
            return Float.valueOf(this.toFloat());
        }
        if (internalVariantType.equals(InternalVariantType.DOUBLE)) {
            return this.toDouble();
        }
        if (internalVariantType.equals(InternalVariantType.TIME) || internalVariantType.equals(InternalVariantType.DATE) || internalVariantType.equals(InternalVariantType.TIMESTAMP)) {
            return this.toDate();
        }
        if (internalVariantType.equals(InternalVariantType.STRING)) {
            return this.toString();
        }
        if (internalVariantType.equals(InternalVariantType.BINARY)) {
            return this.toBinary();
        }
        if (internalVariantType.equals(InternalVariantType.NULL)) {
            return null;
        }
        String string = InternalResource.loadString("", "InternalVariant_UnsupportType", "data_resources");
        throw new IllegalArgumentException(string);
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            InternalVariantNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    private InternalVariant(long l, boolean bl) {
        this.setHandle(l, true);
    }

    static final InternalVariant createInstance(long l) {
        return new InternalVariant(l, true);
    }

    static boolean isSupportedInstance(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass().equals(Byte.class)) {
            return true;
        }
        if (object.getClass().equals(Integer.class)) {
            return true;
        }
        if (object.getClass().equals(Long.class)) {
            return true;
        }
        if (object.getClass().equals(Short.class)) {
            return true;
        }
        if (object.getClass().equals(Boolean.class)) {
            return true;
        }
        if (object.getClass().equals(Float.class)) {
            return true;
        }
        if (object.getClass().equals(Double.class)) {
            return true;
        }
        if (object.getClass().equals(String.class)) {
            return true;
        }
        if (object.getClass().equals(Date.class)) {
            return true;
        }
        return object.getClass().equals(byte[].class);
    }
}

