/*
 * Decompiled with CFR 0.152.
 */
package com.yjpt.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;

public class DateUtil {
    public static final String DATE_FORMAT_1 = "yyyy-MM-dd";
    public static final String DATE_FORMAT_2 = "MM/dd/yyyy";
    public static final String DATE_FORMAT_3 = "MMM. dd, yyyy";
    public static final String DATE_FORMAT_4 = "M-dd";
    public static final String DATE_FORMAT_5 = "yyyyMMdd";
    public static final String DATETIME_FORMAT_1 = "yyyy-MM-dd HH:mm:ss";
    public static final String FMT_HOUR = "HH:mm";
    private static SimpleDateFormat dateFormater = new SimpleDateFormat();
    private static Date START_D;
    private static Date END_D;

    static {
        Calendar c = Calendar.getInstance();
        c.set(1753, 1, 2);
        START_D = c.getTime();
        c.set(9999, 12, 30);
        END_D = c.getTime();
    }

    public static Date parseDate(String text) {
        return DateUtil.parseDate(text, DATE_FORMAT_1);
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDisplay(date);
    }

    public static String formatDateTime(Date date) {
        return DateUtil.formatTimeDisplay(date);
    }

    public static String formatDate(String strDate) {
        if (strDate == null) {
            return "";
        }
        return dateFormater.format(DateUtil.parseDate(strDate));
    }

    public static Date parse(String str) {
        Date dt = null;
        Calendar minCal = Calendar.getInstance();
        minCal.set(1900, 0, 1);
        Calendar maxCal = Calendar.getInstance();
        maxCal.set(2200, 0, 1);
        if (str == null) {
            return null;
        }
        try {
            dt = DateUtils.parseDate((String)str, (String[])new String[]{DATE_FORMAT_1, DATE_FORMAT_2, DATE_FORMAT_3});
            if (minCal.getTime().compareTo(dt) > 0 || maxCal.getTime().compareTo(dt) < 0) {
                dt = null;
            }
        }
        catch (ParseException pe) {
            dt = null;
        }
        catch (IllegalArgumentException iae) {
            dt = null;
        }
        return dt;
    }

    public static Date convertDate(java.sql.Date dtIn) {
        return dtIn;
    }

    public static Date convertDate(Timestamp dtIn) {
        return dtIn;
    }

    public static boolean checkDateScope(Date dtIn) {
        return dtIn != null && START_D.before(dtIn) && END_D.after(dtIn);
    }

    public static java.sql.Date revertDate(Date dtIn) {
        if (dtIn == null) {
            return null;
        }
        return new java.sql.Date(dtIn.getTime());
    }

    public static Timestamp revertTime(Date dtIn) {
        if (dtIn == null) {
            return new Timestamp(new Date().getTime());
        }
        return new Timestamp(dtIn.getTime());
    }

    public static String formatDisplay(Date date) {
        if (date == null) {
            return "";
        }
        Locale sysLocale = Locale.getDefault();
        SimpleDateFormat dateFormater = new SimpleDateFormat(DATE_FORMAT_1, sysLocale);
        return dateFormater.format(date);
    }

    public static String formatDisplay(Object dIn) {
        if (dIn == null) {
            return "";
        }
        if (dIn instanceof Date) {
            return DateUtil.formatDisplay((Date)dIn);
        }
        return dIn.toString();
    }

    public static String format(Date dt) {
        if (dt == null) {
            return "";
        }
        String str = DateFormatUtils.format((Date)dt, (String)DATE_FORMAT_1);
        return str;
    }

    public static String formatTimeDisplay(Date date) {
        if (date == null) {
            return "";
        }
        Locale sysLocale = Locale.getDefault();
        SimpleDateFormat dateFormater = new SimpleDateFormat(DATETIME_FORMAT_1, sysLocale);
        return dateFormater.format(date);
    }

    public static String formatTimeDisplay(Object dIn) {
        if (dIn == null) {
            return "";
        }
        if (dIn instanceof Date) {
            return DateUtil.formatTimeDisplay((Date)dIn);
        }
        return dIn.toString();
    }

    public static String formatDate(Date date, String strFormat) {
        if (date == null) {
            return "";
        }
        Locale sysLocale = Locale.getDefault();
        SimpleDateFormat dateFormater = new SimpleDateFormat(strFormat, sysLocale);
        return dateFormater.format(date);
    }

    public static String formatDate(Date date, String strFormat, Locale locale) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormater = new SimpleDateFormat(strFormat, locale);
        return dateFormater.format(date);
    }

    public static String formatDate(String strDate, String strFormat) {
        if (strDate == null) {
            return "";
        }
        Locale sysLocale = Locale.getDefault();
        SimpleDateFormat dateFormater = new SimpleDateFormat(strFormat, sysLocale);
        return dateFormater.format(DateUtil.parseDate(strDate, strFormat));
    }

    public static Date parseDate(String strInDate, String strFormat) {
        Date dt = null;
        Locale sysLocale = Locale.getDefault();
        SimpleDateFormat dateFormater = new SimpleDateFormat(strFormat, sysLocale);
        try {
            strInDate = strInDate.replace('/', '-');
            strInDate = strInDate.replace('.', '-');
            dt = dateFormater.parse(strInDate);
            if (!DateUtil.checkDateScope(dt)) {
                dt = null;
            }
        }
        catch (Exception e) {
            StringUtils.isEmpty((String)strInDate);
        }
        return dt;
    }

    public static Date parseDate2(String strInDate, String strFormat) {
        Date dt = null;
        Locale sysLocale = Locale.getDefault();
        SimpleDateFormat dateFormater = new SimpleDateFormat(strFormat, sysLocale);
        try {
            strInDate = strInDate.replace('-', '/');
            strInDate = strInDate.replace('.', '/');
            dt = dateFormater.parse(strInDate);
            if (!DateUtil.checkDateScope(dt)) {
                dt = null;
            }
        }
        catch (Exception e) {
            StringUtils.isEmpty((String)strInDate);
        }
        return dt;
    }

    public static Date nextMonth() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, 1);
        return cal.getTime();
    }

    public static Date addMonth(Date dtDate, int nMonths) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtDate);
        cal.add(2, nMonths);
        return cal.getTime();
    }

    public static Date addMonth(int nMonths) {
        Calendar cal = Calendar.getInstance();
        cal.add(2, nMonths);
        return cal.getTime();
    }

    public static Date addDate(int nDays) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, nDays);
        return cal.getTime();
    }

    public static Date addDate(Date dtDate, int nDays) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtDate);
        cal.add(5, nDays);
        return cal.getTime();
    }

    public static int getYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    public static int getMonth() {
        Calendar cal = Calendar.getInstance();
        return cal.get(2) + 1;
    }

    public static int[] getDateRange(Date date) {
        int[] nRange = new int[2];
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        nRange[0] = cal.get(1);
        nRange[1] = cal.get(2) + 1;
        return nRange;
    }

    public static Date clearToDate(Date dt) {
        Calendar c = Calendar.getInstance();
        c.setTime(dt);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static int DateDiff(Date dtFrom, Date dtTo) {
        if (dtFrom == null || dtTo == null) {
            return 0;
        }
        dtFrom = DateUtil.clearToDate(dtFrom);
        dtTo = DateUtil.clearToDate(dtTo);
        long l1 = dtFrom.getTime();
        long l2 = dtTo.getTime();
        long l3 = l1 - l2;
        int days = (int)(l3 / 1000L / 60L / 60L / 24L);
        return days;
    }

    public static String getMonthBeginDay(String Year, String MonthFrom) {
        String strMonthBeginDay = String.valueOf(Year) + "-" + MonthFrom + "-1";
        return strMonthBeginDay;
    }

    public static String getMonthEndDay(String Year, String MonthTo) {
        String strMonthEndDay = "";
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(Year));
        cal.set(2, Integer.parseInt(MonthTo) - 1);
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(5, -1);
        strMonthEndDay = String.valueOf(cal.get(1)) + "-" + (cal.get(2) + 1) + "-" + cal.get(5);
        return strMonthEndDay;
    }

    public static String getMonthBeginDay(String YearMonth) {
        String strMonthBeginDay = "";
        if (YearMonth != null && YearMonth.length() > 5) {
            String year = YearMonth.substring(0, 4);
            String month = YearMonth.substring(5, 6);
            strMonthBeginDay = DateUtil.getMonthBeginDay(year, month);
        }
        return strMonthBeginDay;
    }

    public static String getMonthEndDay(String YearMonth) {
        String strMonthEndDay = "";
        if (YearMonth != null && YearMonth.length() > 5) {
            String year = YearMonth.substring(0, 4);
            String month = YearMonth.substring(5, 6);
            strMonthEndDay = DateUtil.getMonthEndDay(year, month);
        }
        return strMonthEndDay;
    }
}

