/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security3;

import flex.messaging.HttpFlexSession;
import flex.messaging.HttpFlexSessionProvider;
import flex.messaging.MessageBroker;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;

public class FlexSessionAwareSessionAuthenticationStrategy
implements SessionAuthenticationStrategy {
    private final SessionAuthenticationStrategy delegate;

    public FlexSessionAwareSessionAuthenticationStrategy(SessionAuthenticationStrategy delegate) {
        this.delegate = delegate;
    }

    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) throws SessionAuthenticationException {
        HttpSession currentSession = request.getSession(false);
        String sessionId = currentSession != null ? currentSession.getId() : null;
        this.delegate.onAuthentication(authentication, request, response);
        currentSession = request.getSession(false);
        if (currentSession != null && !currentSession.getId().equals(sessionId)) {
            if (currentSession.getAttribute("__flexSession") != null) {
                currentSession.removeAttribute("__flexSession");
            }
            HttpFlexSessionProvider provider = (HttpFlexSessionProvider)MessageBroker.getMessageBroker((String)"_messageBroker").getFlexSessionManager().getFlexSessionProvider(HttpFlexSession.class);
            provider.getOrCreateSession(request);
        }
    }
}

