/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.messaging.jms;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.util.Enumeration;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexMessageConverter
implements MessageConverter {
    private static final String HEADER_PREFIX = "spring_flex_";
    private static final String FLEX_CLIENT_ID = "spring_flex_clientId";
    private static final String FLEX_TIME_TO_LIVE = "spring_flex_timeToLive";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final MessageConverter targetConverter;

    public FlexMessageConverter() {
        this(null);
    }

    public FlexMessageConverter(MessageConverter targetConverter) {
        this.targetConverter = targetConverter != null ? targetConverter : new SimpleMessageConverter();
    }

    public Object fromMessage(javax.jms.Message message) throws JMSException, MessageConversionException {
        Object messageBody = this.targetConverter.fromMessage(message);
        AsyncMessage flexMessage = new AsyncMessage();
        flexMessage.setBody(messageBody);
        flexMessage.setMessageId(message.getJMSMessageID());
        flexMessage.setClientId(message.getObjectProperty(FLEX_CLIENT_ID));
        flexMessage.setTimestamp(message.getJMSTimestamp());
        Object timeToLive = message.getObjectProperty(FLEX_TIME_TO_LIVE);
        if (timeToLive != null && Long.TYPE.isAssignableFrom(timeToLive.getClass())) {
            flexMessage.setTimeToLive(Long.parseLong(timeToLive.toString()));
        }
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            if (name.startsWith(HEADER_PREFIX)) continue;
            flexMessage.setHeader(name, message.getObjectProperty(name));
        }
        return flexMessage;
    }

    public javax.jms.Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        Assert.state((boolean)(object instanceof Message), (String)"FlexMessageConverter can only handle Flex Messages");
        Message flexMessage = (Message)object;
        Object messageBody = flexMessage.getBody();
        javax.jms.Message jmsMessage = this.targetConverter.toMessage(messageBody, session);
        jmsMessage.setObjectProperty(FLEX_CLIENT_ID, flexMessage.getClientId());
        jmsMessage.setLongProperty(FLEX_TIME_TO_LIVE, flexMessage.getTimeToLive());
        Map<String, Object> headers = this.getFlexMessageHeaderMap(flexMessage);
        for (String key : headers.keySet()) {
            Object value = flexMessage.getHeader(key);
            try {
                jmsMessage.setObjectProperty(key, value);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("failed to copy Flex header '" + key + "'"), (Throwable)e);
            }
        }
        return jmsMessage;
    }

    private Map<String, Object> getFlexMessageHeaderMap(Message flexMessage) {
        return flexMessage.getHeaders();
    }
}

