/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.http;

import flex.messaging.FlexContext;
import flex.messaging.MessageException;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.Amf3Input;
import flex.messaging.io.amf.Amf3Output;
import flex.messaging.io.amf.AmfMessageDeserializer;
import flex.messaging.io.amf.AmfMessageSerializer;
import flex.messaging.io.amf.AmfTrace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmfHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private static final String AMF_ERROR = "Could not read input message body as AMF";
    private static final String ACTION_MSG_ERROR = "Could not read input message body as " + ActionMessage.class.getName();
    private static final Log log = LogFactory.getLog(AmfHttpMessageConverter.class);

    public AmfHttpMessageConverter() {
        super(MediaType.parseMediaType((String)"application/x-amf"));
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        try {
            AmfTrace trace = null;
            if (log.isDebugEnabled()) {
                trace = new AmfTrace();
            }
            Object result = null;
            result = clazz.equals(ActionMessage.class) ? this.readActionMessage(inputMessage, trace) : this.readObject(inputMessage, trace);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read AMF message:\n" + trace));
            }
            Object object = result;
            return object;
        }
        finally {
            FlexContext.clearThreadLocalObjects();
            SerializationContext.clearThreadLocalObjects();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInternal(Object data, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try {
            AmfTrace trace = null;
            if (log.isDebugEnabled()) {
                trace = new AmfTrace();
            }
            outputMessage.getHeaders().setPragma("no-cache");
            outputMessage.getHeaders().setCacheControl("no-cache, no-store, max-age=0");
            outputMessage.getHeaders().setExpires(1L);
            if (data instanceof ActionMessage) {
                this.writeActionMessage((ActionMessage)data, outputMessage, trace);
            } else {
                this.writeObject(data, outputMessage, trace);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wrote AMF message:\n" + trace));
            }
        }
        finally {
            FlexContext.clearThreadLocalObjects();
            SerializationContext.clearThreadLocalObjects();
        }
    }

    private Object readObject(HttpInputMessage inputMessage, AmfTrace trace) throws IOException {
        Amf3Input deserializer = new Amf3Input(new SerializationContext());
        deserializer.setInputStream(inputMessage.getBody());
        deserializer.setDebugTrace(trace);
        try {
            return deserializer.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HttpMessageNotReadableException(AMF_ERROR, (Throwable)cnfe);
        }
        catch (MessageException se) {
            throw new HttpMessageNotReadableException(AMF_ERROR, (Throwable)se);
        }
    }

    private ActionMessage readActionMessage(HttpInputMessage inputMessage, AmfTrace trace) throws IOException {
        AmfMessageDeserializer deserializer = new AmfMessageDeserializer();
        deserializer.initialize(new SerializationContext(), inputMessage.getBody(), trace);
        try {
            ActionContext context = new ActionContext();
            ActionMessage message = new ActionMessage();
            context.setRequestMessage(message);
            deserializer.readMessage(message, context);
            return message;
        }
        catch (ClassNotFoundException cnfe) {
            throw new HttpMessageNotReadableException(ACTION_MSG_ERROR, (Throwable)cnfe);
        }
        catch (MessageException me) {
            throw new HttpMessageNotReadableException(ACTION_MSG_ERROR, (Throwable)me);
        }
    }

    private void writeActionMessage(ActionMessage message, HttpOutputMessage outputMessage, AmfTrace trace) throws IOException {
        AmfMessageSerializer serializer = new AmfMessageSerializer();
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        serializer.setVersion(message.getVersion());
        serializer.initialize(new SerializationContext(), (OutputStream)outBuffer, trace);
        try {
            ActionContext context = new ActionContext();
            context.setVersion(message.getVersion());
            context.setResponseMessage(message);
            serializer.writeMessage(message);
            outBuffer.flush();
            outBuffer.close();
            outputMessage.getHeaders().setContentLength((long)outBuffer.size());
            outBuffer.writeTo(outputMessage.getBody());
        }
        catch (SerializationException se) {
            throw new HttpMessageNotWritableException("Could not write " + message + " as AMF message.", (Throwable)se);
        }
    }

    private void writeObject(Object data, HttpOutputMessage outputMessage, AmfTrace trace) throws IOException {
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        Amf3Output serializer = new Amf3Output(new SerializationContext());
        serializer.setOutputStream((OutputStream)outBuffer);
        serializer.setDebugTrace(trace);
        try {
            serializer.writeObject(data);
            outBuffer.flush();
            outBuffer.close();
            outputMessage.getHeaders().setContentLength((long)outBuffer.size());
            outBuffer.writeTo(outputMessage.getBody());
        }
        catch (SerializationException se) {
            throw new HttpMessageNotWritableException("Could not write " + data + " as AMF message.", (Throwable)se);
        }
    }
}

